/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.shaded.com.addthis.metrics3.reporter.config;

import com.codahale.metrics.MetricRegistry;
import com.izettle.metrics.influxdb.InfluxDbHttpSender;
import com.izettle.metrics.influxdb.InfluxDbReporter;
import com.izettle.metrics.influxdb.InfluxDbSender;
import java.util.List;
import org.cassandraunit.shaded.com.addthis.metrics.reporter.config.AbstractInfluxDBReporterConfig;
import org.cassandraunit.shaded.com.addthis.metrics.reporter.config.HostPort;
import org.cassandraunit.shaded.com.addthis.metrics3.reporter.config.MetricFilterTransformer;
import org.cassandraunit.shaded.com.addthis.metrics3.reporter.config.MetricsReporterConfigThree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxDBReporterConfig
extends AbstractInfluxDBReporterConfig
implements MetricsReporterConfigThree {
    private static final Logger log = LoggerFactory.getLogger(InfluxDBReporterConfig.class);
    private InfluxDbReporter reporter;

    private void enableMetrics3(HostPort hostPort, MetricRegistry registry) throws Exception {
        InfluxDbHttpSender influxDbSender = new InfluxDbHttpSender(this.getProtocol(), hostPort.getHost(), hostPort.getPort(), this.getDbName(), this.getAuth(), this.getRealRateunit(), this.getConnectionTimeout(), this.getReadTimeout(), this.getResolvedPrefix());
        this.reporter = InfluxDbReporter.forRegistry((MetricRegistry)registry).convertRatesTo(this.getRealRateunit()).convertDurationsTo(this.getRealDurationunit()).withTags(this.getResolvedTags()).filter(MetricFilterTransformer.generateFilter(this.getPredicate())).build((InfluxDbSender)influxDbSender);
        this.reporter.start(this.getPeriod(), this.getRealTimeunit());
    }

    @Override
    public void report() {
        if (this.reporter != null) {
            this.reporter.report();
        }
    }

    @Override
    public boolean enable(MetricRegistry registry) {
        boolean success = this.checkClass("com.izettle.metrics.influxdb.InfluxDbReporter");
        if (!success) {
            return false;
        }
        List<HostPort> hosts = this.getFullHostList();
        if (hosts == null || hosts.isEmpty()) {
            log.error("No hosts specified, cannot enable InfluxDBReporter");
            return false;
        }
        if (hosts.size() != 1) {
            log.error("Only 1 host can be specified, cannot enable InfluxDBReporter");
            return false;
        }
        HostPort hostPort = hosts.get(0);
        log.info("Enabling InfluxDBReporter to {}:{}", (Object)hostPort.getHost(), (Object)hostPort.getPort());
        try {
            this.enableMetrics3(hostPort, registry);
        }
        catch (Exception e) {
            log.error("Failed to enable InfluxDBReporter for {}:{}", new Object[]{hostPort.getHost(), hostPort.getPort(), e});
            return false;
        }
        return true;
    }

    private boolean checkClass(String className) {
        if (!this.isClassAvailable(className)) {
            log.error("Tried to enable InfluxDBReporter, but class {} was not found", (Object)className);
            return false;
        }
        return true;
    }
}

