/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.shaded.com.addthis.metrics3.reporter.config.prometheus;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import io.prometheus.client.Collector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricRegistryDecorator
extends Collector {
    private static final Logger logger = LoggerFactory.getLogger(MetricRegistryDecorator.class);
    private final MetricRegistry registry;
    private final List<String> labelNames = new ArrayList<String>();
    private final List<String> labelValues = new ArrayList<String>();

    public MetricRegistryDecorator(MetricRegistry registry, String job, Map<String, String> labels) {
        this.registry = registry;
        this.labelNames.add("job");
        this.labelValues.add(job);
        for (Map.Entry<String, String> entry : labels.entrySet()) {
            this.labelNames.add(entry.getKey());
            this.labelValues.add(entry.getValue());
        }
    }

    private static String getHelpMessage(String metricName, Metric metric) {
        return String.format("Generated from dropwizard metric import (metric=%s, type=%s)", metricName, metric.getClass().getName());
    }

    public Collector.MetricFamilySamples fromCounter(String name, Counter counter) {
        Collector.MetricFamilySamples.Sample sample = new Collector.MetricFamilySamples.Sample(name, this.labelNames, this.labelValues, new Long(counter.getCount()).doubleValue());
        return new Collector.MetricFamilySamples(name, Collector.Type.GAUGE, MetricRegistryDecorator.getHelpMessage(name, (Metric)counter), Arrays.asList(sample));
    }

    public Collector.MetricFamilySamples fromGauge(String name, Gauge gauge) {
        double value;
        Object obj = gauge.getValue();
        ArrayList<String> labelNames = new ArrayList<String>(this.labelNames);
        ArrayList<String> labelValues = new ArrayList<String>(this.labelValues);
        if (obj instanceof Number) {
            value = ((Number)obj).doubleValue();
        } else if (obj instanceof Boolean) {
            value = (Boolean)obj != false ? 1.0 : 0.0;
        } else if (obj instanceof String) {
            labelNames.add("gauge_value");
            labelValues.add((String)obj);
            value = 1.0;
        } else {
            return null;
        }
        Collector.MetricFamilySamples.Sample sample = new Collector.MetricFamilySamples.Sample(name, labelNames, labelValues, value);
        return new Collector.MetricFamilySamples(name, Collector.Type.GAUGE, MetricRegistryDecorator.getHelpMessage(name, (Metric)gauge), Arrays.asList(sample));
    }

    public Collector.MetricFamilySamples fromHistogram(String name, Histogram histogram) {
        return this.fromSnapshotAndCount(name, histogram.getSnapshot(), histogram.getCount(), 1.0, MetricRegistryDecorator.getHelpMessage(name, (Metric)histogram));
    }

    public Collector.MetricFamilySamples fromTimer(String name, Timer timer) {
        return this.fromSnapshotAndCount(name, timer.getSnapshot(), timer.getCount(), 1.0 / (double)TimeUnit.SECONDS.toNanos(1L), MetricRegistryDecorator.getHelpMessage(name, (Metric)timer));
    }

    public Collector.MetricFamilySamples fromMeter(String name, Meter meter) {
        List<Collector.MetricFamilySamples.Sample> samples = Arrays.asList(new Collector.MetricFamilySamples.Sample(name + "_total", this.labelNames, this.labelValues, (double)meter.getCount()));
        return new Collector.MetricFamilySamples(name + "_total", Collector.Type.COUNTER, MetricRegistryDecorator.getHelpMessage(name, (Metric)meter), samples);
    }

    public Collector.MetricFamilySamples fromSnapshotAndCount(String name, Snapshot snapshot, long count, double factor, String helpMessage) {
        List<String> labelNames = MetricRegistryDecorator.addToEnd(this.labelNames, "quantile");
        List<Collector.MetricFamilySamples.Sample> samples = Arrays.asList(new Collector.MetricFamilySamples.Sample(name, labelNames, MetricRegistryDecorator.addToEnd(this.labelValues, "0.5"), snapshot.getMedian() * factor), new Collector.MetricFamilySamples.Sample(name, labelNames, MetricRegistryDecorator.addToEnd(this.labelValues, "0.75"), snapshot.get75thPercentile() * factor), new Collector.MetricFamilySamples.Sample(name, labelNames, MetricRegistryDecorator.addToEnd(this.labelValues, "0.95"), snapshot.get95thPercentile() * factor), new Collector.MetricFamilySamples.Sample(name, labelNames, MetricRegistryDecorator.addToEnd(this.labelValues, "0.98"), snapshot.get98thPercentile() * factor), new Collector.MetricFamilySamples.Sample(name, labelNames, MetricRegistryDecorator.addToEnd(this.labelValues, "0.99"), snapshot.get99thPercentile() * factor), new Collector.MetricFamilySamples.Sample(name, labelNames, MetricRegistryDecorator.addToEnd(this.labelValues, "0.999"), snapshot.get999thPercentile() * factor), new Collector.MetricFamilySamples.Sample(name + "_count", new ArrayList(), new ArrayList(), (double)count));
        return new Collector.MetricFamilySamples(name, Collector.Type.SUMMARY, helpMessage, samples);
    }

    private static List<String> addToEnd(List<String> list, String value) {
        ArrayList<String> copy = new ArrayList<String>(list);
        copy.add(value);
        return copy;
    }

    public List<Collector.MetricFamilySamples> collect() {
        Collector.MetricFamilySamples sample;
        ArrayList<Collector.MetricFamilySamples> metricFamilySamples = new ArrayList<Collector.MetricFamilySamples>();
        for (Map.Entry entry : this.registry.getGauges().entrySet()) {
            sample = this.fromGauge(MetricRegistryDecorator.sanitizeMetricName((String)((String)entry.getKey())), (Gauge)entry.getValue());
            if (sample == null) continue;
            metricFamilySamples.add(sample);
        }
        for (Map.Entry entry : this.registry.getCounters().entrySet()) {
            sample = this.fromCounter(MetricRegistryDecorator.sanitizeMetricName((String)((String)entry.getKey())), (Counter)entry.getValue());
            if (sample == null) continue;
            metricFamilySamples.add(sample);
        }
        for (Map.Entry entry : this.registry.getHistograms().entrySet()) {
            sample = this.fromHistogram(MetricRegistryDecorator.sanitizeMetricName((String)((String)entry.getKey())), (Histogram)entry.getValue());
            if (sample == null) continue;
            metricFamilySamples.add(sample);
        }
        for (Map.Entry entry : this.registry.getTimers().entrySet()) {
            sample = this.fromTimer(MetricRegistryDecorator.sanitizeMetricName((String)((String)entry.getKey())), (Timer)entry.getValue());
            if (sample == null) continue;
            metricFamilySamples.add(sample);
        }
        for (Map.Entry entry : this.registry.getMeters().entrySet()) {
            sample = this.fromMeter(MetricRegistryDecorator.sanitizeMetricName((String)((String)entry.getKey())), (Meter)entry.getValue());
            if (sample == null) continue;
            metricFamilySamples.add(sample);
        }
        return metricFamilySamples;
    }
}

