/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.shaded.org.antlr.codegen;

import java.util.ArrayList;
import java.util.List;
import org.cassandraunit.shaded.org.antlr.codegen.CodeGenerator;
import org.cassandraunit.shaded.org.antlr.codegen.Target;
import org.cassandraunit.shaded.org.antlr.runtime.Token;
import org.cassandraunit.shaded.org.antlr.tool.Grammar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Python3Target
extends Target {
    @Override
    public boolean useBaseTemplatesForSynPredFragments() {
        return false;
    }

    @Override
    public String getTokenTypeAsTargetLabel(CodeGenerator generator, int ttype) {
        if (ttype >= 0 && ttype <= 3) {
            return String.valueOf(ttype);
        }
        String name = generator.grammar.getTokenDisplayName(ttype);
        if (name.charAt(0) == '\'') {
            return String.valueOf(ttype);
        }
        return name;
    }

    @Override
    public String getTargetCharLiteralFromANTLRCharLiteral(CodeGenerator generator, String literal) {
        int c = Grammar.getCharValueFromGrammarCharLiteral(literal);
        return String.valueOf(c);
    }

    private List<String> splitLines(String text) {
        ArrayList<String> l = new ArrayList<String>();
        int idx = 0;
        while (true) {
            int eol;
            if ((eol = text.indexOf("\n", idx)) == -1) break;
            l.add(text.substring(idx, eol + 1));
            idx = eol + 1;
        }
        l.add(text.substring(idx));
        return l;
    }

    @Override
    public List<Object> postProcessAction(List<Object> chunks, Token actionToken) {
        int lastChunk;
        ArrayList<Object> nChunks = new ArrayList<Object>();
        for (int i = 0; i < chunks.size(); ++i) {
            Object chunk = chunks.get(i);
            if (chunk instanceof String) {
                String text = (String)chunks.get(i);
                if (nChunks.isEmpty() && actionToken.getCharPositionInLine() >= 0) {
                    String ws = "";
                    for (int j = 0; j < actionToken.getCharPositionInLine(); ++j) {
                        ws = ws + " ";
                    }
                    text = ws + text;
                }
                nChunks.addAll(this.splitLines(text));
                continue;
            }
            if (nChunks.isEmpty() && actionToken.getCharPositionInLine() >= 0) {
                String ws = "";
                for (int j = 0; j <= actionToken.getCharPositionInLine(); ++j) {
                    ws = ws + " ";
                }
                nChunks.add(ws);
            }
            nChunks.add(chunk);
        }
        int lineNo = actionToken.getLine();
        int col = 0;
        for (lastChunk = nChunks.size() - 1; lastChunk > 0 && nChunks.get(lastChunk) instanceof String && ((String)nChunks.get(lastChunk)).trim().length() == 0; --lastChunk) {
        }
        for (int firstChunk = 0; firstChunk <= lastChunk && nChunks.get(firstChunk) instanceof String && ((String)nChunks.get(firstChunk)).trim().length() == 0 && ((String)nChunks.get(firstChunk)).endsWith("\n"); ++firstChunk) {
            ++lineNo;
        }
        int indent = -1;
        for (int i = firstChunk; i <= lastChunk; ++i) {
            Object chunk = nChunks.get(i);
            if (chunk instanceof String) {
                String text = (String)chunk;
                if (col == 0) {
                    int j;
                    if (indent == -1) {
                        indent = 0;
                        for (j = 0; j < text.length() && Character.isWhitespace(text.charAt(j)); ++j) {
                            ++indent;
                        }
                    }
                    if (text.length() >= indent) {
                        for (j = 0; j < indent; ++j) {
                            if (Character.isWhitespace(text.charAt(j))) continue;
                            System.err.println("Warning: badly indented line " + lineNo + " in action:");
                            System.err.println(text);
                            break;
                        }
                        nChunks.set(i, text.substring(j));
                    } else if (text.trim().length() > 0) {
                        System.err.println("Warning: badly indented line " + lineNo + " in action:");
                        System.err.println(text);
                    }
                }
                if (text.endsWith("\n")) {
                    ++lineNo;
                    col = 0;
                    continue;
                }
                col += text.length();
                continue;
            }
            ++col;
        }
        return nChunks;
    }
}

