/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.shaded.org.antlr.tool;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.cassandraunit.shaded.org.antlr.codegen.CodeGenerator;
import org.cassandraunit.shaded.org.antlr.runtime.Token;
import org.cassandraunit.shaded.org.antlr.tool.Attribute;
import org.cassandraunit.shaded.org.antlr.tool.ErrorManager;
import org.cassandraunit.shaded.org.antlr.tool.Grammar;
import org.cassandraunit.shaded.org.antlr.tool.GrammarAST;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeScope {
    public static final AttributeScope tokenScope = new AttributeScope("Token", null);
    public Token derivedFromToken;
    public Grammar grammar;
    private String name;
    public boolean isDynamicGlobalScope;
    public boolean isDynamicRuleScope;
    public boolean isParameterScope;
    public boolean isReturnScope;
    public boolean isPredefinedRuleScope;
    public boolean isPredefinedLexerRuleScope;
    protected LinkedHashMap<String, Attribute> attributes = new LinkedHashMap();
    public LinkedHashMap<String, GrammarAST> actions = new LinkedHashMap();

    public AttributeScope(String name, Token derivedFromToken) {
        this(null, name, derivedFromToken);
    }

    public AttributeScope(Grammar grammar, String name, Token derivedFromToken) {
        this.grammar = grammar;
        this.name = name;
        this.derivedFromToken = derivedFromToken;
    }

    public String getName() {
        if (this.isParameterScope) {
            return this.name + "_parameter";
        }
        if (this.isReturnScope) {
            return this.name + "_return";
        }
        return this.name;
    }

    public void addAttributes(String definitions, int separator) {
        ArrayList<String> attrs = new ArrayList<String>();
        CodeGenerator.getListOfArgumentsFromAction(definitions, 0, -1, separator, attrs);
        for (String a : attrs) {
            Attribute attr = new Attribute(a);
            if (!this.isReturnScope && attr.initValue != null) {
                ErrorManager.grammarError(148, this.grammar, this.derivedFromToken, attr.name);
                attr.initValue = null;
            }
            this.attributes.put(attr.name, attr);
        }
    }

    public void addAttribute(String name, String decl) {
        this.attributes.put(name, new Attribute(name, decl));
    }

    public final void defineNamedAction(GrammarAST nameAST, GrammarAST actionAST) {
        String actionName = nameAST.getText();
        GrammarAST a = this.actions.get(actionName);
        if (a != null) {
            ErrorManager.grammarError(144, this.grammar, nameAST.getToken(), nameAST.getText());
        } else {
            this.actions.put(actionName, actionAST);
        }
    }

    public Attribute getAttribute(String name) {
        return this.attributes.get(name);
    }

    public List<Attribute> getAttributes() {
        ArrayList<Attribute> a = new ArrayList<Attribute>();
        a.addAll(this.attributes.values());
        return a;
    }

    public Set<String> intersection(AttributeScope other) {
        if (other == null || other.size() == 0 || this.size() == 0) {
            return null;
        }
        HashSet<String> inter = new HashSet<String>();
        Set<String> thisKeys = this.attributes.keySet();
        for (String key : thisKeys) {
            if (other.attributes.get(key) == null) continue;
            inter.add(key);
        }
        if (inter.isEmpty()) {
            return null;
        }
        return inter;
    }

    public int size() {
        return this.attributes == null ? 0 : this.attributes.size();
    }

    public String toString() {
        return (this.isDynamicGlobalScope ? "global " : "") + this.getName() + ":" + this.attributes;
    }

    static {
        tokenScope.addAttribute("text", null);
        tokenScope.addAttribute("type", null);
        tokenScope.addAttribute("line", null);
        tokenScope.addAttribute("index", null);
        tokenScope.addAttribute("pos", null);
        tokenScope.addAttribute("channel", null);
        tokenScope.addAttribute("tree", null);
        tokenScope.addAttribute("int", null);
    }
}

