/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.spring;

import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import org.cassandraunit.CQLDataLoader;
import org.cassandraunit.dataset.CQLDataSet;
import org.cassandraunit.dataset.cql.ClassPathCQLDataSet;
import org.cassandraunit.spring.CassandraDataSet;
import org.cassandraunit.spring.CassandraUnitTestExecutionListener;
import org.cassandraunit.spring.EmbeddedCassandra;
import org.cassandraunit.utils.EmbeddedCassandraServerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.util.ClassUtils;

public abstract class AbstractCassandraUnitTestExecutionListener
extends AbstractTestExecutionListener
implements Ordered {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraUnitTestExecutionListener.class);
    private static boolean initialized = false;

    protected void startServer(TestContext testContext) throws Exception {
        CassandraDataSet cassandraDataSet;
        EmbeddedCassandra embeddedCassandra = (EmbeddedCassandra)Objects.requireNonNull(AnnotationUtils.findAnnotation((Class)testContext.getTestClass(), EmbeddedCassandra.class), "CassandraUnitTestExecutionListener must be used with @EmbeddedCassandra on " + testContext.getTestClass());
        if (!initialized) {
            String yamlFile = Optional.ofNullable(embeddedCassandra.configuration()).get();
            String tmpDir = embeddedCassandra.tmpDir();
            long timeout = embeddedCassandra.timeout();
            EmbeddedCassandraServerHelper.startEmbeddedCassandra((String)yamlFile, (String)tmpDir, (long)timeout);
            initialized = true;
        }
        if ((cassandraDataSet = (CassandraDataSet)AnnotationUtils.findAnnotation((Class)testContext.getTestClass(), CassandraDataSet.class)) != null) {
            String keyspace = cassandraDataSet.keyspace();
            List<String> dataset = this.dataSetLocations(testContext, cassandraDataSet);
            ListIterator<String> datasetIterator = dataset.listIterator();
            CQLDataLoader cqlDataLoader = new CQLDataLoader(EmbeddedCassandraServerHelper.getSession());
            while (datasetIterator.hasNext()) {
                String next = datasetIterator.next();
                boolean dropAndCreateKeyspace = datasetIterator.previousIndex() == 0;
                cqlDataLoader.load((CQLDataSet)new ClassPathCQLDataSet(next, dropAndCreateKeyspace, dropAndCreateKeyspace, keyspace));
            }
        }
    }

    private List<String> dataSetLocations(TestContext testContext, CassandraDataSet cassandraDataSet) {
        String[] dataset = cassandraDataSet.value();
        if (dataset.length == 0) {
            String alternativePath = this.alternativePath(testContext.getTestClass(), true, cassandraDataSet.type().name());
            if (testContext.getApplicationContext().getResource(alternativePath).exists()) {
                dataset = new String[]{alternativePath.replace("classpath:/", "")};
            } else {
                alternativePath = this.alternativePath(testContext.getTestClass(), false, cassandraDataSet.type().name());
                if (testContext.getApplicationContext().getResource(alternativePath).exists()) {
                    dataset = new String[]{alternativePath.replace("classpath:/", "")};
                } else {
                    LOGGER.info("No dataset will be loaded");
                }
            }
        }
        return Arrays.asList(dataset);
    }

    protected void cleanServer() {
        EmbeddedCassandraServerHelper.cleanEmbeddedCassandra();
    }

    protected String alternativePath(Class<?> clazz, boolean includedPackageName, String extension) {
        if (includedPackageName) {
            return "classpath:/" + ClassUtils.convertClassNameToResourcePath((String)clazz.getName()) + "-dataset." + extension;
        }
        return "classpath:/" + clazz.getSimpleName() + "-dataset." + extension;
    }

    public int getOrder() {
        return 0;
    }
}

