/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.nullaway.dataflow.constantpropagation;

import java.util.Objects;
import org.checkerframework.nullaway.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.nullaway.checker.nullness.qual.Nullable;
import org.checkerframework.nullaway.dataflow.analysis.AbstractValue;
import org.checkerframework.nullaway.javacutil.BugInCF;

public class Constant
implements AbstractValue<Constant> {
    protected final Type type;
    protected @Nullable Integer value;

    public Constant(Type type) {
        assert (type != Type.CONSTANT);
        this.type = type;
    }

    public Constant(Integer value) {
        this.type = Type.CONSTANT;
        this.value = value;
    }

    public boolean isTop() {
        return this.type == Type.TOP;
    }

    public boolean isBottom() {
        return this.type == Type.BOTTOM;
    }

    @EnsuresNonNullIf(result=true, expression={"value"})
    public boolean isConstant() {
        return this.type == Type.CONSTANT && this.value != null;
    }

    public Integer getValue() {
        assert (this.isConstant()) : "@AssumeAssertion(nullness): inspection";
        return this.value;
    }

    public Constant copy() {
        if (this.isConstant()) {
            return new Constant(this.value);
        }
        return new Constant(this.type);
    }

    @Override
    public Constant leastUpperBound(Constant other) {
        if (other.isBottom()) {
            return this.copy();
        }
        if (this.isBottom()) {
            return other.copy();
        }
        if (other.isTop() || this.isTop()) {
            return new Constant(Type.TOP);
        }
        if (other.getValue().equals(this.getValue())) {
            return this.copy();
        }
        return new Constant(Type.TOP);
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof Constant)) {
            return false;
        }
        Constant other = (Constant)obj;
        return this.type == other.type && Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.value});
    }

    public String toString() {
        switch (this.type.ordinal()) {
            case 1: {
                return "T";
            }
            case 2: {
                return "-";
            }
            case 0: {
                assert (this.isConstant()) : "@AssumeAssertion(nullness)";
                return this.value.toString();
            }
        }
        throw new BugInCF("Unexpected type: " + (Object)((Object)this.type));
    }

    public static enum Type {
        CONSTANT,
        TOP,
        BOTTOM;

    }
}

