/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.ant;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.codehaus.cargo.ant.ConfigurationElement;
import org.codehaus.cargo.ant.DaemonElement;
import org.codehaus.cargo.ant.DeployableElement;
import org.codehaus.cargo.ant.PropertySet;
import org.codehaus.cargo.ant.ZipURLInstallerElement;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.RemoteContainer;
import org.codehaus.cargo.container.State;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployer.DeployableMonitor;
import org.codehaus.cargo.container.deployer.Deployer;
import org.codehaus.cargo.container.installer.ZipURLInstaller;
import org.codehaus.cargo.container.spi.deployer.DeployerWatchdog;
import org.codehaus.cargo.container.spi.util.ContainerUtils;
import org.codehaus.cargo.generic.ContainerFactory;
import org.codehaus.cargo.generic.DefaultContainerFactory;
import org.codehaus.cargo.generic.deployer.DefaultDeployerFactory;
import org.codehaus.cargo.generic.deployer.DeployerFactory;
import org.codehaus.cargo.tools.daemon.DaemonClient;
import org.codehaus.cargo.tools.daemon.DaemonStart;
import org.codehaus.cargo.util.log.AntLogger;
import org.codehaus.cargo.util.log.FileLogger;
import org.codehaus.cargo.util.log.LogLevel;
import org.codehaus.cargo.util.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CargoTask
extends Task {
    private static final String ACTION_CONFIGURE = "configure";
    private static final String ACTION_START = "start";
    private static final String ACTION_RESTART = "restart";
    private static final String ACTION_RUN = "run";
    private static final String ACTION_STOP = "stop";
    private static final String ACTIONS_DAEMON_PREFIX = "daemon-";
    private static final String ACTION_DAEMON_START = "daemon-start";
    private static final String ACTION_DAEMON_STOP = "daemon-stop";
    private static final List<String> LOCAL_ACTIONS = Arrays.asList("start", "restart", "run", "stop", "configure", "daemon-start", "daemon-stop");
    private static final String ACTION_DEPLOY = "deploy";
    private static final String ACTION_UNDEPLOY = "undeploy";
    private static final String ACTION_REDEPLOY = "redeploy";
    private static final List<String> DEPLOYER_ACTIONS = Arrays.asList("deploy", "undeploy", "redeploy");
    private String action;
    private String id;
    private Reference refid;
    private String containerId;
    private ContainerType containerType = ContainerType.INSTALLED;
    private Map<String, String> systemProperties = new HashMap<String, String>();
    private File systemPropertiesFile;
    private Path extraClasspath;
    private Path sharedClasspath;
    private String output;
    private File log;
    private LogLevel logLevel;
    private boolean append;
    private String home;
    private long timeout;
    private ZipURLInstallerElement zipURLInstallerElement;
    private ConfigurationElement configurationElement;
    private DaemonElement daemonElement;
    private ContainerFactory containerFactory = new DefaultContainerFactory();
    private DeployerFactory deployerFactory = new DefaultDeployerFactory();
    private Class containerClass;
    private Container container;
    private Logger logger;

    public void setClass(Class containerClass) {
        this.containerClass = containerClass;
    }

    protected final Class getContainerClass() {
        return this.containerClass;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public void setType(ContainerType type) {
        this.containerType = type;
    }

    public void setHome(String home) {
        this.home = home;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setRefId(Reference refid) {
        this.refid = refid;
    }

    public ZipURLInstallerElement createZipURLInstaller() {
        if (this.getZipURLInstaller() == null) {
            this.zipURLInstallerElement = new ZipURLInstallerElement();
        }
        return this.zipURLInstallerElement;
    }

    public ConfigurationElement createConfiguration() {
        if (this.getConfiguration() == null) {
            this.configurationElement = new ConfigurationElement();
        }
        return this.configurationElement;
    }

    public DaemonElement createDaemon() {
        if (this.getDaemon() == null) {
            this.daemonElement = new DaemonElement();
        }
        return this.daemonElement;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public void setLog(File log) {
        this.log = log;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = LogLevel.toLevel((String)logLevel);
    }

    public void setAppend(boolean isAppend) {
        this.append = isAppend;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public Path createExtraClasspath() {
        if (this.getExtraClasspath() == null) {
            this.extraClasspath = new Path(this.getProject());
        }
        return this.extraClasspath.createPath();
    }

    public Path createSharedClasspath() {
        if (this.getSharedClasspath() == null) {
            this.sharedClasspath = new Path(this.getProject());
        }
        return this.sharedClasspath.createPath();
    }

    public void addSysproperty(Environment.Variable property) {
        this.getSystemProperties().put(property.getKey(), property.getValue());
    }

    public void setSystemPropertiesFile(File systemPropertiesFile) {
        this.systemPropertiesFile = systemPropertiesFile;
    }

    public void addConfiguredSyspropertyset(PropertySet propertySet) {
        ResourceBundle bundle = propertySet.readProperties();
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            Environment.Variable var = new Environment.Variable();
            var.setKey(key);
            var.setValue(bundle.getString(key));
            this.addSysproperty(var);
        }
    }

    public void addConfiguredSysproperty(Environment.Variable property) {
        this.addSysproperty(property);
    }

    private void createCargoLogger() {
        this.logger = this.getLog() != null ? new FileLogger(this.getLog(), true) : new AntLogger(this.getProject());
        if (this.getLogLevel() != null) {
            this.logger.setLevel(this.getLogLevel());
        } else {
            this.logger.setLevel(LogLevel.INFO);
        }
    }

    public void execute() {
        this.container = this.makeContainer();
        this.verify();
        this.setupLogger();
        if (this.getContainer().getType().isLocal()) {
            this.setupOutput();
            this.setupTimeout();
            if (this.getContainer().getType() == ContainerType.INSTALLED) {
                this.setupHome();
                this.setupExtraClasspath();
                this.setupSharedClasspath();
                this.setupSystemProperties();
            }
        }
        if (this.getId() != null) {
            this.getProject().addReference(this.getId(), (Object)this.getContainer());
        }
        this.executeActions();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void executeActions() {
        if (this.getAction() == null) {
            return;
        }
        if (LOCAL_ACTIONS.contains(this.getAction())) {
            final LocalContainer localContainer = (LocalContainer)this.getContainer();
            if (this.getAction().startsWith(ACTIONS_DAEMON_PREFIX)) {
                URL daemonURL;
                if (this.daemonElement == null) {
                    throw new BuildException("Daemon configuration is empty.");
                }
                String daemonURLString = this.daemonElement.getProperty("cargo.daemon.url");
                String daemonUsername = this.daemonElement.getProperty("cargo.daemon.username");
                String daemonPassword = this.daemonElement.getProperty("cargo.daemon.password");
                String daemonHandleId = this.daemonElement.getProperty("cargo.daemon.handleid");
                boolean daemonAutostartContainer = Boolean.valueOf(this.daemonElement.getProperty("cargo.daemon.autostart"));
                if (daemonURLString == null || daemonURLString.length() == 0) {
                    throw new BuildException("Missing daemon URL property.");
                }
                try {
                    daemonURL = new URL(daemonURLString);
                }
                catch (MalformedURLException e) {
                    throw new BuildException("Invalid daemon URL: " + e, (Throwable)e);
                }
                if (daemonHandleId == null || daemonHandleId.length() == 0) {
                    throw new BuildException("Missing daemon handle id property.");
                }
                DaemonClient daemon = daemonUsername != null && daemonUsername.length() > 0 && daemonPassword != null && daemonPassword.length() > 0 ? new DaemonClient(daemonURL, daemonUsername, daemonPassword) : (daemonUsername != null && daemonUsername.length() > 0 ? new DaemonClient(daemonURL, daemonUsername) : new DaemonClient(daemonURL));
                if (ACTION_DAEMON_START.equalsIgnoreCase(this.getAction())) {
                    InstalledLocalContainer installedLocalContainer = (InstalledLocalContainer)localContainer;
                    DaemonStart start = new DaemonStart();
                    start.setAdditionalClasspathEntries(this.daemonElement.getClasspaths());
                    start.setAutostart(daemonAutostartContainer);
                    start.setContainer(installedLocalContainer);
                    start.setDeployables(localContainer.getConfiguration().getDeployables());
                    start.setHandleId(daemonHandleId);
                    if (this.getZipURLInstaller() != null) {
                        ZipURLInstaller installer = this.getZipURLInstaller().createInstaller();
                        installer.setLogger(this.getContainer().getLogger());
                        if (!installer.isAlreadyDownloaded()) {
                            installer.download();
                        }
                        start.setInstallerZipFile(this.zipURLInstallerElement.createInstaller().getDownloadFile());
                    }
                    if (this.getLog() != null) {
                        start.setLogFile(this.getLog().getName());
                    }
                    try {
                        daemon.start(start);
                        this.waitDeployableMonitor(true);
                        return;
                    }
                    catch (Exception e) {
                        throw new BuildException("Cannot start the container via Daemon: " + e, (Throwable)e);
                    }
                } else {
                    if (!ACTION_DAEMON_START.equalsIgnoreCase(this.getAction())) throw new BuildException("Unknown daemon action [" + this.getAction() + "] for local container");
                    try {
                        daemon.stop(daemonHandleId);
                        this.waitDeployableMonitor(false);
                        return;
                    }
                    catch (Exception e) {
                        throw new BuildException("Cannot stop the container via Daemon: " + e, (Throwable)e);
                    }
                }
            }
            if (ACTION_START.equalsIgnoreCase(this.getAction())) {
                localContainer.start();
                this.waitDeployableMonitor(true);
                return;
            } else if (ACTION_RESTART.equalsIgnoreCase(this.getAction())) {
                localContainer.restart();
                this.waitDeployableMonitor(true);
                return;
            } else if (ACTION_RUN.equalsIgnoreCase(this.getAction())) {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    public void run() {
                        try {
                            if (State.STARTED == localContainer.getState() || State.STARTING == localContainer.getState()) {
                                localContainer.stop();
                                CargoTask.this.waitDeployableMonitor(false);
                            }
                        }
                        catch (Exception e) {
                            CargoTask.this.log("Failed stopping the container", e, 1);
                        }
                    }
                });
                localContainer.start();
                this.waitDeployableMonitor(true);
                this.log("Press Ctrl-C to stop the container...");
                ContainerUtils.waitTillContainerIsStopped((Container)this.getContainer());
                return;
            } else if (ACTION_STOP.equalsIgnoreCase(this.getAction())) {
                localContainer.stop();
                this.waitDeployableMonitor(false);
                return;
            } else {
                if (!ACTION_CONFIGURE.equalsIgnoreCase(this.getAction())) throw new BuildException("Unknown action [" + this.getAction() + "] for local container");
                localContainer.getConfiguration().configure(localContainer);
            }
            return;
        }
        Deployer deployer = this.deployerFactory.createDeployer(this.getContainer());
        deployer.setLogger(this.getLogger());
        for (DeployableElement deployableElement : this.getConfiguration().getDeployables()) {
            if (ACTION_UNDEPLOY.equalsIgnoreCase(this.getAction()) && deployableElement.getFile() == null) {
                deployableElement.setFile(".");
            }
            Deployable deployable = deployableElement.createDeployable(this.getContainerId());
            DeployableMonitor deployableMonitor = deployableElement.createDeployableMonitor();
            if (ACTION_DEPLOY.equalsIgnoreCase(this.getAction())) {
                if (deployableMonitor == null) {
                    deployer.deploy(deployable);
                    continue;
                }
                deployer.deploy(deployable, deployableMonitor);
                continue;
            }
            if (ACTION_UNDEPLOY.equalsIgnoreCase(this.getAction())) {
                if (deployableMonitor == null) {
                    deployer.undeploy(deployable);
                    continue;
                }
                deployer.undeploy(deployable, deployableMonitor);
                continue;
            }
            if (!ACTION_REDEPLOY.equalsIgnoreCase(this.getAction())) throw new BuildException("Unknown action [" + this.getAction() + "] for deployer");
            if (deployableMonitor == null) {
                deployer.redeploy(deployable);
                continue;
            }
            deployer.redeploy(deployable, deployableMonitor);
        }
    }

    protected void setupLogger() {
        this.getContainer().setLogger(this.getLogger());
        if (this.getContainer().getType().isLocal()) {
            ((LocalContainer)this.getContainer()).getConfiguration().setLogger(this.getLogger());
        } else {
            ((RemoteContainer)this.getContainer()).getConfiguration().setLogger(this.getLogger());
        }
    }

    protected void setupOutput() {
        if (this.getOutput() != null) {
            ((LocalContainer)this.getContainer()).setOutput(this.getOutput());
            ((LocalContainer)this.getContainer()).setAppend(this.isAppend());
        }
    }

    protected void setupTimeout() {
        if (this.getTimeout() != 0L && this.getTimeout() != ((LocalContainer)this.getContainer()).getTimeout()) {
            ((LocalContainer)this.getContainer()).setTimeout(this.getTimeout());
        }
    }

    protected void setupHome() {
        if (this.getHome() != null) {
            ((InstalledLocalContainer)this.getContainer()).setHome(this.getHome());
        } else if (this.getZipURLInstaller() != null) {
            ZipURLInstaller installer = this.getZipURLInstaller().createInstaller();
            installer.setLogger(this.getContainer().getLogger());
            installer.install();
            ((InstalledLocalContainer)this.getContainer()).setHome(installer.getHome());
        }
    }

    protected void setupExtraClasspath() {
        if (this.getExtraClasspath() != null) {
            ((InstalledLocalContainer)this.getContainer()).setExtraClasspath(this.getExtraClasspath().list());
        }
    }

    protected void setupSharedClasspath() {
        if (this.getSharedClasspath() != null) {
            ((InstalledLocalContainer)this.getContainer()).setSharedClasspath(this.getSharedClasspath().list());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupSystemProperties() {
        HashMap<String, String> systemProperties = new HashMap<String, String>();
        if (this.getSystemPropertiesFile() != null) {
            Properties properties = new Properties();
            try {
                FileInputStream inputStream = new FileInputStream(this.getSystemPropertiesFile());
                try {
                    properties.load(new BufferedInputStream(inputStream));
                }
                finally {
                    ((InputStream)inputStream).close();
                }
                Enumeration<?> propertyNames = properties.propertyNames();
                while (propertyNames.hasMoreElements()) {
                    String propertyName = (String)propertyNames.nextElement();
                    String propertyValue = properties.getProperty(propertyName);
                    systemProperties.put(propertyName, propertyValue);
                }
            }
            catch (IOException e) {
                throw new BuildException("System property file [" + this.getSystemPropertiesFile() + "] cannot be loaded", (Throwable)e);
            }
        }
        if (!this.getSystemProperties().isEmpty()) {
            for (Map.Entry<String, String> systemProperty : this.getSystemProperties().entrySet()) {
                systemProperties.put(systemProperty.getKey(), systemProperty.getValue());
            }
        }
        ((InstalledLocalContainer)this.getContainer()).setSystemProperties(systemProperties);
    }

    protected final Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    protected File getSystemPropertiesFile() {
        return this.systemPropertiesFile;
    }

    protected final ZipURLInstallerElement getZipURLInstaller() {
        return this.zipURLInstallerElement;
    }

    protected final ConfigurationElement getConfiguration() {
        return this.configurationElement;
    }

    protected final DaemonElement getDaemon() {
        return this.daemonElement;
    }

    protected final Path getExtraClasspath() {
        return this.extraClasspath;
    }

    protected final Path getSharedClasspath() {
        return this.sharedClasspath;
    }

    protected final long getTimeout() {
        return this.timeout;
    }

    protected final String getOutput() {
        return this.output;
    }

    protected final File getLog() {
        return this.log;
    }

    protected LogLevel getLogLevel() {
        return this.logLevel;
    }

    protected final String getHome() {
        return this.home;
    }

    protected final boolean isAppend() {
        return this.append;
    }

    protected final String getAction() {
        return this.action;
    }

    protected Container makeContainer() {
        Container container;
        if (this.getRefid() != null) {
            Object o = this.getContainerReference();
            if (!(o instanceof Container)) {
                throw new BuildException("The [refid] attribute must point to a container reference, it is pointing to a [" + o.getClass().getName() + "] object");
            }
            container = (Container)o;
            this.logger = container.getLogger();
        } else {
            if (this.getConfiguration() == null) {
                throw new BuildException("Missing mandatory [configuration] element.");
            }
            if (this.getHome() != null) {
                this.setHome(this.calculateAbsoluteDirectory("container home", this.getHome()));
            }
            if (this.getZipURLInstaller() != null && this.getZipURLInstaller().getDownloadDir() != null) {
                this.getZipURLInstaller().setDownloadDir(this.calculateAbsoluteDirectory("zip URL installer download", this.getZipURLInstaller().getDownloadDir()));
            }
            if (this.getZipURLInstaller() != null && this.getZipURLInstaller().getExtractDir() != null) {
                this.getZipURLInstaller().setExtractDir(this.calculateAbsoluteDirectory("zip URL installer extract", this.getZipURLInstaller().getExtractDir()));
            }
            if (this.getConfiguration().getHome() != null) {
                this.getConfiguration().setHome(this.calculateAbsoluteDirectory("configuration home", this.getConfiguration().getHome()));
            }
            if (this.getContainerClass() != null) {
                this.containerFactory.registerContainer(this.containerId, this.containerType, this.getContainerClass());
            }
            container = this.containerFactory.createContainer(this.containerId, this.containerType, this.getConfiguration().createConfiguration(this.containerId, this.containerType));
            this.createCargoLogger();
        }
        return container;
    }

    private Object getContainerReference() {
        Object o;
        try {
            o = this.getRefid().getReferencedObject(this.getProject());
        }
        catch (BuildException e) {
            throw new BuildException("The [" + this.getRefid().getRefId() + "] reference does not " + "exist. You must first define a Cargo container reference.", (Throwable)e);
        }
        return o;
    }

    protected String getContainerId() {
        return this.containerId;
    }

    protected String getId() {
        return this.id;
    }

    protected Reference getRefid() {
        return this.refid;
    }

    private void verify() {
        if (this.getId() != null && this.getRefid() != null) {
            throw new BuildException("You must use either [id] or [refid] but not both");
        }
        if (this.getContainerId() == null && this.getRefid() == null) {
            throw new BuildException("You must specify a [containerId] attribute or use a [refid] attribute");
        }
        if (this.getId() == null && this.getAction() == null) {
            throw new BuildException("You must specify an [action] attribute with values " + LOCAL_ACTIONS + " (for local containers) or " + DEPLOYER_ACTIONS + " (for local or remote container deployments)");
        }
        if (this.getId() == null) {
            if (!LOCAL_ACTIONS.contains(this.getAction()) && !DEPLOYER_ACTIONS.contains(this.getAction())) {
                throw new BuildException("Unknown action: " + DEPLOYER_ACTIONS);
            }
            if (!this.getContainer().getType().isLocal() && !DEPLOYER_ACTIONS.contains(this.getAction())) {
                throw new BuildException("Valid actions for remote containers are: " + DEPLOYER_ACTIONS);
            }
        }
        if (this.getHome() == null && this.getZipURLInstaller() == null && this.getContainer().getType() == ContainerType.INSTALLED && ((InstalledLocalContainer)this.getContainer()).getHome() == null) {
            throw new BuildException("You must specify either a [home] attribute pointing to the location where the " + this.getContainer().getName() + " is installed, or a nested [zipurlinstaller] element");
        }
    }

    public void setContainerFactory(ContainerFactory containerFactory) {
        this.containerFactory = containerFactory;
    }

    protected Container getContainer() {
        return this.container;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    private String calculateAbsoluteDirectory(String type, String directory) {
        File directoryFile = new File(directory);
        if (!directoryFile.isAbsolute()) {
            String absoluteDirectory = directoryFile.getAbsolutePath();
            if (this.getLogger() != null) {
                this.getLogger().warn("The provided " + type + " directory [" + directory + "] is not an absolute directory. Replacing it with its absolute directory " + "counterpart, i.e. [" + absoluteDirectory + "] To avoid this message in " + "the future, you can also use the ${basedir} variable in your " + "paths.", ((Object)((Object)this)).getClass().getName());
            }
            return absoluteDirectory;
        }
        return directory;
    }

    protected void waitDeployableMonitor(boolean starting) {
        if (this.getConfiguration() != null && this.getConfiguration().getDeployables() != null) {
            for (DeployableElement deployableElement : this.getConfiguration().getDeployables()) {
                DeployableMonitor deployableMonitor = deployableElement.createDeployableMonitor();
                if (deployableMonitor == null) continue;
                DeployerWatchdog watchdog = new DeployerWatchdog(deployableMonitor);
                watchdog.setLogger(this.container.getLogger());
                deployableMonitor.setLogger(this.container.getLogger());
                watchdog.watch(starting);
            }
        }
    }
}

