/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.ant;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.codehaus.cargo.ant.DeployableElement;
import org.codehaus.cargo.ant.Property;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.FileConfig;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.configuration.StandaloneLocalConfiguration;
import org.codehaus.cargo.generic.configuration.DefaultConfigurationFactory;
import org.codehaus.cargo.util.XmlReplacement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationElement {
    private ConfigurationType type = ConfigurationType.STANDALONE;
    private String home;
    private List<Property> properties = new ArrayList<Property>();
    private File propertiesFile;
    private Class configurationClass;
    private List<DeployableElement> deployables = new ArrayList<DeployableElement>();
    private List<FileConfig> fileConfigs = new ArrayList<FileConfig>();
    private List<FileConfig> files = new ArrayList<FileConfig>();
    private List<XmlReplacement> xmlReplacements = new ArrayList<XmlReplacement>();

    public void setClass(Class configurationClass) {
        this.configurationClass = configurationClass;
    }

    protected Class getConfigurationClass() {
        return this.configurationClass;
    }

    public void addConfiguredDeployable(DeployableElement deployableElement) {
        this.deployables.add(deployableElement);
    }

    protected List<DeployableElement> getDeployables() {
        return this.deployables;
    }

    public void addConfiguredConfigfile(FileConfig configfileElement) {
        this.fileConfigs.add(configfileElement);
    }

    protected List<FileConfig> getFileConfigs() {
        return this.fileConfigs;
    }

    public void addConfiguredFile(FileConfig fileConfigElement) {
        this.files.add(fileConfigElement);
    }

    protected List<FileConfig> getFiles() {
        return this.files;
    }

    public void addConfiguredProperty(Property property) {
        this.properties.add(property);
    }

    protected List<Property> getProperties() {
        return this.properties;
    }

    public File getPropertiesFile() {
        return this.propertiesFile;
    }

    public void setPropertiesFile(File propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    public void addConfiguredXmlreplacement(XmlReplacement xmlReplacement) {
        this.xmlReplacements.add(xmlReplacement);
    }

    protected List<XmlReplacement> getXmlReplacements() {
        return this.xmlReplacements;
    }

    public void setType(String typeAsString) {
        this.type = ConfigurationType.toType((String)typeAsString);
    }

    public ConfigurationType getType() {
        return this.type;
    }

    public void setHome(String home) {
        this.home = home;
    }

    public String getHome() {
        return this.home;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration createConfiguration(String containerId, ContainerType containerType) {
        DefaultConfigurationFactory factory = new DefaultConfigurationFactory();
        if (this.getConfigurationClass() != null) {
            factory.registerConfiguration(containerId, containerType, this.getType(), this.getConfigurationClass());
        }
        Configuration configuration = this.getHome() == null ? factory.createConfiguration(containerId, containerType, this.getType()) : factory.createConfiguration(containerId, containerType, this.getType(), this.getHome());
        if (this.getPropertiesFile() != null) {
            Properties properties = new Properties();
            try {
                FileInputStream inputStream = new FileInputStream(this.getPropertiesFile());
                try {
                    properties.load(new BufferedInputStream(inputStream));
                }
                finally {
                    ((InputStream)inputStream).close();
                }
                Enumeration<?> propertyNames = properties.propertyNames();
                while (propertyNames.hasMoreElements()) {
                    String propertyName = (String)propertyNames.nextElement();
                    String propertyValue = properties.getProperty(propertyName);
                    configuration.setProperty(propertyName, propertyValue);
                }
            }
            catch (IOException e) {
                throw new BuildException("Configuration property file [" + this.getPropertiesFile() + "] cannot be loaded", (Throwable)e);
            }
        }
        for (Property property : this.getProperties()) {
            configuration.setProperty(property.getName(), property.getValue());
        }
        if (configuration instanceof StandaloneLocalConfiguration) {
            StandaloneLocalConfiguration standaloneLocalConfiguration = (StandaloneLocalConfiguration)configuration;
            for (XmlReplacement xmlReplacement : this.getXmlReplacements()) {
                standaloneLocalConfiguration.addXmlReplacement(xmlReplacement);
            }
        }
        if (configuration instanceof LocalConfiguration) {
            LocalConfiguration localConfiguration = (LocalConfiguration)configuration;
            this.addStaticDeployables(containerId, localConfiguration);
            if (this.getFileConfigs() != null) {
                for (FileConfig configfile : this.getFileConfigs()) {
                    localConfiguration.setConfigFileProperty(configfile);
                }
            }
            if (this.getFiles() != null) {
                for (FileConfig file : this.getFiles()) {
                    localConfiguration.setFileProperty(file);
                }
            }
        }
        return configuration;
    }

    private void addStaticDeployables(String containerId, LocalConfiguration configuration) {
        for (DeployableElement deployableElement : this.getDeployables()) {
            configuration.addDeployable(deployableElement.createDeployable(containerId));
        }
    }
}

