/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.ant;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.codehaus.cargo.ant.Property;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployer.DeployableMonitor;
import org.codehaus.cargo.container.deployer.URLDeployableMonitor;
import org.codehaus.cargo.generic.deployable.DefaultDeployableFactory;
import org.codehaus.cargo.generic.deployable.DeployableFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployableElement {
    private DeployableType type;
    private String file;
    private URL pingURL;
    private Long pingTimeout;
    private Class deployableClass;
    private DeployableFactory factory = new DefaultDeployableFactory();
    private List<Property> properties = new ArrayList<Property>();

    public void setFile(String file) {
        this.file = file;
    }

    public void setPingUrl(URL pingURL) {
        this.pingURL = pingURL;
    }

    public void setPingTimeout(Long pingTimeout) {
        this.pingTimeout = pingTimeout;
    }

    public void setType(String type) {
        this.type = DeployableType.toType((String)type);
    }

    public void setClass(Class deployableClass) {
        this.deployableClass = deployableClass;
    }

    public void addConfiguredProperty(Property property) {
        this.properties.add(property);
    }

    public Deployable createDeployable(String containerId) {
        if (this.getFile() == null) {
            throw new BuildException("The [file] attribute is mandatory");
        }
        if (this.getType() == null) {
            throw new BuildException("The [type] attribute is mandatory");
        }
        if (this.getDeployableClass() != null) {
            this.factory.registerDeployable(containerId, this.getType(), this.getDeployableClass());
        }
        Deployable deployable = this.factory.createDeployable(containerId, this.getFile(), this.getType());
        for (Property property : this.getProperties()) {
            if ("pingURL".equals(property.getName())) {
                try {
                    this.setPingUrl(new URL(property.getValue()));
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new BuildException("Invalid value [" + property.getValue() + "] for property [" + property.getName() + "]", (Throwable)e);
                }
            }
            if ("pingTimeout".equals(property.getName())) {
                this.setPingTimeout(Long.getLong(property.getValue()));
                continue;
            }
            try {
                this.callMethodForProperty(deployable, property);
            }
            catch (Exception e) {
                throw new BuildException("Invalid property [" + property.getName() + "] for deployable type [" + deployable.getType() + "]", (Throwable)e);
            }
        }
        return deployable;
    }

    public DeployableMonitor createDeployableMonitor() {
        if (this.pingURL == null) {
            return null;
        }
        URLDeployableMonitor monitor = this.pingTimeout == null ? new URLDeployableMonitor(this.pingURL) : new URLDeployableMonitor(this.pingURL, this.pingTimeout.longValue());
        return monitor;
    }

    private void callMethodForProperty(Deployable deployable, Property property) throws Exception {
        String[] argument;
        Method method;
        String setterMethodName = this.getSetterMethodName(property.getName());
        try {
            method = deployable.getClass().getMethod(setterMethodName, String.class);
            argument = property.getValue();
        }
        catch (NoSuchMethodException e) {
            method = deployable.getClass().getMethod(setterMethodName, String[].class);
            ArrayList<String> valueList = new ArrayList<String>();
            StringTokenizer commaSeparatedValue = new StringTokenizer(property.getValue(), ",");
            while (commaSeparatedValue.hasMoreTokens()) {
                String commaSeparatedLine = commaSeparatedValue.nextToken().trim();
                if (commaSeparatedLine.length() <= 0) continue;
                valueList.add(commaSeparatedLine);
            }
            String[] valueArray = new String[valueList.size()];
            argument = valueArray = valueList.toArray(valueArray);
        }
        method.invoke((Object)deployable, new Object[]{argument});
    }

    protected String getSetterMethodName(String propertyName) {
        return "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
    }

    public DeployableType getType() {
        return this.type;
    }

    public String getFile() {
        return this.file;
    }

    public Class getDeployableClass() {
        return this.deployableClass;
    }

    public List<Property> getProperties() {
        return this.properties;
    }
}

