/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven2.util;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class CargoProject {
    private Log log;
    private String packaging;
    private String groupId;
    private String artifactId;
    private String buildDirectory;
    private String finalName;
    private boolean daemonRun = false;
    private Set<Artifact> artifacts;
    private ClassLoader embeddedClassLoader;

    public CargoProject(String packaging, String groupId, String artifactId, String buildDirectory, String finalName, Set<Artifact> artifacts, Log log) {
        this(packaging, groupId, artifactId, buildDirectory, finalName, null, Collections.emptyList(), artifacts, log);
    }

    public CargoProject(MavenProject project, Log log) {
        this(project.getPackaging(), project.getGroupId(), project.getArtifactId(), project.getBuild().getDirectory(), project.getBuild().getFinalName(), project.getArtifact(), project.getAttachedArtifacts(), project.getArtifacts(), log);
    }

    private CargoProject(String packaging, String groupId, String artifactId, String buildDirectory, String finalName, Artifact artifact, List<Artifact> attachedArtifacts, Set<Artifact> artifacts, Log log) {
        this.log = log;
        this.packaging = packaging;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.buildDirectory = buildDirectory;
        this.finalName = finalName;
        this.artifacts = new LinkedHashSet<Artifact>(1 + attachedArtifacts.size() + artifacts.size());
        if (artifact != null) {
            this.artifacts.add(artifact);
        }
        this.artifacts.addAll(attachedArtifacts);
        this.artifacts.addAll(artifacts);
    }

    public String getPackaging() {
        return this.packaging;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getBuildDirectory() {
        return this.buildDirectory;
    }

    public String getFinalName() {
        return this.finalName;
    }

    public Set<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public Log getLog() {
        return this.log;
    }

    public boolean isDaemonRun() {
        return this.daemonRun;
    }

    public void setDaemonRun(boolean enable) {
        this.daemonRun = enable;
    }

    public boolean isJ2EEPackaging() {
        boolean result = false;
        if (this.getPackaging().equalsIgnoreCase("war")) {
            result = true;
        } else if (this.getPackaging().equalsIgnoreCase("ear")) {
            result = true;
        } else if (this.getPackaging().equalsIgnoreCase("ejb")) {
            result = true;
        } else if (this.getPackaging().equalsIgnoreCase("uberwar")) {
            result = true;
        } else if (this.getPackaging().equalsIgnoreCase("rar")) {
            result = true;
        } else if (this.getPackaging().equalsIgnoreCase("bundle")) {
            result = true;
        }
        return result;
    }

    public void setEmbeddedClassLoader(ClassLoader classLoader) {
        this.embeddedClassLoader = classLoader;
    }

    public ClassLoader getEmbeddedClassLoader() {
        return this.embeddedClassLoader;
    }
}

