/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven3.merge;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.codehaus.cargo.maven3.Merge;
import org.codehaus.cargo.maven3.merge.MergeProcessorFactory;
import org.codehaus.cargo.module.merge.DescriptorMergerByTag;
import org.codehaus.cargo.module.merge.MergeProcessor;
import org.codehaus.cargo.module.merge.tagstrategy.ChooseByNameMergeStrategy;
import org.codehaus.cargo.module.merge.tagstrategy.MergeStrategy;
import org.codehaus.cargo.module.merge.tagstrategy.NodeMergeStrategy;
import org.codehaus.cargo.module.webapp.WebXml;
import org.codehaus.cargo.module.webapp.WebXmlIo;
import org.codehaus.cargo.module.webapp.merge.WarArchiveMerger;
import org.codehaus.cargo.module.webapp.merge.WebXmlMerger;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class MergeWebXml
implements MergeProcessorFactory {
    private WebXmlMerger webXmlMerger;
    private File configDirectory;

    public MergeWebXml(File configDirectory) {
        this.configDirectory = configDirectory;
    }

    public File getConfigDirectory() {
        return this.configDirectory;
    }

    public void setConfigDirectory(File configDirectory) {
        this.configDirectory = configDirectory;
    }

    @Override
    public MergeProcessor create(WarArchiveMerger wam, Merge xml) {
        this.webXmlMerger = wam.getWebXmlMerger();
        Xpp3Dom parameters = (Xpp3Dom)xml.getParameters();
        Xpp3Dom defaultNode = parameters.getChild("default");
        if (defaultNode != null) {
            Xpp3Dom[] tags;
            for (Xpp3Dom tag : tags = defaultNode.getChildren("tag")) {
                String tagName = tag.getAttribute("name");
                Xpp3Dom strategy = tag.getChild("strategy");
                MergeStrategy ms = this.makeStrategy(strategy);
                this.webXmlMerger.setMergeStrategy(tagName, ms);
            }
        }
        return null;
    }

    protected MergeStrategy makeStrategy(Xpp3Dom config) {
        if (!config.getName().equals("strategy")) {
            throw new CargoException("You must specify a merge strategy");
        }
        String strategyName = config.getAttribute("name");
        String strategyFile = config.getAttribute("file");
        if (strategyName.equalsIgnoreCase("Preserve")) {
            return DescriptorMergerByTag.PRESERVE;
        }
        if (strategyName.equalsIgnoreCase("Overwrite")) {
            return DescriptorMergerByTag.OVERWRITE;
        }
        if (strategyName.equalsIgnoreCase("ChooseByName")) {
            Xpp3Dom[] items;
            Xpp3Dom def = config.getChild("default").getChild(0);
            ChooseByNameMergeStrategy cbnms = new ChooseByNameMergeStrategy(this.makeStrategy(def));
            for (Xpp3Dom item : items = config.getChildren()) {
                if (!item.getName().equals("choice")) continue;
                cbnms.addStrategyForName(item.getAttribute("name"), this.makeStrategy(item.getChild(0)));
            }
            return cbnms;
        }
        if (strategyName.equalsIgnoreCase("NodeMerge")) {
            try {
                if (strategyFile != null) {
                    File f = new File(this.getConfigDirectory(), strategyFile);
                    WebXml webXml = WebXmlIo.parseWebXml((InputStream)new FileInputStream(f), null);
                    return new NodeMergeStrategy(webXml.getDescriptorType(), webXml.getRootElement());
                }
                String theXml = config.getChild(0).toString();
                WebXml webXml = WebXmlIo.parseWebXml((InputStream)new ByteArrayInputStream(theXml.getBytes(StandardCharsets.UTF_8)), null);
                return new NodeMergeStrategy(webXml.getDescriptorType(), webXml.getRootElement());
            }
            catch (Exception e) {
                throw new CargoException("Problem generating Node Merge strategy", (Throwable)e);
            }
        }
        throw new CargoException("Must provide a known strategy type (don't understand " + strategyName + ")");
    }
}

