/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.activemq.broker;

import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.amq.AMQPersistenceAdapter;
import org.fabric3.binding.activemq.broker.BrokerConfiguration;
import org.fabric3.binding.activemq.broker.BrokerParser;
import org.fabric3.binding.activemq.broker.PersistenceAdapterConfig;
import org.fabric3.binding.activemq.factory.InvalidConfigurationException;
import org.fabric3.host.runtime.HostInfo;
import org.osoa.sca.annotations.Destroy;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Property;
import org.osoa.sca.annotations.Reference;

@EagerInit
public class BrokerEngine {
    private String brokerName = "DefaultBroker";
    private BrokerService broker;
    private File tempDir;
    private int selectedPort = 61616;
    private String hostAddress = "localhost";
    private int maxPort = 71717;
    private int minPort = 61616;
    private File dataDir;
    private BrokerConfiguration brokerConfiguration;
    private Level logLevel = Level.WARNING;

    public BrokerEngine(@Reference HostInfo info) {
        this.tempDir = new File(info.getTempDir(), "activemq");
        File baseDataDir = info.getDataDir();
        this.dataDir = new File(baseDataDir, "activemq.data");
    }

    @Property(required=false)
    public void setLogLevel(String logLevel) {
        this.logLevel = Level.parse(logLevel);
    }

    @Property(required=false)
    public void setHostAddress(String hostAddress) {
        this.hostAddress = hostAddress;
    }

    @Property(required=false)
    public void setBrokerConfig(XMLStreamReader reader) throws InvalidConfigurationException, XMLStreamException {
        BrokerParser parser = new BrokerParser();
        this.brokerConfiguration = parser.parse(reader);
    }

    @Init
    public void init() throws Exception {
        Logger.getLogger("org.apache.activemq").setLevel(this.logLevel);
        this.broker = new BrokerService();
        this.broker.setUseJmx(false);
        this.broker.setTmpDataDirectory(this.tempDir);
        this.broker.setDataDirectory(this.dataDir.toString());
        if (this.brokerConfiguration == null) {
            this.broker.setBrokerName(this.brokerName);
            boolean loop = true;
            TransportConnector connector = null;
            while (loop) {
                try {
                    connector = this.broker.addConnector("tcp://" + this.hostAddress + ":" + this.selectedPort);
                    loop = false;
                }
                catch (IOException e) {
                    this.selectPort();
                }
            }
            connector.setDiscoveryUri(URI.create("multicast://default"));
            this.broker.addNetworkConnector("multicast://default");
        } else {
            this.broker.setBrokerName(this.brokerConfiguration.getName());
            PersistenceAdapterConfig persistenceConfig = this.brokerConfiguration.getPersistenceAdapter();
            if (persistenceConfig != null && PersistenceAdapterConfig.Type.AMQ == persistenceConfig.getType()) {
                AMQPersistenceAdapter adapter = new AMQPersistenceAdapter();
                adapter.setIndexBinSize(persistenceConfig.getIndexBinSize());
                adapter.setCheckpointInterval(persistenceConfig.getCheckpointInterval().longValue());
                adapter.setCleanupInterval(persistenceConfig.getCleanupInterval().longValue());
                adapter.setIndexKeySize(persistenceConfig.getIndexKeySize());
                adapter.setIndexPageSize(persistenceConfig.getIndexPageSize());
                adapter.setSyncOnWrite(persistenceConfig.isSyncOnWrite());
                adapter.setDisableLocking(persistenceConfig.isDisableLocking());
                this.broker.setPersistenceAdapter((PersistenceAdapter)adapter);
            }
        }
        this.broker.start();
    }

    @Destroy
    public void destroy() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    private void selectPort() throws IOException {
        if (this.maxPort == -1) {
            this.selectedPort = this.minPort;
            return;
        }
        this.selectedPort = this.minPort;
        while (this.selectedPort <= this.maxPort) {
            try {
                ServerSocket socket = new ServerSocket(this.selectedPort);
                socket.close();
                return;
            }
            catch (IOException e) {
                ++this.selectedPort;
            }
        }
        this.selectedPort = -1;
        throw new IOException("Unable to find an available port. Check to ensure the system configuration specifies an open port or port range.");
    }
}

