/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.activemq.broker;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URI;
import javax.management.MBeanServer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.amq.AMQPersistenceAdapter;
import org.fabric3.api.annotation.monitor.MonitorLevel;
import org.fabric3.binding.activemq.broker.BrokerConfiguration;
import org.fabric3.binding.activemq.broker.BrokerParser;
import org.fabric3.binding.activemq.broker.Fabric3ManagementContext;
import org.fabric3.binding.activemq.broker.PersistenceAdapterConfig;
import org.fabric3.binding.activemq.broker.TransportConnectorConfig;
import org.fabric3.binding.activemq.factory.InvalidConfigurationException;
import org.fabric3.host.runtime.HostInfo;
import org.fabric3.spi.monitor.MonitorService;
import org.osoa.sca.annotations.Destroy;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Property;
import org.osoa.sca.annotations.Reference;

@EagerInit
public class BrokerEngine {
    private HostInfo info;
    private String brokerName;
    private BrokerService broker;
    private File tempDir;
    private int selectedPort = 61616;
    private String bindAddress;
    private int maxPort = 71717;
    private int minPort = 61616;
    private File dataDir;
    private BrokerConfiguration brokerConfiguration;
    private MonitorLevel monitorLevel = MonitorLevel.WARNING;
    private MonitorService monitorService;
    private MBeanServer mBeanServer;

    public BrokerEngine(@Reference HostInfo info) {
        this.tempDir = new File(info.getTempDir(), "activemq");
        File baseDataDir = info.getDataDir();
        this.dataDir = new File(baseDataDir, "activemq.data");
        this.info = info;
    }

    @Property(required=false)
    public void setMinPort(int minPort) {
        this.minPort = minPort;
    }

    @Property(required=false)
    public void setMaxPort(int maxPort) {
        this.maxPort = maxPort;
    }

    @Property(required=false)
    public void setMonitorLevel(String monitorLevel) {
        this.monitorLevel = MonitorLevel.valueOf((String)monitorLevel);
    }

    @Property(required=false)
    public void setDefaultBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    @Property(required=false)
    public void setBrokerConfig(XMLStreamReader reader) throws InvalidConfigurationException, XMLStreamException {
        BrokerParser parser = new BrokerParser();
        this.brokerConfiguration = parser.parse(reader);
    }

    @Reference(required=false)
    public void setMBeanServer(MBeanServer mBeanServer) {
        this.mBeanServer = mBeanServer;
    }

    @Init
    public void init() throws Exception {
        if (this.bindAddress == null) {
            this.bindAddress = InetAddress.getLocalHost().getHostAddress();
        }
        this.brokerName = this.info.getRuntimeName().replace(":", ".");
        this.broker = new BrokerService();
        this.broker.setUseJmx(true);
        this.broker.setTmpDataDirectory(this.tempDir);
        this.broker.setDataDirectory(this.dataDir.toString());
        if (this.brokerConfiguration == null) {
            this.broker.setBrokerName(this.brokerName);
            this.createManagementContext(this.brokerName);
            boolean loop = true;
            TransportConnector connector = null;
            while (loop) {
                try {
                    connector = this.broker.addConnector("tcp://" + this.bindAddress + ":" + this.selectedPort);
                    loop = false;
                }
                catch (IOException e) {
                    this.selectPort();
                }
            }
            String group = this.info.getDomain().getAuthority();
            connector.setDiscoveryUri(URI.create("multicast://default?group=" + group));
            this.broker.addNetworkConnector("multicast://default?group=" + group);
        } else {
            String name = this.brokerConfiguration.getName();
            if (name != null) {
                this.brokerName = name;
                this.broker.setBrokerName(name);
            } else {
                this.broker.setBrokerName(this.brokerName);
            }
            this.createManagementContext(this.brokerName);
            PersistenceAdapterConfig persistenceConfig = this.brokerConfiguration.getPersistenceAdapter();
            if (persistenceConfig != null && PersistenceAdapterConfig.Type.AMQ == persistenceConfig.getType()) {
                AMQPersistenceAdapter adapter = new AMQPersistenceAdapter();
                adapter.setIndexBinSize(persistenceConfig.getIndexBinSize());
                adapter.setCheckpointInterval(persistenceConfig.getCheckpointInterval().longValue());
                adapter.setCleanupInterval(persistenceConfig.getCleanupInterval().longValue());
                adapter.setIndexKeySize(persistenceConfig.getIndexKeySize());
                adapter.setIndexPageSize(persistenceConfig.getIndexPageSize());
                adapter.setSyncOnWrite(persistenceConfig.isSyncOnWrite());
                adapter.setDisableLocking(persistenceConfig.isDisableLocking());
                this.broker.setPersistenceAdapter((PersistenceAdapter)adapter);
            }
            for (URI uri : this.brokerConfiguration.getNetworkConnectorUris()) {
                this.broker.addNetworkConnector(uri);
            }
            for (TransportConnectorConfig config : this.brokerConfiguration.getTransportConnectorConfigs()) {
                URI uri = config.getUri();
                URI discoveryUri = config.getDiscoveryUri();
                TransportConnector connector = this.broker.addConnector(uri);
                connector.setDiscoveryUri(discoveryUri);
            }
        }
        this.broker.start();
    }

    private void createManagementContext(String brokerName) {
        Fabric3ManagementContext context = new Fabric3ManagementContext(brokerName, this.mBeanServer);
        this.broker.setManagementContext((ManagementContext)context);
    }

    @Destroy
    public void destroy() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    private void selectPort() throws IOException {
        if (this.maxPort == -1) {
            this.selectedPort = this.minPort;
            return;
        }
        this.selectedPort = this.minPort;
        while (this.selectedPort <= this.maxPort) {
            try {
                ServerSocket socket = new ServerSocket(this.selectedPort, 0, InetAddress.getByName(this.bindAddress));
                socket.close();
                return;
            }
            catch (IOException e) {
                ++this.selectedPort;
            }
        }
        this.selectedPort = -1;
        throw new IOException("Unable to find an available port. Check to ensure the system configuration specifies an open port or port range.");
    }
}

