/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.activemq.broker;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.binding.activemq.broker.BrokerConfiguration;
import org.fabric3.binding.activemq.broker.PersistenceAdapterConfig;
import org.fabric3.binding.activemq.broker.TransportConnectorConfig;
import org.fabric3.binding.activemq.factory.InvalidConfigurationException;

public class BrokerParser {
    public BrokerConfiguration parse(XMLStreamReader reader) throws XMLStreamException, InvalidConfigurationException {
        reader.nextTag();
        BrokerConfiguration configuration = new BrokerConfiguration();
        while (true) {
            switch (reader.next()) {
                case 1: {
                    if ("broker".equals(reader.getName().getLocalPart())) {
                        String name = reader.getAttributeValue(null, "name");
                        configuration.setName(name);
                        break;
                    }
                    if ("networkConnectors".equals(reader.getName().getLocalPart())) {
                        this.parseNetworkConnectors(reader, configuration);
                        break;
                    }
                    if ("transportConnectors".equals(reader.getName().getLocalPart())) {
                        this.parseTransportConnectors(reader, configuration);
                        break;
                    }
                    if (!"persistenceAdapter".equals(reader.getName().getLocalPart())) break;
                    this.parsePersistenceAdapter(reader, configuration);
                    break;
                }
                case 8: {
                    return configuration;
                }
            }
        }
    }

    private void parsePersistenceAdapter(XMLStreamReader reader, BrokerConfiguration configuration) throws InvalidConfigurationException {
        String type = reader.getAttributeValue(null, "type");
        PersistenceAdapterConfig adaptorConfig = new PersistenceAdapterConfig();
        if (type == null) {
            type = "amq";
        }
        if ("amq".equalsIgnoreCase(type)) {
            String indexKeySize;
            String cleanupInterval;
            String checkpointInterval;
            boolean syncOnWrite = Boolean.valueOf(reader.getAttributeValue(null, "syncOnWrite"));
            adaptorConfig.setSyncOnWrite(syncOnWrite);
            String maxFileLength = reader.getAttributeValue(null, "maxFileLength");
            if (maxFileLength != null) {
                adaptorConfig.setMaxFileLength(maxFileLength);
            }
            if ((checkpointInterval = reader.getAttributeValue(null, "checkpointInterval")) != null) {
                try {
                    adaptorConfig.setCheckpointInterval(Long.valueOf(checkpointInterval));
                }
                catch (NumberFormatException e) {
                    this.raiseInvalidConfiguration("Invalid check point interval", e, reader);
                }
            }
            if ((cleanupInterval = reader.getAttributeValue(null, "cleanupInterval")) != null) {
                try {
                    adaptorConfig.setCleanupInterval(Long.valueOf(cleanupInterval));
                }
                catch (NumberFormatException e) {
                    this.raiseInvalidConfiguration("Invalid cleanup interval", e, reader);
                }
            }
            boolean disableLocking = Boolean.valueOf(reader.getAttributeValue(null, "disableLocking"));
            adaptorConfig.setDisableLocking(disableLocking);
            String indexBinSize = reader.getAttributeValue(null, "indexBinSize");
            if (indexBinSize != null) {
                try {
                    adaptorConfig.setIndexBinSize(Integer.valueOf(indexBinSize));
                }
                catch (NumberFormatException e) {
                    this.raiseInvalidConfiguration("Invalid index bin size", e, reader);
                }
            }
            if ((indexKeySize = reader.getAttributeValue(null, "indexKeySize")) != null) {
                try {
                    adaptorConfig.setIndexKeySize(Integer.valueOf(indexKeySize));
                }
                catch (NumberFormatException e) {
                    this.raiseInvalidConfiguration("Invalid index key size", e, reader);
                }
            }
            String indexPageSize = reader.getAttributeValue(null, "indexPageSize");
            if (indexBinSize != null) {
                try {
                    adaptorConfig.setIndexPageSize(Integer.valueOf(indexPageSize));
                }
                catch (NumberFormatException e) {
                    this.raiseInvalidConfiguration("Invalid index page size", e, reader);
                }
            }
        } else {
            this.raiseInvalidConfiguration("Persistence adaptor type configuration not supported:" + type, reader);
        }
        configuration.setPersistenceAdapter(adaptorConfig);
    }

    private void parseTransportConnectors(XMLStreamReader reader, BrokerConfiguration configuration) throws XMLStreamException, InvalidConfigurationException {
        ArrayList<TransportConnectorConfig> transportConfigs = new ArrayList<TransportConnectorConfig>();
        while (true) {
            switch (reader.next()) {
                case 1: {
                    if (!"transportConnector".equals(reader.getName().getLocalPart())) break;
                    URI uri = null;
                    String uriString = reader.getAttributeValue(null, "uri");
                    if (uriString == null) {
                        this.raiseInvalidConfiguration("Network transport connector uri not specified", reader);
                    }
                    try {
                        uri = new URI(uriString);
                    }
                    catch (URISyntaxException e) {
                        this.raiseInvalidConfiguration("Invalid transport connector uri", e, reader);
                    }
                    TransportConnectorConfig transportConfig = new TransportConnectorConfig();
                    transportConfig.setUri(uri);
                    String discoveryUriString = reader.getAttributeValue(null, "discoveryUri");
                    if (discoveryUriString != null) {
                        try {
                            transportConfig.setDiscoveryUri(new URI(discoveryUriString));
                        }
                        catch (URISyntaxException e) {
                            this.raiseInvalidConfiguration("Invalid discovery uri", e, reader);
                        }
                    }
                    transportConfigs.add(transportConfig);
                    break;
                }
                case 2: {
                    if (!"transportConnectors".equals(reader.getName().getLocalPart())) break;
                    configuration.setTransportConnectorConfigs(transportConfigs);
                    return;
                }
                case 8: {
                    throw new AssertionError((Object)"End of document encountered");
                }
            }
        }
    }

    private void parseNetworkConnectors(XMLStreamReader reader, BrokerConfiguration configuration) throws XMLStreamException, InvalidConfigurationException {
        ArrayList<URI> uris = new ArrayList<URI>();
        block7: while (true) {
            switch (reader.next()) {
                case 1: {
                    if (!"networkConnector".equals(reader.getName().getLocalPart())) break;
                    String uriString = reader.getAttributeValue(null, "uri");
                    if (uriString == null) {
                        this.raiseInvalidConfiguration("Network connector uri not specified", reader);
                    }
                    try {
                        URI uri = new URI(uriString);
                        uris.add(uri);
                    }
                    catch (URISyntaxException e) {
                        this.raiseInvalidConfiguration("Invalid network connector uri", e, reader);
                    }
                    continue block7;
                }
                case 2: {
                    if (!"networkConnectors".equals(reader.getName().getLocalPart())) break;
                    configuration.setNetworkConnectorUris(uris);
                    return;
                }
                case 8: {
                    throw new AssertionError((Object)"End of document encountered");
                }
            }
        }
    }

    private void raiseInvalidConfiguration(String message, XMLStreamReader reader) throws InvalidConfigurationException {
        Location location = reader.getLocation();
        if (location == null) {
            throw new InvalidConfigurationException(message);
        }
        int line = location.getLineNumber();
        int col = location.getColumnNumber();
        throw new InvalidConfigurationException(message + " [" + line + "," + col + "]");
    }

    private void raiseInvalidConfiguration(String message, Throwable e, XMLStreamReader reader) throws InvalidConfigurationException {
        Location location = reader.getLocation();
        if (location == null) {
            throw new InvalidConfigurationException(message, e);
        }
        int line = location.getLineNumber();
        int col = location.getColumnNumber();
        throw new InvalidConfigurationException(message + " [" + line + "," + col + "]", e);
    }
}

