/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.activemq.broker;

import java.io.ObjectInputStream;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.StandardMBean;
import javax.management.loading.ClassLoaderRepository;
import org.apache.activemq.broker.jmx.BrokerView;
import org.apache.activemq.broker.jmx.ConnectionView;
import org.apache.activemq.broker.jmx.ConnectorView;
import org.apache.activemq.broker.jmx.FTConnectorView;
import org.apache.activemq.broker.jmx.JmsConnectorView;
import org.apache.activemq.broker.jmx.NetworkBridgeView;
import org.apache.activemq.broker.jmx.NetworkConnectorView;
import org.apache.activemq.broker.jmx.ProxyConnectorView;
import org.apache.activemq.broker.jmx.QueueView;
import org.apache.activemq.broker.jmx.SubscriptionView;
import org.apache.activemq.broker.jmx.TopicView;
import org.apache.activemq.util.JMXSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanServerWrapper
implements MBeanServer {
    private static final String DOMAIN = "fabric3";
    private String brokerName;
    private MBeanServer delegate;
    Map<ObjectName, ObjectName> mappings = new ConcurrentHashMap<ObjectName, ObjectName>();

    public MBeanServerWrapper(String brokerName, MBeanServer delegate) {
        this.brokerName = brokerName.replace(":", ".");
        this.delegate = delegate;
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException {
        return this.delegate.createMBean(className, name);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.delegate.createMBean(className, name, loaderName);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException {
        return this.delegate.createMBean(className, name, params, signature);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.delegate.createMBean(className, name, loaderName, params, signature);
    }

    @Override
    public ObjectInstance registerMBean(Object object, ObjectName original) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        ObjectName name = this.convertName(original, object);
        if (this.delegate.isRegistered(name)) {
            try {
                this.delegate.unregisterMBean(name);
            }
            catch (InstanceNotFoundException e) {
                throw new MBeanRegistrationException(e);
            }
        }
        this.mappings.put(original, name);
        return this.delegate.registerMBean(object, name);
    }

    @Override
    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        ObjectName mapped = this.mappings.remove(name);
        if (mapped == null) {
            throw new InstanceNotFoundException(name.toString());
        }
        this.delegate.unregisterMBean(mapped);
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        return this.delegate.getObjectInstance(name);
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) {
        return this.delegate.queryMBeans(name, query);
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) {
        return this.delegate.queryNames(name, query);
    }

    @Override
    public boolean isRegistered(ObjectName original) {
        ObjectName name = this.mappings.get(original);
        return name != null && this.delegate.isRegistered(name);
    }

    @Override
    public Integer getMBeanCount() {
        return this.delegate.getMBeanCount();
    }

    @Override
    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        return this.delegate.getAttribute(name, attribute);
    }

    @Override
    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        return this.delegate.getAttributes(name, attributes);
    }

    @Override
    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.delegate.setAttribute(name, attribute);
    }

    @Override
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        return this.delegate.setAttributes(name, attributes);
    }

    @Override
    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        return this.delegate.invoke(name, operationName, params, signature);
    }

    @Override
    public String getDefaultDomain() {
        return this.delegate.getDefaultDomain();
    }

    @Override
    public String[] getDomains() {
        return this.delegate.getDomains();
    }

    @Override
    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.delegate.addNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.delegate.addNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.delegate.removeNotificationListener(name, listener);
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.delegate.removeNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.delegate.removeNotificationListener(name, listener);
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.delegate.removeNotificationListener(name, listener, filter, handback);
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        return this.delegate.getMBeanInfo(name);
    }

    @Override
    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        return this.delegate.isInstanceOf(name, className);
    }

    @Override
    public Object instantiate(String className) throws ReflectionException, MBeanException {
        return this.delegate.instantiate(className);
    }

    @Override
    public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.delegate.instantiate(className, loaderName);
    }

    @Override
    public Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        return this.delegate.instantiate(className, params, signature);
    }

    @Override
    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.delegate.instantiate(className, loaderName, params, signature);
    }

    @Override
    public ObjectInputStream deserialize(ObjectName name, byte[] data) throws OperationsException {
        return this.delegate.deserialize(name, data);
    }

    @Override
    public ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
        return this.delegate.deserialize(className, data);
    }

    @Override
    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws OperationsException, ReflectionException {
        return this.delegate.deserialize(className, loaderName, data);
    }

    @Override
    public ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
        return this.delegate.getClassLoaderFor(mbeanName);
    }

    @Override
    public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        return this.delegate.getClassLoader(loaderName);
    }

    @Override
    public ClassLoaderRepository getClassLoaderRepository() {
        return this.delegate.getClassLoaderRepository();
    }

    private ObjectName convertName(ObjectName name, Object object) throws MBeanRegistrationException {
        if (!(object instanceof StandardMBean)) {
            return name;
        }
        Object implementation = ((StandardMBean)object).getImplementation();
        if (implementation instanceof BrokerView) {
            try {
                name = new ObjectName("fabric3:SubDomain=runtime, type=resource, group=ActiveMQ, brokerName=" + this.brokerName + ", subgroup=Broker");
            }
            catch (MalformedObjectNameException e) {
                throw new MBeanRegistrationException(e);
            }
        }
        if (implementation instanceof ConnectionView) {
            try {
                String connectionName = name.getKeyProperty("Connection");
                String connectorName = name.getKeyProperty("ConnectorName");
                if (connectionName != null) {
                    name = new ObjectName("fabric3:SubDomain=runtime, type=resource, group=ActiveMQ, brokerName=" + this.brokerName + ", subgroup=connections, connection=" + connectionName + ", ConnectorName=" + connectorName);
                }
                String propertyName = name.getKeyProperty("Name");
                name = new ObjectName("fabric3:SubDomain=runtime, type=resource, group=ActiveMQ, brokerName=" + this.brokerName + ", subgroup=connections, Name=" + propertyName + ", ConnectorName=" + connectorName);
            }
            catch (MalformedObjectNameException e) {
                throw new MBeanRegistrationException(e);
            }
        } else {
            if (implementation instanceof ConnectorView) {
                try {
                    String connectorName = name.getKeyProperty("ConnectorName");
                    name = new ObjectName("fabric3:SubDomain=runtime, type=resource, group=ActiveMQ, brokerName=" + this.brokerName + ", subgroup=connectors, connectorName=" + connectorName);
                }
                catch (MalformedObjectNameException e) {
                    throw new MBeanRegistrationException(e);
                }
            }
            if (implementation instanceof SubscriptionView) {
                SubscriptionView view = (SubscriptionView)implementation;
                String destinationType = view.isDestinationQueue() ? "queues" : "topics";
                try {
                    name = new ObjectName("fabric3:SubDomain=runtime, type=resource, group=ActiveMQ, brokerName=" + this.brokerName + ", subgroup=subscriptions, desintantionType=" + destinationType + ", destinationName=" + JMXSupport.encodeObjectNamePart((String)view.getDestinationName()) + ", cliendId=" + JMXSupport.encodeObjectNamePart((String)view.getClientId()) + ", consumerId=" + view.getSubcriptionId());
                }
                catch (MalformedObjectNameException e) {
                    throw new MBeanRegistrationException(e);
                }
            }
            if (implementation instanceof FTConnectorView) {
                try {
                    name = new ObjectName("fabric3:SubDomain=runtime, type=resource, group=ActiveMQ, brokerName=" + this.brokerName + ", Type=MasterConnector");
                }
                catch (MalformedObjectNameException e) {
                    throw new MBeanRegistrationException(e);
                }
            }
            if (implementation instanceof JmsConnectorView) {
                String connectorName = name.getKeyProperty("JmsConnectorName");
                try {
                    name = new ObjectName("fabric3:SubDomain=runtime, type=resource, group=ActiveMQ, brokerName=" + this.brokerName + ", subgroup=JMS connectors, jmsConnectorName=" + connectorName);
                }
                catch (MalformedObjectNameException e) {
                    throw new MBeanRegistrationException(e);
                }
            }
            if (implementation instanceof NetworkBridgeView) {
                String bridgeName = name.getKeyProperty("Name");
                try {
                    name = new ObjectName("fabric3:SubDomain=runtime, type=resource, group=ActiveMQ, brokerName=" + this.brokerName + ", subgroup=network bridges, bridgeName=" + bridgeName);
                }
                catch (MalformedObjectNameException e) {
                    throw new MBeanRegistrationException(e);
                }
            }
            if (implementation instanceof NetworkConnectorView) {
                NetworkConnectorView view = (NetworkConnectorView)implementation;
                try {
                    name = new ObjectName("fabric3:SubDomain=runtime, type=resource, group=ActiveMQ, brokerName=" + this.brokerName + ", subgroup=network connectors, connectorName=" + JMXSupport.encodeObjectNamePart((String)view.getName()));
                }
                catch (MalformedObjectNameException e) {
                    throw new MBeanRegistrationException(e);
                }
            }
            if (implementation instanceof ProxyConnectorView) {
                String connectorName = name.getKeyProperty("ProxyConnectorName");
                try {
                    name = new ObjectName("fabric3:SubDomain=runtime, type=resource, group=ActiveMQ, brokerName=" + this.brokerName + ", subgroup=proxy connectors, proxyConnectorName=" + connectorName);
                }
                catch (MalformedObjectNameException e) {
                    throw new MBeanRegistrationException(e);
                }
            }
            if (implementation instanceof QueueView) {
                QueueView view = (QueueView)implementation;
                try {
                    name = new ObjectName("fabric3:SubDomain=runtime, type=resource, group=ActiveMQ, brokerName=" + this.brokerName + ", subgroup=queues, queueName=" + JMXSupport.encodeObjectNamePart((String)view.getName()));
                }
                catch (MalformedObjectNameException e) {
                    throw new MBeanRegistrationException(e);
                }
            }
            if (implementation instanceof TopicView) {
                TopicView view = (TopicView)implementation;
                try {
                    name = new ObjectName("fabric3:SubDomain=runtime, type=resource, group=ActiveMQ, brokerName=" + this.brokerName + ", subgroup=topics, queueName=" + JMXSupport.encodeObjectNamePart((String)view.getName()));
                }
                catch (MalformedObjectNameException e) {
                    throw new MBeanRegistrationException(e);
                }
            }
        }
        return name;
    }
}

