/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.activemq.control;

import java.net.URI;
import java.util.Set;
import javax.xml.namespace.QName;
import org.fabric3.binding.jms.model.JmsBindingDefinition;
import org.fabric3.binding.jms.spi.common.ConnectionFactoryDefinition;
import org.fabric3.binding.jms.spi.common.CreateOption;
import org.fabric3.binding.jms.spi.common.DestinationDefinition;
import org.fabric3.binding.jms.spi.common.DestinationType;
import org.fabric3.binding.jms.spi.common.JmsBindingMetadata;
import org.fabric3.binding.jms.spi.common.ResponseDefinition;
import org.fabric3.model.type.component.BindingDefinition;
import org.fabric3.model.type.contract.Operation;
import org.fabric3.model.type.contract.ServiceContract;
import org.fabric3.spi.binding.provider.BindingMatchResult;
import org.fabric3.spi.binding.provider.BindingProvider;
import org.fabric3.spi.binding.provider.BindingSelectionException;
import org.fabric3.spi.model.instance.Bindable;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalChannel;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalOperation;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.model.instance.LogicalWire;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class ActiveMQBindingProvider
implements BindingProvider {
    private static final BindingMatchResult NO_MATCH = new BindingMatchResult(false, JmsBindingDefinition.BINDING_QNAME);
    private static final QName OASIS_TRANSACTED_ONEWAY = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "transactedOneWay");
    private static final QName OASIS_ONEWAY = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "oneWay");
    private String connectionFactory;
    private String xaConnectionFactory;
    private boolean enabled = true;

    @Property
    public void setConnectionFactory(String name) {
        this.connectionFactory = name;
    }

    @Property
    public void setXaConnectionFactory(String name) {
        this.xaConnectionFactory = name;
    }

    @Property(required=false)
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public QName getType() {
        return JmsBindingDefinition.BINDING_QNAME;
    }

    public BindingMatchResult canBind(LogicalWire wire) {
        if (!this.enabled) {
            return NO_MATCH;
        }
        return new BindingMatchResult(true, this.getType());
    }

    public BindingMatchResult canBind(LogicalChannel channel) {
        if (!this.enabled) {
            return NO_MATCH;
        }
        return new BindingMatchResult(true, this.getType());
    }

    public void bind(LogicalWire wire) throws BindingSelectionException {
        LogicalReference source = wire.getSource().getLeafReference();
        LogicalService target = wire.getTarget().getLeafService();
        QName deployable = ((LogicalComponent)source.getParent()).getDeployable();
        ServiceContract targetContract = target.getDefinition().getServiceContract();
        boolean response = this.isRequestResponse(targetContract);
        String forwardQueue = target.getUri().toString();
        JmsBindingDefinition referenceDefinition = this.createBindingDefinition(forwardQueue, response, false);
        LogicalBinding referenceBinding = new LogicalBinding((BindingDefinition)referenceDefinition, (Bindable)source, deployable);
        referenceBinding.setAssigned(true);
        source.addBinding(referenceBinding);
        boolean xa = this.isXA(target, false);
        JmsBindingDefinition serviceDefinition = this.createBindingDefinition(forwardQueue, response, xa);
        LogicalBinding serviceBinding = new LogicalBinding((BindingDefinition)serviceDefinition, (Bindable)target, deployable);
        serviceBinding.setAssigned(true);
        target.addBinding(serviceBinding);
        if (targetContract.getCallbackContract() != null) {
            String callbackQueue = source.getUri().toString();
            boolean callbackXa = this.isXA(target, true);
            JmsBindingDefinition callbackReferenceDefinition = this.createBindingDefinition(callbackQueue, false, callbackXa);
            LogicalBinding callbackReferenceBinding = new LogicalBinding((BindingDefinition)callbackReferenceDefinition, (Bindable)source, deployable);
            callbackReferenceBinding.setAssigned(true);
            source.addCallbackBinding(callbackReferenceBinding);
            JmsBindingDefinition callbackServiceDefinition = this.createBindingDefinition(callbackQueue, false, false);
            LogicalBinding callbackServiceBinding = new LogicalBinding((BindingDefinition)callbackServiceDefinition, (Bindable)target, deployable);
            callbackServiceBinding.setAssigned(true);
            target.addCallbackBinding(callbackServiceBinding);
            callbackReferenceDefinition.setGeneratedTargetUri(this.createCallbackUri(source));
            callbackServiceDefinition.setGeneratedTargetUri(this.createCallbackUri(source));
        }
    }

    private boolean isRequestResponse(ServiceContract targetContract) {
        for (Operation operation : targetContract.getOperations()) {
            if (operation.getIntents().contains(OASIS_ONEWAY)) continue;
            return true;
        }
        return false;
    }

    public void bind(LogicalChannel channel) {
        QName deployable = ((LogicalComponent)channel.getParent()).getDeployable();
        String topic = channel.getUri().toString();
        JmsBindingDefinition channelDefinition = this.createTopicBindingDefinition(topic);
        LogicalBinding channelBinding = new LogicalBinding((BindingDefinition)channelDefinition, (Bindable)channel, deployable);
        channelBinding.setAssigned(true);
        channel.addBinding(channelBinding);
    }

    private JmsBindingDefinition createBindingDefinition(String queueName, boolean response, boolean xa) {
        JmsBindingMetadata metadata = new JmsBindingMetadata();
        DestinationDefinition destinationDefinition = new DestinationDefinition();
        destinationDefinition.setType(DestinationType.QUEUE);
        destinationDefinition.setCreate(CreateOption.IF_NOT_EXIST);
        destinationDefinition.setName(queueName);
        metadata.setDestination(destinationDefinition);
        ConnectionFactoryDefinition factoryDefinition = new ConnectionFactoryDefinition();
        if (xa && this.xaConnectionFactory != null) {
            factoryDefinition.setName(this.xaConnectionFactory);
            factoryDefinition.setCreate(CreateOption.NEVER);
            metadata.setConnectionFactory(factoryDefinition);
        } else if (!xa && this.connectionFactory != null) {
            factoryDefinition.setName(this.connectionFactory);
            factoryDefinition.setCreate(CreateOption.NEVER);
            metadata.setConnectionFactory(factoryDefinition);
        }
        if (response) {
            DestinationDefinition responseDestinationDefinition = new DestinationDefinition();
            responseDestinationDefinition.setType(DestinationType.QUEUE);
            responseDestinationDefinition.setCreate(CreateOption.IF_NOT_EXIST);
            responseDestinationDefinition.setName(queueName + "Response");
            ResponseDefinition responseDefinition = new ResponseDefinition();
            responseDefinition.setConnectionFactory(factoryDefinition);
            responseDefinition.setDestination(responseDestinationDefinition);
            metadata.setResponse(responseDefinition);
        }
        JmsBindingDefinition definition = new JmsBindingDefinition(metadata);
        definition.setJmsMetadata(metadata);
        definition.setName("bindingSCAJMS");
        return definition;
    }

    private JmsBindingDefinition createTopicBindingDefinition(String topicName) {
        JmsBindingMetadata metadata = new JmsBindingMetadata();
        DestinationDefinition destinationDefinition = new DestinationDefinition();
        destinationDefinition.setType(DestinationType.TOPIC);
        destinationDefinition.setCreate(CreateOption.IF_NOT_EXIST);
        destinationDefinition.setName(topicName);
        metadata.setDestination(destinationDefinition);
        if (this.connectionFactory != null) {
            ConnectionFactoryDefinition factoryDefinition = new ConnectionFactoryDefinition();
            factoryDefinition.setName(this.connectionFactory);
            factoryDefinition.setCreate(CreateOption.NEVER);
            metadata.setConnectionFactory(factoryDefinition);
        }
        JmsBindingDefinition definition = new JmsBindingDefinition(metadata);
        definition.setJmsMetadata(metadata);
        definition.setName("bindingSCAJMS");
        return definition;
    }

    public URI createCallbackUri(LogicalReference source) {
        LogicalComponent component = (LogicalComponent)source.getParent();
        String name = source.getDefinition().getServiceContract().getCallbackContract().getInterfaceName();
        return URI.create(component.getUri() + "#" + name);
    }

    private boolean isXA(LogicalService service, boolean callback) {
        if (callback) {
            for (LogicalOperation operation : service.getCallbackOperations()) {
                if (!this.containsTransactionIntent(operation.getIntents())) continue;
                return true;
            }
        } else {
            for (LogicalOperation operation : service.getOperations()) {
                if (!this.containsTransactionIntent(operation.getIntents())) continue;
                return true;
            }
        }
        for (LogicalComponent parent = (LogicalComponent)service.getParent(); parent != null; parent = (LogicalComponent)parent.getParent()) {
            if (this.containsTransactionIntent(parent.getIntents())) {
                return true;
            }
            if (!this.containsTransactionIntent(parent.getDefinition().getImplementation().getIntents())) continue;
            return true;
        }
        return false;
    }

    private boolean containsTransactionIntent(Set<QName> intents) {
        return intents.contains(OASIS_TRANSACTED_ONEWAY);
    }
}

