/*
 * Decompiled with CFR 0.152.
 */
package groovy.util;

import groovy.util.AntBuilderLocator;
import groovy.util.BuilderSupport;
import groovy.xml.QName;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DemuxInputStream;
import org.apache.tools.ant.NoBannerLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.helper.AntXMLContext;
import org.apache.tools.ant.helper.ProjectHelper2;
import org.apache.tools.ant.input.DefaultInputHandler;
import org.apache.tools.ant.input.InputHandler;
import org.codehaus.groovy.ant.FileScanner;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;

public class AntBuilder
extends BuilderSupport {
    private static final Class[] ADD_TASK_PARAM_TYPES = new Class[]{String.class};
    private final Logger log = Logger.getLogger(this.getClass().getName());
    private Project project;
    private final AntXMLContext antXmlContext;
    private final ProjectHelper2.ElementHandler antElementHandler = new ProjectHelper2.ElementHandler();
    private final Target collectorTarget;
    private Object lastCompletedNode;

    public AntBuilder() {
        this(AntBuilder.createProject());
    }

    public AntBuilder(Project project) {
        this(project, new Target());
    }

    public AntBuilder(Project project, Target owningTarget) {
        this.project = project;
        this.project.setInputHandler((InputHandler)new DefaultInputHandler());
        this.collectorTarget = owningTarget;
        this.antXmlContext = new AntXMLContext(project);
        this.collectorTarget.setProject(project);
        this.antXmlContext.setCurrentTarget(this.collectorTarget);
        this.antXmlContext.setLocator((Locator)new AntBuilderLocator());
        project.addDataTypeDefinition("fileScanner", FileScanner.class);
    }

    public AntBuilder(Task parentTask) {
        this(parentTask.getProject(), parentTask.getOwningTarget());
        UnknownElement ue = new UnknownElement(parentTask.getTaskName());
        ue.setProject(parentTask.getProject());
        ue.setTaskType(parentTask.getTaskType());
        ue.setTaskName(parentTask.getTaskName());
        ue.setLocation(parentTask.getLocation());
        ue.setOwningTarget(parentTask.getOwningTarget());
        ue.setRuntimeConfigurableWrapper(parentTask.getRuntimeConfigurableWrapper());
        parentTask.getRuntimeConfigurableWrapper().setProxy((Object)ue);
        this.antXmlContext.pushWrapper(parentTask.getRuntimeConfigurableWrapper());
    }

    public Project getProject() {
        return this.project;
    }

    protected static Project createProject() {
        Project project = new Project();
        NoBannerLogger logger = new NoBannerLogger();
        logger.setMessageOutputLevel(2);
        logger.setOutputPrintStream(System.out);
        logger.setErrorPrintStream(System.err);
        project.addBuildListener((BuildListener)logger);
        project.init();
        project.getBaseDir();
        return project;
    }

    protected void setParent(Object parent, Object child) {
    }

    protected Object doInvokeMethod(String methodName, Object name, Object args) {
        super.doInvokeMethod(methodName, name, args);
        return this.lastCompletedNode;
    }

    protected void nodeCompleted(Object parent, Object node) {
        this.antElementHandler.onEndElement(null, null, this.antXmlContext);
        this.lastCompletedNode = node;
        if (parent != null) {
            this.log.finest("parent is not null: no perform on nodeCompleted");
            return;
        }
        if (node instanceof Task) {
            Object task = node;
            if (node instanceof UnknownElement) {
                UnknownElement unknownElement = (UnknownElement)node;
                unknownElement.maybeConfigure();
                task = unknownElement.getRealThing();
            }
            this.lastCompletedNode = task;
            if (task instanceof Task) {
                InputStream originalIn = System.in;
                InputStream projectDefaultStream = this.project.getDefaultInputStream();
                this.project.setDefaultInputStream(originalIn);
                System.setIn((InputStream)new DemuxInputStream(this.project));
                ((Task)task).perform();
                System.setIn(originalIn);
                this.project.setDefaultInputStream(projectDefaultStream);
            }
        } else {
            RuntimeConfigurable r = (RuntimeConfigurable)node;
            r.maybeConfigure(this.project);
        }
    }

    protected Object createNode(Object tagName) {
        return this.createNode(tagName, Collections.EMPTY_MAP);
    }

    protected Object createNode(Object name, Object value) {
        Object task = this.createNode(name);
        this.setText(task, value.toString());
        return task;
    }

    protected Object createNode(Object name, Map attributes, Object value) {
        Object task = this.createNode(name, attributes);
        this.setText(task, value.toString());
        return task;
    }

    protected static Attributes buildAttributes(Map attributes) {
        AttributesImpl attr = new AttributesImpl();
        Iterator iter = attributes.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String attributeName = (String)entry.getKey();
            String attributeValue = String.valueOf(entry.getValue());
            attr.addAttribute(null, attributeName, attributeName, "CDATA", attributeValue);
        }
        return attr;
    }

    protected Object createNode(Object name, Map attributes) {
        String tagName = name.toString();
        String ns = "";
        if (name instanceof QName) {
            QName q = (QName)name;
            tagName = q.getLocalPart();
            ns = q.getNamespaceURI();
        }
        try {
            this.antElementHandler.onStartElement(ns, tagName, tagName, AntBuilder.buildAttributes(attributes), this.antXmlContext);
        }
        catch (SAXParseException e) {
            this.log.log(Level.SEVERE, "Caught: " + e, e);
        }
        RuntimeConfigurable wrapper = (RuntimeConfigurable)this.antXmlContext.getWrapperStack().lastElement();
        return wrapper.getProxy();
    }

    protected void setText(Object task, String text) {
        char[] characters = text.toCharArray();
        try {
            this.antElementHandler.characters(characters, 0, characters.length, this.antXmlContext);
        }
        catch (SAXParseException e) {
            this.log.log(Level.WARNING, "SetText failed: " + task + ". Reason: " + e, e);
        }
    }

    public Project getAntProject() {
        return this.project;
    }
}

