/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.Comment;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.ImportNodeCompatibilityWrapper;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.PackageNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.TaskEntry;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.ExceptionMessage;
import org.codehaus.groovy.control.messages.LocatedMessage;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.CSTNode;
import org.codehaus.groovy.syntax.PreciseSyntaxException;
import org.codehaus.groovy.syntax.RuntimeParserException;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.tools.GroovyClass;
import org.codehaus.jdt.groovy.core.dom.GroovyCompilationUnit;
import org.codehaus.jdt.groovy.internal.compiler.ast.AliasImportReference;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyClassFile;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyCompilationUnitScope;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyEclipseBug;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyTypeDeclaration;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.AnnotationMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.ast.MarkerAnnotation;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.Wildcard;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.IrritantSet;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.core.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyCompilationUnitDeclaration
extends CompilationUnitDeclaration {
    private org.codehaus.groovy.control.CompilationUnit groovyCompilationUnit;
    private SourceUnit groovySourceUnit;
    private CompilerOptions compilerOptions;
    private boolean checkGenerics;
    public static boolean defaultCheckGenerics = false;
    public static boolean earlyTransforms = true;
    private boolean isScript = false;
    private static final boolean DEBUG_TASK_TAGS = false;
    private static final Map<Character, Integer> charToTypeId = new HashMap<Character, Integer>();
    private static final Map<String, Integer> nameToPrimitiveTypeId = new HashMap<String, Integer>();
    private static long NON_EXISTENT_POSITION;
    private static final boolean DEBUG = false;

    static {
        charToTypeId.put(Character.valueOf('D'), 8);
        charToTypeId.put(Character.valueOf('I'), 10);
        charToTypeId.put(Character.valueOf('F'), 9);
        charToTypeId.put(Character.valueOf('J'), 7);
        charToTypeId.put(Character.valueOf('Z'), 5);
        charToTypeId.put(Character.valueOf('B'), 3);
        charToTypeId.put(Character.valueOf('C'), 2);
        charToTypeId.put(Character.valueOf('S'), 4);
        nameToPrimitiveTypeId.put("double", 8);
        nameToPrimitiveTypeId.put("int", 10);
        nameToPrimitiveTypeId.put("float", 9);
        nameToPrimitiveTypeId.put("long", 7);
        nameToPrimitiveTypeId.put("boolean", 5);
        nameToPrimitiveTypeId.put("byte", 3);
        nameToPrimitiveTypeId.put("char", 2);
        nameToPrimitiveTypeId.put("short", 4);
        nameToPrimitiveTypeId.put("void", 6);
        try {
            String value = System.getProperty("\tearlyTransforms");
            if (value != null) {
                if (value.equalsIgnoreCase("true")) {
                    System.out.println("groovyeclipse.earlyTransforms = true");
                    earlyTransforms = true;
                } else if (value.equalsIgnoreCase("false")) {
                    System.out.println("groovyeclipse.earlyTransforms = false");
                    earlyTransforms = false;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        NON_EXISTENT_POSITION = GroovyCompilationUnitDeclaration.toPos(-1L, -2L);
    }

    public GroovyCompilationUnitDeclaration(ProblemReporter problemReporter, CompilationResult compilationResult, int sourceLength, org.codehaus.groovy.control.CompilationUnit groovyCompilationUnit, SourceUnit groovySourceUnit, CompilerOptions compilerOptions) {
        super(problemReporter, compilationResult, sourceLength);
        this.groovyCompilationUnit = groovyCompilationUnit;
        this.groovySourceUnit = groovySourceUnit;
        this.compilerOptions = compilerOptions;
        this.checkGenerics = defaultCheckGenerics;
    }

    private void setComments() {
        List<Comment> groovyComments = this.groovySourceUnit.getComments();
        if (groovyComments == null || groovyComments.size() == 0) {
            return;
        }
        this.comments = new int[groovyComments.size()][2];
        int c = 0;
        int max = groovyComments.size();
        while (c < max) {
            Comment groovyComment = groovyComments.get(c);
            this.comments[c] = groovyComment.getPositions(this.compilationResult.lineSeparatorPositions);
            ++c;
        }
    }

    public boolean processToPhase(int phase) {
        block12: {
            boolean alreadyHasProblems = this.compilationResult.hasProblems();
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(this.groovyCompilationUnit.getTransformLoader());
                    this.groovyCompilationUnit.compile(phase);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(cl);
                }
                if (this.groovySourceUnit.getErrorCollector().hasErrors()) {
                    this.recordProblems(this.groovySourceUnit.getErrorCollector().getErrors());
                    return false;
                }
                return true;
            }
            catch (MultipleCompilationErrorsException problems) {
                AbortCompilation abort = this.getAbortCompilation(problems);
                if (abort != null) {
                    System.out.println("Abort compilation");
                    throw abort;
                }
                System.err.println("exception handling");
                problems.printStackTrace();
                this.recordProblems(problems.getErrorCollector().getErrors());
            }
            catch (GroovyBugError gbr) {
                if (alreadyHasProblems) {
                    System.err.println("Ignoring GroovyBugError since it is likely caused by earlier issues.  Ignored problem is '" + gbr.getMessage() + "'");
                }
                boolean reportit = true;
                if (gbr.getCause() instanceof AbortCompilation) {
                    AbortCompilation abort = (AbortCompilation)gbr.getCause();
                    if (abort.isSilent) {
                        reportit = false;
                    }
                }
                if (!reportit) break block12;
                System.err.println("Groovy Bug --- " + gbr.getBugText());
                gbr.printStackTrace();
                Util.log((Throwable)((Object)gbr), "Groovy bug when compiling.");
            }
        }
        return false;
    }

    private AbortCompilation getAbortCompilation(MultipleCompilationErrorsException problems) {
        ErrorCollector collector = problems.getErrorCollector();
        if (collector.getErrorCount() == 1 && problems.getErrorCollector().getError(0) instanceof ExceptionMessage) {
            Exception abort = ((ExceptionMessage)problems.getErrorCollector().getError(0)).getCause();
            return abort instanceof AbortCompilation ? (AbortCompilation)abort : null;
        }
        return null;
    }

    public org.codehaus.groovy.control.CompilationUnit getCompilationUnit() {
        return this.groovyCompilationUnit;
    }

    public void populateCompilationUnitDeclaration() {
        ModuleNode moduleNode = this.groovySourceUnit.getAST();
        this.createPackageDeclaration(moduleNode);
        this.createImports(moduleNode);
        this.createTypeDeclarations(moduleNode);
    }

    protected void createImports(ModuleNode moduleNode) {
        List<ImportNode> importNodes = moduleNode.getImports();
        List<ImportNode> importPackages = ImportNodeCompatibilityWrapper.getStarImports(moduleNode);
        Map<String, ImportNode> importStatics = ImportNodeCompatibilityWrapper.getStaticImports(moduleNode);
        Map<String, ImportNode> importStaticStars = ImportNodeCompatibilityWrapper.getStaticStarImports(moduleNode);
        if (importNodes.size() > 0 || importPackages.size() > 0 || importStatics.size() > 0 || importStaticStars.size() > 0) {
            int typeEndOffset;
            int typeStartOffset;
            ArrayList<ImportReference> importReferences = new ArrayList<ImportReference>();
            for (ImportNode importNode : importNodes) {
                int end;
                int start;
                char[][] splits = CharOperation.splitOn('.', importNode.getClassName().toCharArray());
                ImportReference ref = null;
                ClassNode type = importNode.getType();
                typeStartOffset = this.startOffset(type);
                typeEndOffset = this.endOffset(type);
                if (typeStartOffset == 0) continue;
                ref = importNode.getAlias() != null && importNode.getAlias().length() > 0 ? new AliasImportReference(importNode.getAlias().toCharArray(), splits, this.positionsFor(splits, typeStartOffset, typeEndOffset), false, 0) : new ImportReference(splits, this.positionsFor(splits, typeStartOffset, typeEndOffset), false, 0);
                ref.sourceEnd = Math.max(typeEndOffset - 1, ref.sourceStart);
                ref.declarationSourceStart = start = importNode.getStart();
                ref.declarationSourceEnd = end = importNode.getEnd();
                ref.declarationEnd = ref.sourceEnd;
                importReferences.add(ref);
            }
            for (ImportNode importNode : importPackages) {
                String importText = importNode.getText();
                int packageStartOffset = importNode.getStart() + "import ".length();
                int packageEndOffset = packageStartOffset + importText.length() - "import ".length() - ".*".length();
                char[][] splits = CharOperation.splitOn('.', importNode.getPackageName().substring(0, importNode.getPackageName().length() - 1).toCharArray());
                ImportReference ref = new ImportReference(splits, this.positionsFor(splits, packageStartOffset, packageEndOffset), true, 0);
                ref.sourceEnd = packageEndOffset;
                ref.declarationSourceStart = importNode.getStart();
                ref.declarationSourceEnd = importNode.getEnd();
                ref.declarationEnd = ref.sourceEnd;
                importReferences.add(ref);
            }
            for (Map.Entry entry : importStatics.entrySet()) {
                ImportNode importNode = (ImportNode)entry.getValue();
                String importName = String.valueOf(importNode.getClassName()) + "." + (String)entry.getKey();
                char[][] splits = CharOperation.splitOn('.', importName.toCharArray());
                ImportReference ref = null;
                ClassNode type = importNode.getType();
                int typeStartOffset2 = this.startOffset(type);
                int typeEndOffset2 = this.endOffset(type);
                ref = importNode.getAlias() != null && importNode.getAlias().length() > 0 ? new AliasImportReference(importNode.getAlias().toCharArray(), splits, this.positionsFor(splits, typeStartOffset2, typeEndOffset2), false, 8) : new ImportReference(splits, this.positionsFor(splits, typeStartOffset2, typeEndOffset2), false, 8);
                ref.sourceEnd = Math.max(typeEndOffset2 - 1, ref.sourceStart);
                ref.declarationSourceStart = importNode.getStart();
                ref.declarationSourceEnd = importNode.getEnd();
                ref.declarationEnd = ref.sourceEnd;
                importReferences.add(ref);
            }
            for (Map.Entry entry : importStaticStars.entrySet()) {
                String classname = (String)entry.getKey();
                ImportNode importNode = (ImportNode)entry.getValue();
                ClassNode importedType = importNode.getType();
                typeStartOffset = importedType != null ? this.startOffset(importedType) : 0;
                typeEndOffset = importedType != null ? this.endOffset(importedType) : 0;
                char[][] splits = CharOperation.splitOn('.', classname.toCharArray());
                ImportReference ref = new ImportReference(splits, this.positionsFor(splits, typeStartOffset, typeEndOffset), true, 8);
                ref.sourceEnd = Math.max(typeEndOffset - 1, ref.sourceStart);
                ref.declarationSourceStart = importNode.getStart();
                ref.declarationSourceEnd = importNode.getEnd();
                ref.declarationEnd = ref.sourceEnd;
                importReferences.add(ref);
            }
            if (importReferences.size() != 0) {
                this.imports = importReferences.toArray(new ImportReference[importReferences.size()]);
                Arrays.sort(this.imports, new Comparator<ImportReference>(){

                    @Override
                    public int compare(ImportReference left, ImportReference right) {
                        return left.sourceStart - right.sourceStart;
                    }
                });
                ImportReference[] importReferenceArray = this.imports;
                int n = this.imports.length;
                int n2 = 0;
                while (n2 < n) {
                    ImportReference importReference = importReferenceArray[n2];
                    if (importReference.declarationSourceStart > 0 && importReference.declarationEnd - importReference.declarationSourceStart + 1 < 0) {
                        throw new IllegalStateException("Import reference alongside class " + moduleNode.getClasses().get(0) + " will trigger later failure: " + importReference.toString() + " declSourceStart=" + importReference.declarationSourceStart + " declEnd=" + importReference.declarationEnd);
                    }
                    ++n2;
                }
            }
        }
    }

    private void createPackageDeclaration(ModuleNode moduleNode) {
        if (moduleNode.hasPackageName()) {
            PackageNode packageNode = moduleNode.getPackage();
            String packageName = moduleNode.getPackageName();
            if (packageName.endsWith(".")) {
                packageName = packageName.substring(0, packageName.length() - 1);
            }
            long start = this.startOffset(packageNode);
            long end = this.endOffset(packageNode);
            char[][] packageReference = CharOperation.splitOn('.', packageName.toCharArray());
            this.currentPackage = new ImportReference(packageReference, this.positionsFor(packageReference, start, end), true, 0);
            this.currentPackage.declarationSourceStart = this.currentPackage.sourceStart;
            this.currentPackage.declarationSourceEnd = this.currentPackage.sourceEnd;
            this.currentPackage.declarationEnd = this.currentPackage.sourceEnd;
            this.currentPackage.declarationSourceStart = this.currentPackage.sourceStart - "package ".length();
            this.currentPackage.declarationEnd = this.currentPackage.declarationSourceEnd = this.currentPackage.sourceEnd;
        }
    }

    private Annotation[] transformAnnotations(List<AnnotationNode> groovyAnnotations) {
        if (groovyAnnotations != null && groovyAnnotations.size() > 0) {
            ArrayList<Annotation> annotations = new ArrayList<Annotation>();
            for (AnnotationNode annotationNode : groovyAnnotations) {
                MarkerAnnotation annotation;
                TypeReference annotationReference;
                ClassNode annoType = annotationNode.getClassNode();
                Map<String, Expression> memberValuePairs = annotationNode.getMembers();
                if (memberValuePairs == null || memberValuePairs.size() == 0) {
                    annotationReference = this.createTypeReferenceForClassNode(annoType);
                    annotationReference.sourceStart = annotationNode.getStart();
                    annotationReference.sourceEnd = annotationNode.getEnd();
                    annotation = new MarkerAnnotation(annotationReference, annotationNode.getStart());
                    annotation.declarationSourceEnd = annotation.sourceEnd;
                    annotations.add(annotation);
                    continue;
                }
                if (memberValuePairs.size() == 1 && memberValuePairs.containsKey("value")) {
                    SingleMemberAnnotation annotation2;
                    TypeReference annotationReference2;
                    Expression value = memberValuePairs.get("value");
                    if (value instanceof PropertyExpression) {
                        String pExpression = ((PropertyExpression)value).getPropertyAsString();
                        if (!pExpression.equals("class")) continue;
                        annotationReference2 = this.createTypeReferenceForClassNode(annoType);
                        annotationReference2.sourceStart = annotationNode.getStart();
                        annotationReference2.sourceEnd = annotationNode.getEnd();
                        annotation2 = new SingleMemberAnnotation(annotationReference2, annotationNode.getStart());
                        annotation2.memberValue = new ClassLiteralAccess(value.getEnd(), this.classLiteralToTypeReference((PropertyExpression)value));
                        annotation2.declarationSourceEnd = annotation2.sourceStart + annoType.getNameWithoutPackage().length();
                        annotations.add(annotation2);
                        continue;
                    }
                    if (value instanceof VariableExpression && annoType.getName().endsWith("RunWith")) {
                        TypeReference annotationReference3 = this.createTypeReferenceForClassNode(annoType);
                        annotationReference3.sourceStart = annotationNode.getStart();
                        annotationReference3.sourceEnd = annotationNode.getEnd();
                        SingleMemberAnnotation annotation3 = new SingleMemberAnnotation(annotationReference3, annotationNode.getStart());
                        String v = ((VariableExpression)value).getName();
                        TypeReference ref = null;
                        int start = annotationReference3.sourceStart;
                        int end = annotationReference3.sourceEnd;
                        if (v.indexOf(".") == -1) {
                            ref = new SingleTypeReference(v.toCharArray(), GroovyCompilationUnitDeclaration.toPos(start, end - 1));
                        } else {
                            char[][] splits = CharOperation.splitOn('.', v.toCharArray());
                            ref = new QualifiedTypeReference(splits, this.positionsFor(splits, start, end - 2));
                        }
                        annotation3.memberValue = new ClassLiteralAccess(value.getEnd(), ref);
                        annotation3.declarationSourceEnd = annotation3.sourceStart + annoType.getNameWithoutPackage().length();
                        annotations.add(annotation3);
                        continue;
                    }
                    if (!annoType.getName().equals("SuppressWarnings") || !(value instanceof ConstantExpression) && !(value instanceof ListExpression)) continue;
                    if (value instanceof ListExpression) {
                        ListExpression listExpression = (ListExpression)value;
                        List<Expression> listOfExpressions = listExpression.getExpressions();
                        TypeReference annotationReference4 = this.createTypeReferenceForClassNode(annoType);
                        annotationReference4.sourceStart = annotationNode.getStart();
                        annotationReference4.sourceEnd = annotationNode.getEnd() - 1;
                        SingleMemberAnnotation annotation4 = new SingleMemberAnnotation(annotationReference4, annotationNode.getStart());
                        ArrayInitializer arrayInitializer = new ArrayInitializer();
                        arrayInitializer.expressions = new org.eclipse.jdt.internal.compiler.ast.Expression[listOfExpressions.size()];
                        int c = 0;
                        while (c < listOfExpressions.size()) {
                            ConstantExpression cExpression = (ConstantExpression)listOfExpressions.get(c);
                            String v = (String)cExpression.getValue();
                            TypeReference ref = null;
                            int start = cExpression.getStart();
                            int end = cExpression.getEnd() - 1;
                            if (v.indexOf(".") == -1) {
                                ref = new SingleTypeReference(v.toCharArray(), GroovyCompilationUnitDeclaration.toPos(start, end - 1));
                                annotation4.declarationSourceEnd = annotation4.sourceStart + annoType.getNameWithoutPackage().length() - 1;
                            } else {
                                char[][] splits = CharOperation.splitOn('.', v.toCharArray());
                                ref = new QualifiedTypeReference(splits, this.positionsFor(splits, start, end - 2));
                                annotation4.declarationSourceEnd = annotation4.sourceStart + annoType.getName().length() - 1;
                            }
                            arrayInitializer.expressions[c] = new StringLiteral(v.toCharArray(), start, end, -1);
                            ++c;
                        }
                        annotation4.memberValue = arrayInitializer;
                        annotations.add(annotation4);
                        continue;
                    }
                    ConstantExpression constantExpression = (ConstantExpression)value;
                    if (!value.getType().getName().equals("java.lang.String")) continue;
                    annotationReference2 = this.createTypeReferenceForClassNode(annoType);
                    annotationReference2.sourceStart = annotationNode.getStart();
                    annotationReference2.sourceEnd = annotationNode.getEnd() - 1;
                    annotation2 = new SingleMemberAnnotation(annotationReference2, annotationNode.getStart());
                    String v = (String)constantExpression.getValue();
                    TypeReference ref = null;
                    int start = constantExpression.getStart();
                    int end = constantExpression.getEnd() - 1;
                    if (v.indexOf(".") == -1) {
                        ref = new SingleTypeReference(v.toCharArray(), GroovyCompilationUnitDeclaration.toPos(start, end - 1));
                        annotation2.declarationSourceEnd = annotation2.sourceStart + annoType.getNameWithoutPackage().length() - 1;
                    } else {
                        char[][] splits = CharOperation.splitOn('.', v.toCharArray());
                        ref = new QualifiedTypeReference(splits, this.positionsFor(splits, start, end - 2));
                        annotation2.declarationSourceEnd = annotation2.sourceStart + annoType.getName().length() - 1;
                    }
                    annotation2.memberValue = new StringLiteral(v.toCharArray(), start, end, -1);
                    annotations.add(annotation2);
                    continue;
                }
                if (!annoType.getNameWithoutPackage().equals("Test")) continue;
                annotationReference = this.createTypeReferenceForClassNode(annoType);
                annotationReference.sourceStart = annotationNode.getStart();
                annotationReference.sourceEnd = annotationNode.getEnd();
                annotation = new MarkerAnnotation(annotationReference, annotationNode.getStart());
                annotation.declarationSourceEnd = annotation.sourceEnd;
                annotations.add(annotation);
            }
            if (annotations.size() > 0) {
                return annotations.toArray(new Annotation[annotations.size()]);
            }
        }
        return null;
    }

    private TypeReference classLiteralToTypeReference(PropertyExpression value) {
        assert (value.getPropertyAsString().equals("class"));
        Expression candidate = value.getObjectExpression();
        LinkedList<char[]> nameParts = new LinkedList<char[]>();
        while (candidate instanceof PropertyExpression) {
            nameParts.add(0, ((PropertyExpression)candidate).getPropertyAsString().toCharArray());
            candidate = ((PropertyExpression)candidate).getObjectExpression();
        }
        if (candidate instanceof VariableExpression) {
            nameParts.add(0, ((VariableExpression)candidate).getName().toCharArray());
        }
        char[][] namePartsArr = (char[][])nameParts.toArray((T[])new char[nameParts.size()][]);
        long[] poss = this.positionsFor(namePartsArr, value.getObjectExpression().getStart(), value.getObjectExpression().getEnd());
        TypeReference ref = namePartsArr.length > 1 ? new QualifiedTypeReference(namePartsArr, poss) : (namePartsArr.length == 1 ? new SingleTypeReference(namePartsArr[0], poss[0]) : TypeReference.baseTypeReference(nameToPrimitiveTypeId.get("void"), 0));
        return ref;
    }

    private Javadoc findJavadoc(int line) {
        for (Comment comment : this.groovySourceUnit.getComments()) {
            if (!comment.isJavadoc() || comment.getLastLine() + 1 != line && (comment.getLastLine() + 2 != line || comment.usedUp)) continue;
            int[] pos = comment.getPositions(this.compilationResult.lineSeparatorPositions);
            comment.usedUp = true;
            return new Javadoc(pos[0], pos[1]);
        }
        return null;
    }

    private void createTypeDeclarations(ModuleNode moduleNode) {
        List<ClassNode> moduleClassNodes = moduleNode.getClasses();
        ArrayList<GroovyTypeDeclaration> typeDeclarations = new ArrayList<GroovyTypeDeclaration>();
        HashMap<ClassNode, GroovyTypeDeclaration> fromClassNodeToDecl = new HashMap<ClassNode, GroovyTypeDeclaration>();
        char[] mainName = this.toMainName(this.compilationResult.getFileName());
        boolean isInner = false;
        List<ClassNode> classNodes = null;
        classNodes = moduleClassNodes;
        HashMap<ClassNode, ArrayList<GroovyTypeDeclaration>> innersToRecord = new HashMap<ClassNode, ArrayList<GroovyTypeDeclaration>>();
        for (ClassNode classNode : classNodes) {
            if (!classNode.isPrimaryClassNode()) continue;
            GroovyTypeDeclaration typeDeclaration = new GroovyTypeDeclaration(this.compilationResult, classNode);
            typeDeclaration.annotations = this.transformAnnotations(classNode.getAnnotations());
            if (classNode instanceof InnerClassNode) {
                InnerClassNode innerClassNode = (InnerClassNode)classNode;
                ClassNode outerClass = innerClassNode.getOuterClass();
                String outername = outerClass.getNameWithoutPackage();
                String newInner = innerClassNode.getNameWithoutPackage().substring(outername.length() + 1);
                typeDeclaration.name = newInner.toCharArray();
                isInner = true;
            } else {
                typeDeclaration.name = classNode.getNameWithoutPackage().toCharArray();
                isInner = false;
            }
            boolean isInterface = classNode.isInterface();
            int mods = classNode.getModifiers();
            if ((mods & 0x4000) != 0) {
                mods &= 0xFFFFFFEF;
            }
            if (!isInner && ((mods &= 0xFFFFFFF9) & 8) != 0) {
                mods &= 0xFFFFFFF7;
            }
            typeDeclaration.modifiers = mods & ~(isInterface ? 1024 : 0);
            if (!(classNode instanceof InnerClassNode) && !CharOperation.equals(typeDeclaration.name, mainName)) {
                typeDeclaration.bits |= 0x1000;
            }
            this.fixupSourceLocationsForTypeDeclaration(typeDeclaration, classNode);
            if (classNode.getGenericsTypes() != null) {
                GenericsType[] genericInfo = classNode.getGenericsTypes();
                typeDeclaration.typeParameters = new TypeParameter[genericInfo.length];
                int tp = 0;
                while (tp < genericInfo.length) {
                    TypeParameter typeParameter = new TypeParameter();
                    typeParameter.name = genericInfo[tp].getName().toCharArray();
                    ClassNode[] upperBounds = genericInfo[tp].getUpperBounds();
                    if (upperBounds != null) {
                        typeParameter.type = this.createTypeReferenceForClassNode(upperBounds[0]);
                        typeParameter.bounds = upperBounds.length > 1 ? new TypeReference[upperBounds.length - 1] : null;
                        int b = 1;
                        int max = upperBounds.length;
                        while (b < max) {
                            typeParameter.bounds[b - 1] = this.createTypeReferenceForClassNode(upperBounds[b]);
                            typeParameter.bounds[b - 1].bits |= 0x10;
                            ++b;
                        }
                    }
                    typeDeclaration.typeParameters[tp] = typeParameter;
                    ++tp;
                }
            }
            boolean isEnum = (classNode.getModifiers() & 0x4000) != 0;
            this.configureSuperClass(typeDeclaration, classNode.getSuperClass(), isEnum);
            this.configureSuperInterfaces(typeDeclaration, classNode);
            typeDeclaration.methods = this.createMethodAndConstructorDeclarations(classNode, isEnum, this.compilationResult);
            typeDeclaration.fields = this.createFieldDeclarations(classNode);
            typeDeclaration.properties = classNode.getProperties();
            if (classNode instanceof InnerClassNode) {
                InnerClassNode innerClassNode = (InnerClassNode)classNode;
                ClassNode outerClass = innerClassNode.getOuterClass();
                String outername = outerClass.getNameWithoutPackage();
                String newInner = innerClassNode.getNameWithoutPackage().substring(outername.length() + 1);
                typeDeclaration.name = newInner.toCharArray();
                ArrayList<GroovyTypeDeclaration> inners = (ArrayList<GroovyTypeDeclaration>)innersToRecord.get(outerClass);
                if (inners == null) {
                    inners = new ArrayList<GroovyTypeDeclaration>();
                    innersToRecord.put(outerClass, inners);
                }
                inners.add(typeDeclaration);
            } else {
                typeDeclarations.add(typeDeclaration);
            }
            fromClassNodeToDecl.put(classNode, typeDeclaration);
        }
        for (Map.Entry entry : innersToRecord.entrySet()) {
            TypeDeclaration outerTypeDeclaration = (TypeDeclaration)fromClassNodeToDecl.get(entry.getKey());
            if (outerTypeDeclaration == null) {
                throw new GroovyEclipseBug("Failed to find the type declaration for " + ((ClassNode)entry.getKey()).getName());
            }
            List newInnersList = (List)entry.getValue();
            outerTypeDeclaration.memberTypes = newInnersList.toArray(new TypeDeclaration[newInnersList.size()]);
        }
        this.types = typeDeclarations.toArray(new TypeDeclaration[typeDeclarations.size()]);
    }

    public char[] toMainName(char[] fileName) {
        int end;
        if (fileName == null) {
            return new char[0];
        }
        int start = CharOperation.lastIndexOf('/', fileName) + 1;
        if (start == 0 || start < CharOperation.lastIndexOf('\\', fileName)) {
            start = CharOperation.lastIndexOf('\\', fileName) + 1;
        }
        if ((end = CharOperation.lastIndexOf('.', fileName)) == -1) {
            end = fileName.length;
        }
        return CharOperation.subarray(fileName, start, end);
    }

    private AbstractMethodDeclaration[] createMethodAndConstructorDeclarations(ClassNode classNode, boolean isEnum, CompilationResult compilationResult) {
        ArrayList<AbstractMethodDeclaration> accumulatedDeclarations = new ArrayList<AbstractMethodDeclaration>();
        this.createConstructorDeclarations(classNode, isEnum, accumulatedDeclarations);
        this.createMethodDeclarations(classNode, isEnum, accumulatedDeclarations);
        return accumulatedDeclarations.toArray(new AbstractMethodDeclaration[accumulatedDeclarations.size()]);
    }

    private FieldDeclaration[] createFieldDeclarations(ClassNode classNode) {
        ArrayList<FieldDeclarationWithInitializer> fieldDeclarations = new ArrayList<FieldDeclarationWithInitializer>();
        List<FieldNode> fieldNodes = classNode.getFields();
        if (fieldNodes != null) {
            for (FieldNode fieldNode : fieldNodes) {
                boolean isSynthetic;
                boolean isEnumField = (fieldNode.getModifiers() & 0x4000) != 0;
                boolean bl = isSynthetic = (fieldNode.getModifiers() & 0x1000) != 0;
                if (isSynthetic) continue;
                FieldDeclarationWithInitializer fieldDeclaration = new FieldDeclarationWithInitializer(fieldNode.getName().toCharArray(), 0, 0);
                fieldDeclaration.annotations = this.transformAnnotations(fieldNode.getAnnotations());
                if (!isEnumField) {
                    fieldDeclaration.modifiers = fieldNode.getModifiers() & 0xFFFFBFFF;
                    fieldDeclaration.type = this.createTypeReferenceForClassNode(fieldNode.getType());
                }
                fieldDeclaration.javadoc = new Javadoc(108, 132);
                this.fixupSourceLocationsForFieldDeclaration(fieldDeclaration, fieldNode, isEnumField);
                fieldDeclaration.setGroovyInitializer(fieldNode.getInitialExpression());
                fieldDeclarations.add(fieldDeclaration);
            }
        }
        return fieldDeclarations.toArray(new FieldDeclaration[fieldDeclarations.size()]);
    }

    private void createConstructorDeclarations(ClassNode classNode, boolean isEnum, List<AbstractMethodDeclaration> accumulatedMethodDeclarations) {
        boolean needsDefaultCtor;
        List<ConstructorNode> constructorNodes = classNode.getDeclaredConstructors();
        char[] ctorName = null;
        if (classNode instanceof InnerClassNode) {
            InnerClassNode innerClassNode = (InnerClassNode)classNode;
            ClassNode outerClass = innerClassNode.getOuterClass();
            String outername = outerClass.getNameWithoutPackage();
            String newInner = innerClassNode.getNameWithoutPackage().substring(outername.length() + 1);
            ctorName = newInner.toCharArray();
        } else {
            ctorName = classNode.getNameWithoutPackage().toCharArray();
        }
        boolean bl = needsDefaultCtor = constructorNodes.size() == 0 && !classNode.isInterface();
        if (needsDefaultCtor) {
            ConstructorDeclaration constructor = new ConstructorDeclaration(this.compilationResult);
            constructor.bits |= 0x80;
            constructor.modifiers = isEnum ? 2 : 1;
            constructor.selector = ctorName;
            accumulatedMethodDeclarations.add(constructor);
        }
        for (ConstructorNode constructorNode : constructorNodes) {
            ConstructorDeclaration constructorDeclaration = new ConstructorDeclaration(this.compilationResult);
            this.fixupSourceLocationsForConstructorDeclaration(constructorDeclaration, constructorNode);
            constructorDeclaration.annotations = this.transformAnnotations(constructorNode.getAnnotations());
            constructorDeclaration.modifiers = isEnum ? 2 : 1;
            constructorDeclaration.selector = ctorName;
            constructorDeclaration.arguments = this.createArguments(constructorNode.getParameters(), false);
            constructorDeclaration.thrownExceptions = this.createTypeReferencesForClassNodes(constructorNode.getExceptions());
            if (constructorNode.hasDefaultValue()) {
                this.createConstructorVariants(constructorNode, constructorDeclaration, accumulatedMethodDeclarations, this.compilationResult, isEnum);
                continue;
            }
            accumulatedMethodDeclarations.add(constructorDeclaration);
        }
        if (earlyTransforms) {
            this.executeEarlyTransforms_ConstructorRelated(ctorName, classNode, accumulatedMethodDeclarations);
        }
    }

    private void executeEarlyTransforms_ConstructorRelated(char[] ctorName, ClassNode classNode, List<AbstractMethodDeclaration> accumulatedMethodDeclarations) {
        List<AnnotationNode> annos = classNode.getAnnotations();
        boolean hasImmutableAnnotation = false;
        if (annos != null) {
            for (AnnotationNode anno : annos) {
                if (anno.getClassNode() == null || !anno.getClassNode().getName().equals("Immutable")) continue;
                hasImmutableAnnotation = true;
            }
        }
        if (hasImmutableAnnotation) {
            List<FieldNode> fields = classNode.getFields();
            Argument[] arguments = new Argument[fields.size()];
            int i = 0;
            while (i < fields.size()) {
                FieldNode field = fields.get(i);
                TypeReference parameterTypeReference = this.createTypeReferenceForClassNode(field.getType());
                arguments[i] = new Argument(fields.get(i).getName().toCharArray(), GroovyCompilationUnitDeclaration.toPos(field.getStart(), field.getEnd() - 1), parameterTypeReference, 1);
                arguments[i].declarationSourceStart = fields.get(i).getStart();
                ++i;
            }
            ConstructorDeclaration constructor = new ConstructorDeclaration(this.compilationResult);
            constructor.selector = ctorName;
            constructor.modifiers = 1;
            constructor.arguments = arguments;
            accumulatedMethodDeclarations.add(constructor);
        }
    }

    private Argument[] createArguments(Parameter[] ps, boolean isMain) {
        if (ps == null || ps.length == 0) {
            return null;
        }
        Argument[] arguments = new Argument[ps.length];
        int i = 0;
        while (i < ps.length) {
            Parameter parameter = ps[i];
            TypeReference parameterTypeReference = this.createTypeReferenceForClassNode(parameter.getType());
            arguments[i] = new Argument(parameter.getName().toCharArray(), GroovyCompilationUnitDeclaration.toPos(parameter.getStart(), parameter.getEnd() - 1), parameterTypeReference, 1);
            arguments[i].declarationSourceStart = parameter.getStart();
            ++i;
        }
        if (this.isVargs(ps)) {
            arguments[ps.length - 1].type.bits |= 0x4000;
        }
        return arguments;
    }

    private void createMethodDeclarations(ClassNode classNode, boolean isEnum, List<AbstractMethodDeclaration> accumulatedDeclarations) {
        List<MethodNode> methods = classNode.getMethods();
        for (MethodNode methodNode : methods) {
            if (isEnum && methodNode.isSynthetic()) {
                String name = methodNode.getName();
                Parameter[] params = methodNode.getParameters();
                if (name.equals("values") && params.length == 0 || name.equals("valueOf") && params.length == 1 && params[0].getType().equals(ClassHelper.STRING_TYPE)) continue;
            }
            MethodDeclaration methodDeclaration = this.createMethodDeclaration(classNode, methodNode, isEnum, this.compilationResult);
            if (methodNode.hasDefaultValue()) {
                this.createMethodVariants(methodNode, methodDeclaration, accumulatedDeclarations, this.compilationResult);
                continue;
            }
            accumulatedDeclarations.add(methodDeclaration);
        }
    }

    private void createMethodVariants(MethodNode method, MethodDeclaration methodDecl, List<AbstractMethodDeclaration> accumulatedDeclarations, CompilationResult compilationResult) {
        List<Argument[]> variants = this.getVariantsAllowingForDefaulting(method.getParameters(), methodDecl.arguments);
        for (Argument[] variant : variants) {
            MethodDeclaration variantMethodDeclaration = this.genMethodDeclarationVariant(method, variant, methodDecl.returnType, compilationResult);
            this.addUnlessDuplicate(accumulatedDeclarations, variantMethodDeclaration);
        }
    }

    private List<Argument[]> getVariantsAllowingForDefaulting(Parameter[] groovyParams, Argument[] jdtArguments) {
        ArrayList<Argument[]> variants = new ArrayList<Argument[]>();
        int psCount = groovyParams.length;
        Parameter[] wipableParameters = new Parameter[psCount];
        System.arraycopy(groovyParams, 0, wipableParameters, 0, psCount);
        ArrayList<Argument> oneVariation = new ArrayList<Argument>();
        int nextToLetDefault = -1;
        do {
            oneVariation.clear();
            nextToLetDefault = -1;
            int p = 0;
            while (p < psCount) {
                if (wipableParameters[p] != null) {
                    oneVariation.add(jdtArguments[p]);
                    if (wipableParameters[p].hasInitialExpression()) {
                        nextToLetDefault = p;
                    }
                }
                ++p;
            }
            if (nextToLetDefault != -1) {
                wipableParameters[nextToLetDefault] = null;
            }
            Argument[] argumentsVariant = oneVariation.size() == 0 ? null : oneVariation.toArray(new Argument[oneVariation.size()]);
            variants.add(argumentsVariant);
        } while (nextToLetDefault != -1);
        return variants;
    }

    private void addUnlessDuplicate(List<AbstractMethodDeclaration> accumulatedDeclarations, AbstractMethodDeclaration newDeclaration) {
        boolean isDuplicate = false;
        for (AbstractMethodDeclaration aMethodDecl : accumulatedDeclarations) {
            int vmdArgsLen;
            if (!CharOperation.equals(aMethodDecl.selector, newDeclaration.selector)) continue;
            Argument[] mdArgs = aMethodDecl.arguments;
            Argument[] vmdArgs = newDeclaration.arguments;
            int mdArgsLen = mdArgs == null ? 0 : mdArgs.length;
            int n = vmdArgsLen = vmdArgs == null ? 0 : vmdArgs.length;
            if (mdArgsLen != vmdArgsLen) continue;
            boolean argsTheSame = true;
            int i = 0;
            while (i < mdArgsLen) {
                if (!CharOperation.equals(mdArgs[i].type.getTypeName(), vmdArgs[i].type.getTypeName())) {
                    argsTheSame = false;
                    break;
                }
                ++i;
            }
            if (!argsTheSame) continue;
            isDuplicate = true;
            break;
        }
        if (!isDuplicate) {
            accumulatedDeclarations.add(newDeclaration);
        }
    }

    private void createConstructorVariants(ConstructorNode constructorNode, ConstructorDeclaration constructorDecl, List<AbstractMethodDeclaration> accumulatedDeclarations, CompilationResult compilationResult, boolean isEnum) {
        List<Argument[]> variants = this.getVariantsAllowingForDefaulting(constructorNode.getParameters(), constructorDecl.arguments);
        for (Argument[] variant : variants) {
            ConstructorDeclaration constructorDeclaration = new ConstructorDeclaration(compilationResult);
            constructorDeclaration.annotations = this.transformAnnotations(constructorNode.getAnnotations());
            constructorDeclaration.modifiers = isEnum ? 2 : 1;
            constructorDeclaration.selector = constructorDecl.selector;
            constructorDeclaration.arguments = variant;
            this.fixupSourceLocationsForConstructorDeclaration(constructorDeclaration, constructorNode);
            this.addUnlessDuplicate(accumulatedDeclarations, constructorDeclaration);
        }
    }

    private MethodDeclaration createMethodDeclaration(ClassNode classNode, MethodNode methodNode, boolean isEnum, CompilationResult compilationResult) {
        Parameter p;
        if (classNode.isAnnotationDefinition()) {
            AnnotationMethodDeclaration methodDeclaration = new AnnotationMethodDeclaration(compilationResult);
            int modifiers = methodNode.getModifiers();
            methodDeclaration.annotations = this.transformAnnotations(methodNode.getAnnotations());
            methodDeclaration.modifiers = modifiers &= 0xFFFFEF7F;
            if (methodNode.hasAnnotationDefault()) {
                methodDeclaration.modifiers |= 0x20000;
            }
            methodDeclaration.selector = methodNode.getName().toCharArray();
            this.fixupSourceLocationsForMethodDeclaration(methodDeclaration, methodNode);
            ClassNode returnType = methodNode.getReturnType();
            methodDeclaration.returnType = this.createTypeReferenceForClassNode(returnType);
            return methodDeclaration;
        }
        MethodDeclaration methodDeclaration = new MethodDeclaration(compilationResult);
        GenericsType[] generics = methodNode.getGenericsTypes();
        if (generics != null && generics.length != 0) {
            methodDeclaration.typeParameters = new TypeParameter[generics.length];
            int tp = 0;
            while (tp < generics.length) {
                TypeParameter typeParameter = new TypeParameter();
                typeParameter.name = generics[tp].getName().toCharArray();
                ClassNode[] upperBounds = generics[tp].getUpperBounds();
                if (upperBounds != null) {
                    typeParameter.type = this.createTypeReferenceForClassNode(upperBounds[0]);
                    typeParameter.bounds = upperBounds.length > 1 ? new TypeReference[upperBounds.length - 1] : null;
                    int b = 1;
                    int max = upperBounds.length;
                    while (b < max) {
                        typeParameter.bounds[b - 1] = this.createTypeReferenceForClassNode(upperBounds[b]);
                        typeParameter.bounds[b - 1].bits |= 0x10;
                        ++b;
                    }
                }
                methodDeclaration.typeParameters[tp] = typeParameter;
                ++tp;
            }
        }
        boolean isMain = false;
        int modifiers = methodNode.getModifiers();
        methodDeclaration.annotations = this.transformAnnotations(methodNode.getAnnotations());
        methodDeclaration.modifiers = modifiers &= 0xFFFFEF7F;
        methodDeclaration.selector = methodNode.getName().toCharArray();
        Parameter[] params = methodNode.getParameters();
        ClassNode returnType = methodNode.getReturnType();
        if ((modifiers & 8) != 0 && params != null && params.length == 1 && methodNode.getName().equals("main") && ((p = params[0]).getType() == null || p.getType().getName().equals("java.lang.Object"))) {
            String name = p.getName();
            params = new Parameter[]{new Parameter(ClassHelper.STRING_TYPE.makeArray(), name)};
            if (returnType.getName().equals("java.lang.Object")) {
                returnType = ClassHelper.VOID_TYPE;
            }
        }
        methodDeclaration.arguments = this.createArguments(params, isMain);
        methodDeclaration.returnType = this.createTypeReferenceForClassNode(returnType);
        methodDeclaration.thrownExceptions = this.createTypeReferencesForClassNodes(methodNode.getExceptions());
        this.fixupSourceLocationsForMethodDeclaration(methodDeclaration, methodNode);
        return methodDeclaration;
    }

    private MethodDeclaration genMethodDeclarationVariant(MethodNode methodNode, Argument[] alternativeArguments, TypeReference returnType, CompilationResult compilationResult) {
        MethodDeclaration methodDeclaration = new MethodDeclaration(compilationResult);
        int modifiers = methodNode.getModifiers();
        methodDeclaration.annotations = this.transformAnnotations(methodNode.getAnnotations());
        methodDeclaration.modifiers = modifiers &= 0xFFFFEF7F;
        methodDeclaration.selector = methodNode.getName().toCharArray();
        methodDeclaration.arguments = alternativeArguments;
        methodDeclaration.returnType = returnType;
        this.fixupSourceLocationsForMethodDeclaration(methodDeclaration, methodNode);
        return methodDeclaration;
    }

    private void configureSuperInterfaces(TypeDeclaration typeDeclaration, ClassNode classNode) {
        ClassNode[] interfaces = classNode.getInterfaces();
        if (interfaces != null && interfaces.length > 0) {
            typeDeclaration.superInterfaces = new TypeReference[interfaces.length];
            int i = 0;
            while (i < interfaces.length) {
                typeDeclaration.superInterfaces[i] = this.createTypeReferenceForClassNode(interfaces[i]);
                ++i;
            }
        } else {
            typeDeclaration.superInterfaces = new TypeReference[0];
        }
    }

    private void configureSuperClass(TypeDeclaration typeDeclaration, ClassNode superclass, boolean isEnum) {
        if (isEnum && superclass.getName().equals("java.lang.Enum")) {
            typeDeclaration.superclass = null;
        } else if (superclass.getStart() != 0 || !superclass.equals(ClassHelper.OBJECT_TYPE)) {
            typeDeclaration.superclass = this.createTypeReferenceForClassNode(superclass);
        }
    }

    private long[] positionsFor(char[][] reference, long start, long end) {
        long[] result = new long[reference.length];
        if (start < end) {
            long pos = start;
            int i = 0;
            int max = result.length;
            while (i < max) {
                long s = pos;
                pos = pos + (long)reference[i].length - 1L;
                result[i] = s << 32 | pos;
                pos += 2L;
                ++i;
            }
        } else {
            long pos = start << 32 | start;
            int i = 0;
            int max = result.length;
            while (i < max) {
                result[i] = pos;
                ++i;
            }
        }
        return result;
    }

    private TypeReference createTypeReferenceForArrayNameTrailingBrackets(ClassNode node, int start, int end) {
        String name = node.getName();
        int dim = 0;
        int pos = name.length() - 2;
        ClassNode componentType = node;
        while (pos > 0 && name.charAt(pos) == '[') {
            ++dim;
            pos -= 2;
            componentType = componentType.getComponentType();
        }
        if (componentType.isPrimitive()) {
            Integer ii = charToTypeId.get(Character.valueOf(name.charAt(dim)));
            if (ii == null) {
                throw new IllegalStateException("node " + node + " reported it had a primitive component type, but it does not...");
            }
            TypeReference baseTypeReference = TypeReference.baseTypeReference(ii, dim);
            baseTypeReference.sourceStart = start;
            baseTypeReference.sourceEnd = start + componentType.getName().length();
            return baseTypeReference;
        }
        if (dim == 0) {
            throw new IllegalStateException("Array classnode with dimensions 0?? node:" + node.getName());
        }
        String arrayComponentTypename = name.substring(0, pos + 2);
        if (arrayComponentTypename.indexOf(".") == -1) {
            return this.createJDTArrayTypeReference(arrayComponentTypename, dim, start, end);
        }
        return this.createJDTArrayQualifiedTypeReference(arrayComponentTypename, dim, start, end);
    }

    private TypeReference createTypeReferenceForArrayNameLeadingBrackets(ClassNode node, int start, int end) {
        String name = node.getName();
        int dim = 0;
        ClassNode componentType = node;
        while (name.charAt(dim) == '[') {
            ++dim;
            componentType = componentType.getComponentType();
        }
        if (componentType.isPrimitive()) {
            Integer ii = charToTypeId.get(Character.valueOf(name.charAt(dim)));
            if (ii == null) {
                throw new IllegalStateException("node " + node + " reported it had a primitive component type, but it does not...");
            }
            TypeReference baseTypeReference = TypeReference.baseTypeReference(ii, dim);
            baseTypeReference.sourceStart = start;
            baseTypeReference.sourceEnd = start + componentType.getName().length();
            return baseTypeReference;
        }
        String arrayComponentTypename = name.substring(dim);
        if (arrayComponentTypename.charAt(arrayComponentTypename.length() - 1) == ';') {
            arrayComponentTypename = name.substring(dim + 1, name.length() - 1);
        }
        if (arrayComponentTypename.indexOf(".") == -1) {
            return this.createJDTArrayTypeReference(arrayComponentTypename, dim, start, end);
        }
        return this.createJDTArrayQualifiedTypeReference(arrayComponentTypename, dim, start, end);
    }

    private static long toPos(long start, long end) {
        if (start == 0L && end <= 0L) {
            return NON_EXISTENT_POSITION;
        }
        return start << 32 | end;
    }

    private TypeReference createTypeReferenceForClassNode(GenericsType genericsType) {
        if (genericsType.isWildcard()) {
            ClassNode[] bounds = genericsType.getUpperBounds();
            if (bounds != null) {
                TypeReference boundReference = this.createTypeReferenceForClassNode(bounds[0]);
                Wildcard wildcard = new Wildcard(1);
                wildcard.sourceStart = genericsType.getStart();
                wildcard.sourceEnd = boundReference.sourceEnd();
                wildcard.bound = boundReference;
                return wildcard;
            }
            if (genericsType.getLowerBound() != null) {
                TypeReference boundReference = this.createTypeReferenceForClassNode(genericsType.getLowerBound());
                Wildcard wildcard = new Wildcard(2);
                wildcard.sourceStart = genericsType.getStart();
                wildcard.sourceEnd = boundReference.sourceEnd();
                wildcard.bound = boundReference;
                return wildcard;
            }
            Wildcard w = new Wildcard(0);
            w.sourceStart = genericsType.getStart();
            w.sourceEnd = genericsType.getStart();
            return w;
        }
        if (!genericsType.getType().isGenericsPlaceHolder()) {
            TypeReference typeReference = this.createTypeReferenceForClassNode(genericsType.getType());
            return typeReference;
        }
        return null;
    }

    private TypeReference[] createTypeReferencesForClassNodes(ClassNode[] classNodes) {
        if (classNodes == null || classNodes.length == 0) {
            return null;
        }
        TypeReference[] refs = new TypeReference[classNodes.length];
        int i = 0;
        while (i < classNodes.length) {
            refs[i] = this.createTypeReferenceForClassNode(classNodes[i]);
            ++i;
        }
        return refs;
    }

    private TypeReference createTypeReferenceForClassNode(ClassNode classNode) {
        String name;
        TypeReference tr;
        GenericsType[] genericsInfo;
        int start = this.startOffset(classNode);
        int end = this.endOffset(classNode);
        ArrayList<TypeReference> typeArguments = null;
        if (classNode.isUsingGenerics() && (genericsInfo = classNode.getGenericsTypes()) != null) {
            int g = 0;
            while (g < genericsInfo.length) {
                tr = this.createTypeReferenceForClassNode(genericsInfo[g]);
                if (tr != null) {
                    if (typeArguments == null) {
                        typeArguments = new ArrayList<TypeReference>();
                    }
                    typeArguments.add(tr);
                }
                ++g;
            }
        }
        if ((name = classNode.getName()).length() == 1 && name.charAt(0) == '?') {
            return new Wildcard(0);
        }
        int arrayLoc = name.indexOf("[");
        if (arrayLoc == 0) {
            return this.createTypeReferenceForArrayNameLeadingBrackets(classNode, start, end);
        }
        if (arrayLoc > 0) {
            return this.createTypeReferenceForArrayNameTrailingBrackets(classNode, start, end);
        }
        if (nameToPrimitiveTypeId.containsKey(name)) {
            return TypeReference.baseTypeReference(nameToPrimitiveTypeId.get(name), 0);
        }
        if (name.indexOf(".") == -1) {
            if (typeArguments == null) {
                tr = this.verify(new SingleTypeReference(name.toCharArray(), GroovyCompilationUnitDeclaration.toPos(start, end - 1)));
                if (!this.checkGenerics) {
                    tr.bits |= 0x40000000;
                }
                return tr;
            }
            long l = GroovyCompilationUnitDeclaration.toPos(start, end - 1);
            return new ParameterizedSingleTypeReference(name.toCharArray(), typeArguments.toArray(new TypeReference[typeArguments.size()]), 0, l);
        }
        char[][] compoundName = CharOperation.splitOn('.', name.toCharArray());
        if (typeArguments == null) {
            QualifiedTypeReference tr2 = new QualifiedTypeReference(compoundName, this.positionsFor(compoundName, start, end));
            if (!this.checkGenerics) {
                tr2.bits |= 0x40000000;
            }
            return tr2;
        }
        TypeReference[][] typeReferences = new TypeReference[compoundName.length][];
        typeReferences[compoundName.length - 1] = typeArguments.toArray(new TypeReference[typeArguments.size()]);
        return new ParameterizedQualifiedTypeReference(compoundName, typeReferences, 0, this.positionsFor(compoundName, start, end));
    }

    private long[] getPositionsFor(char[][] compoundName) {
        long[] ls = new long[compoundName.length];
        int i = 0;
        while (i < compoundName.length) {
            ls[i] = 0L;
            ++i;
        }
        return ls;
    }

    @Override
    public void generateCode() {
        boolean successful = this.processToPhase(9);
        if (successful) {
            List classes = this.groovyCompilationUnit.getClasses();
            for (GroovyClass clazz : classes) {
                GroovyCompilationUnitScope gcuScope;
                ClassNode classnode = clazz.getClassNode();
                if (clazz.getSourceUnit() != this.groovySourceUnit) continue;
                String classname = clazz.getName();
                SourceTypeBinding binding = null;
                if (this.types != null && this.types.length != 0) {
                    binding = this.findBinding(this.types, clazz.getClassNode());
                }
                if (binding == null) {
                    ClassNode current = classnode;
                    while (current instanceof InnerClassNode && binding == null) {
                        current = ((InnerClassNode)current).getOuterClass();
                        binding = this.findBinding(this.types, current);
                    }
                }
                if (binding == null) {
                    RuntimeException rEx = new RuntimeException("Couldn't find binding for '" + classname + "': do you maybe have a duplicate type around?");
                    rEx.printStackTrace();
                    Util.log(rEx, "Couldn't find binding for '" + classname + "': do you maybe have a duplicate type around?");
                    continue;
                }
                boolean isScript = false;
                if (binding.scope != null && binding.scope.parent instanceof GroovyCompilationUnitScope && (gcuScope = (GroovyCompilationUnitScope)binding.scope.parent).isScript()) {
                    isScript = true;
                }
                if (isScript) continue;
                byte[] classbytes = clazz.getBytes();
                String path = clazz.getName().replace('.', '/');
                this.compilationResult.record(classname.toCharArray(), new GroovyClassFile(classname, classbytes, binding, path));
            }
        }
    }

    private void log(String message) {
        System.out.println(message);
    }

    private SourceTypeBinding findBinding(TypeDeclaration[] typedeclarations, ClassNode cnode) {
        TypeDeclaration[] typeDeclarationArray = typedeclarations;
        int n = typedeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            SourceTypeBinding binding;
            TypeDeclaration typedeclaration = typeDeclarationArray[n2];
            GroovyTypeDeclaration groovyTypeDeclaration = (GroovyTypeDeclaration)typedeclaration;
            if (groovyTypeDeclaration.getClassNode().equals(cnode)) {
                return groovyTypeDeclaration.binding;
            }
            if (typedeclaration.memberTypes != null && (binding = this.findBinding(typedeclaration.memberTypes, cnode)) != null) {
                return binding;
            }
            ++n2;
        }
        return null;
    }

    private int startOffset(org.codehaus.groovy.ast.ASTNode astnode) {
        return Math.max(astnode.getStart(), 0);
    }

    private int endOffset(org.codehaus.groovy.ast.ASTNode astnode) {
        return Math.max(astnode.getEnd(), 0);
    }

    private void recordProblems(List<?> errors) {
        ArrayList<Message> errorsRecorded = new ArrayList<Message>();
        Iterator<?> iterator = errors.iterator();
        while (iterator.hasNext()) {
            CSTNode context;
            SyntaxException syntaxException = null;
            Message message = (Message)iterator.next();
            StringWriter sw = new StringWriter();
            message.write(new PrintWriter(sw));
            String msg = sw.toString();
            CategorizedProblem p = null;
            int line = 0;
            int sev = 0;
            int scol = 0;
            int ecol = 0;
            if (message instanceof LocatedMessage && (context = ((LocatedMessage)message).getContext()) instanceof Token) {
                line = context.getStartLine();
                scol = context.getStartColumn();
                String text = ((Token)context).getText();
                ecol = scol + (text == null ? 1 : text.length() - 1);
            }
            if (message instanceof SimpleMessage) {
                SimpleMessage simpleMessage = (SimpleMessage)message;
                sev |= 1;
                String simpleText = simpleMessage.getMessage();
                if (simpleText.length() > 1 && simpleText.charAt(0) == '\n') {
                    simpleText = simpleText.substring(1);
                }
                if ((msg = "Groovy:" + simpleText).indexOf("\n") != -1) {
                    msg = msg.substring(0, msg.indexOf("\n"));
                }
            }
            if (message instanceof SyntaxErrorMessage) {
                SyntaxErrorMessage errorMessage = (SyntaxErrorMessage)message;
                syntaxException = errorMessage.getCause();
                sev |= 1;
                String actualMessage = syntaxException.getMessage();
                if (actualMessage.length() > 1 && actualMessage.charAt(0) == '\n') {
                    actualMessage = actualMessage.substring(1);
                }
                if ((msg = "Groovy:" + actualMessage).indexOf("\n") != -1) {
                    msg = msg.substring(0, msg.indexOf("\n"));
                }
                line = syntaxException.getLine();
                scol = errorMessage.getCause().getStartColumn();
                ecol = errorMessage.getCause().getEndColumn() - 1;
            }
            int soffset = -1;
            int eoffset = -1;
            if (message instanceof ExceptionMessage) {
                ExceptionMessage em = (ExceptionMessage)message;
                sev |= 1;
                if (em.getCause() instanceof RuntimeParserException) {
                    ModuleNode thisModuleNode;
                    ModuleNode errorModuleNode;
                    RuntimeParserException rpe = (RuntimeParserException)em.getCause();
                    sev |= 1;
                    msg = "Groovy:" + rpe.getMessage();
                    if (msg.indexOf("\n") != -1) {
                        msg = msg.substring(0, msg.indexOf("\n"));
                    }
                    if (!(errorModuleNode = rpe.getModule()).equals(thisModuleNode = this.getModuleNode())) continue;
                    soffset = rpe.getNode().getStart();
                    eoffset = rpe.getNode().getEnd() - 1;
                    line = 0;
                    while (this.compilationResult.lineSeparatorPositions[line] < soffset && line < this.compilationResult.lineSeparatorPositions.length) {
                        ++line;
                    }
                    ++line;
                }
            }
            if (syntaxException instanceof PreciseSyntaxException) {
                soffset = ((PreciseSyntaxException)syntaxException).getStartOffset();
                eoffset = ((PreciseSyntaxException)syntaxException).getEndOffset();
                line = 0;
                while (line < this.compilationResult.lineSeparatorPositions.length && this.compilationResult.lineSeparatorPositions[line] < soffset) {
                    ++line;
                }
                ++line;
            } else {
                if (soffset == -1) {
                    soffset = this.getOffset(this.compilationResult.lineSeparatorPositions, line, scol);
                }
                if (eoffset == -1) {
                    eoffset = this.getOffset(this.compilationResult.lineSeparatorPositions, line, ecol);
                }
            }
            if (soffset > eoffset) {
                eoffset = soffset;
            }
            if (soffset > this.sourceEnd) {
                soffset = this.sourceEnd;
                eoffset = this.sourceEnd;
            }
            char[] filename = this.getFileName();
            p = new DefaultProblemFactory().createProblem(filename, 0, new String[]{msg}, 0, new String[]{msg}, sev, soffset, eoffset, line, scol);
            this.problemReporter.record(p, this.compilationResult, this);
            errorsRecorded.add(message);
            System.err.println(String.valueOf(new String(this.compilationResult.getFileName())) + ": " + line + " " + msg);
        }
        errors.removeAll(errorsRecorded);
    }

    private int getOffset(int[] lineSeparatorPositions, int line, int col) {
        if (lineSeparatorPositions.length > line - 2 && line > 1) {
            return lineSeparatorPositions[line - 2] + col;
        }
        return col;
    }

    @Override
    public CompilationUnitScope buildCompilationUnitScope(LookupEnvironment lookupEnvironment) {
        GroovyCompilationUnitScope gcus = new GroovyCompilationUnitScope(this, lookupEnvironment);
        gcus.setIsScript(this.isScript);
        return gcus;
    }

    public ModuleNode getModuleNode() {
        return this.groovySourceUnit == null ? null : this.groovySourceUnit.getAST();
    }

    public SourceUnit getSourceUnit() {
        return this.groovySourceUnit;
    }

    @Override
    public CompilationUnit getSpecialDomCompilationUnit(AST ast) {
        return new GroovyCompilationUnit(ast);
    }

    private void fixupSourceLocationsForTypeDeclaration(GroovyTypeDeclaration typeDeclaration, ClassNode classNode) {
        typeDeclaration.sourceStart = Math.max(classNode.getNameStart(), classNode.getStart());
        typeDeclaration.sourceEnd = Math.max(classNode.getNameEnd(), classNode.getStart());
        int line = classNode.getLineNumber();
        Javadoc doc = this.findJavadoc(line);
        if (doc != null) {
            if (this.imports != null && this.imports.length > 0) {
                if (doc.sourceStart < this.imports[this.imports.length - 1].sourceStart) {
                    doc = null;
                }
            } else if (this.currentPackage != null && doc.sourceStart < this.currentPackage.sourceStart) {
                doc = null;
            }
        }
        typeDeclaration.javadoc = doc;
        typeDeclaration.declarationSourceStart = doc == null ? classNode.getStart() : doc.sourceStart;
        typeDeclaration.declarationSourceEnd = classNode.getEnd() - 1;
        typeDeclaration.bodyStart = Math.max(classNode.getNameEnd(), classNode.getStart());
        typeDeclaration.bodyEnd = classNode.getEnd() - 1;
        typeDeclaration.modifiersSourceStart = classNode.getStart();
    }

    private void fixupSourceLocationsForConstructorDeclaration(ConstructorDeclaration ctorDeclaration, ConstructorNode ctorNode) {
        Javadoc doc;
        ctorDeclaration.sourceStart = ctorNode.getNameStart();
        ctorDeclaration.sourceEnd = ctorNode.getNameEnd();
        int line = ctorNode.getLineNumber();
        ctorDeclaration.javadoc = doc = this.findJavadoc(line);
        ctorDeclaration.declarationSourceStart = doc == null ? ctorNode.getStart() : doc.sourceStart;
        ctorDeclaration.declarationSourceEnd = ctorNode.getEnd() - 1;
        ctorDeclaration.modifiersSourceStart = ctorNode.getStart();
        ctorDeclaration.bodyStart = ctorNode.getCode() != null ? ctorNode.getCode().getStart() : ctorNode.getNameEnd();
        ctorDeclaration.bodyEnd = ctorNode.getEnd() - 1;
    }

    private void fixupSourceLocationsForMethodDeclaration(MethodDeclaration methodDeclaration, MethodNode methodNode) {
        Javadoc doc;
        methodDeclaration.sourceStart = Math.max(methodNode.getNameStart(), methodNode.getStart());
        methodDeclaration.sourceEnd = Math.max(methodNode.getNameEnd(), methodNode.getStart());
        int line = methodNode.getLineNumber();
        methodDeclaration.javadoc = doc = this.findJavadoc(line);
        methodDeclaration.declarationSourceStart = doc == null ? methodNode.getStart() : doc.sourceStart;
        methodDeclaration.declarationSourceEnd = methodNode.getEnd() - 1;
        methodDeclaration.modifiersSourceStart = methodNode.getStart();
        methodDeclaration.bodyStart = methodNode.getCode() != null ? methodNode.getCode().getStart() : Math.max(methodNode.getNameEnd(), methodNode.getStart());
        methodDeclaration.bodyEnd = methodNode.getEnd() - 1;
    }

    private void fixupSourceLocationsForFieldDeclaration(FieldDeclaration fieldDeclaration, FieldNode fieldNode, boolean isEnumField) {
        Javadoc doc;
        fieldDeclaration.sourceStart = fieldNode.getNameStart();
        fieldDeclaration.sourceEnd = fieldNode.getNameEnd();
        int line = fieldNode.getLineNumber();
        fieldDeclaration.javadoc = doc = this.findJavadoc(line);
        if (isEnumField) {
            fieldDeclaration.declarationSourceStart = doc == null ? fieldNode.getNameStart() : doc.sourceStart;
            fieldDeclaration.declarationSourceEnd = fieldNode.getNameEnd() - 1;
        } else {
            fieldDeclaration.declarationSourceStart = doc == null ? fieldNode.getStart() : doc.sourceStart;
            fieldDeclaration.declarationSourceEnd = fieldNode.getEnd() - 1;
        }
        fieldDeclaration.modifiersSourceStart = fieldNode.getStart();
        fieldDeclaration.declarationEnd = fieldNode.getEnd();
        fieldDeclaration.endPart1Position = fieldNode.getNameStart();
        fieldDeclaration.endPart2Position = fieldNode.getEnd() - 1;
    }

    private boolean isVargs(Parameter[] parameters) {
        if (parameters.length == 0) {
            return false;
        }
        ClassNode clazz = parameters[parameters.length - 1].getType();
        return clazz.isArray();
    }

    public String print() {
        return this.toString();
    }

    public GroovyCompilationUnitScope getScope() {
        return (GroovyCompilationUnitScope)this.scope;
    }

    @Override
    public void resolve() {
        this.processToPhase(4);
        this.checkForTags();
        this.setComments();
    }

    private void checkForTags() {
        if (this.compilerOptions == null) {
            return;
        }
        List<Comment> comments = this.groovySourceUnit.getComments();
        if (comments == null) {
            return;
        }
        char[][] taskTags = this.compilerOptions.taskTags;
        char[][] taskPriorities = this.compilerOptions.taskPriorities;
        boolean caseSensitiveTags = this.compilerOptions.isTaskCaseSensitive;
        try {
            if (taskTags != null) {
                for (Comment comment : comments) {
                    ArrayList<TaskEntry> allTasksInComment = new ArrayList<TaskEntry>();
                    int t = 0;
                    while (t < taskTags.length) {
                        String taskTag = new String(taskTags[t]);
                        String taskPriority = null;
                        if (taskPriorities != null) {
                            taskPriority = new String(taskPriorities[t]);
                        }
                        allTasksInComment.addAll(comment.getPositionsOf(taskTag, taskPriority, this.compilationResult.lineSeparatorPositions, caseSensitiveTags));
                        ++t;
                    }
                    if (allTasksInComment.isEmpty()) continue;
                    int t1 = 0;
                    while (t1 < allTasksInComment.size()) {
                        int t2 = 0;
                        while (t2 < allTasksInComment.size()) {
                            if (t1 != t2) {
                                TaskEntry taskOne = (TaskEntry)allTasksInComment.get(t1);
                                TaskEntry taskTwo = (TaskEntry)allTasksInComment.get(t2);
                                if (taskOne.start + taskOne.taskTag.length() + 1 == taskTwo.start) {
                                    taskOne.isAdjacentTo = taskTwo;
                                } else if (taskOne.getEnd() > taskTwo.start && taskOne.start < taskTwo.start) {
                                    taskOne.setEnd(taskTwo.start - 1);
                                } else if (taskTwo.getEnd() > taskOne.start && taskTwo.start < taskOne.start) {
                                    taskTwo.setEnd(taskOne.start - 1);
                                }
                            }
                            ++t2;
                        }
                        ++t1;
                    }
                    for (TaskEntry taskEntry : allTasksInComment) {
                        this.problemReporter.referenceContext = this;
                        this.problemReporter.task(taskEntry.taskTag, taskEntry.getText(), taskEntry.taskPriority, taskEntry.start, taskEntry.getEnd());
                    }
                }
            }
        }
        catch (AbortCompilation comment) {
        }
        catch (Throwable t) {
            Util.log(t, "Unexpected problem processing task tags in " + this.groovySourceUnit.getName());
            new RuntimeException("Unexpected problem processing task tags in " + this.groovySourceUnit.getName(), t).printStackTrace();
        }
    }

    @Override
    public void analyseCode() {
        this.processToPhase(5);
    }

    @Override
    public void abort(int abortLevel, CategorizedProblem problem) {
        super.abort(abortLevel, problem);
    }

    @Override
    public void checkUnusedImports() {
        super.checkUnusedImports();
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
    }

    @Override
    public CompilationResult compilationResult() {
        return super.compilationResult();
    }

    @Override
    public TypeDeclaration declarationOfType(char[][] typeName) {
        return super.declarationOfType(typeName);
    }

    @Override
    public void finalizeProblems() {
        super.finalizeProblems();
    }

    @Override
    public char[] getFileName() {
        return super.getFileName();
    }

    @Override
    public char[] getMainTypeName() {
        return super.getMainTypeName();
    }

    @Override
    public boolean hasErrors() {
        return super.hasErrors();
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty();
    }

    @Override
    public boolean isPackageInfo() {
        return super.isPackageInfo();
    }

    @Override
    public StringBuffer print(int indent, StringBuffer output) {
        return super.print(indent, output);
    }

    @Override
    public void propagateInnerEmulationForAllLocalTypes() {
        super.propagateInnerEmulationForAllLocalTypes();
    }

    @Override
    public void record(LocalTypeBinding localType) {
        super.record(localType);
    }

    @Override
    public void recordStringLiteral(StringLiteral literal, boolean fromRecovery) {
        super.recordStringLiteral(literal, fromRecovery);
    }

    @Override
    public void recordSuppressWarnings(IrritantSet irritants, Annotation annotation, int scopeStart, int scopeEnd) {
        super.recordSuppressWarnings(irritants, annotation, scopeStart, scopeEnd);
    }

    @Override
    public void tagAsHavingErrors() {
        super.tagAsHavingErrors();
    }

    @Override
    public void traverse(ASTVisitor visitor, CompilationUnitScope unitScope) {
        super.traverse(visitor, unitScope);
    }

    @Override
    public ASTNode concreteStatement() {
        return super.concreteStatement();
    }

    @Override
    public boolean isImplicitThis() {
        return super.isImplicitThis();
    }

    @Override
    public boolean isSuper() {
        return super.isSuper();
    }

    @Override
    public boolean isThis() {
        return super.isThis();
    }

    @Override
    public int sourceEnd() {
        return super.sourceEnd();
    }

    @Override
    public int sourceStart() {
        return super.sourceStart();
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        super.traverse(visitor, scope);
    }

    private ArrayTypeReference createJDTArrayTypeReference(String arrayComponentTypename, int dimensions, int start, int end) {
        ArrayTypeReference atr = new ArrayTypeReference(arrayComponentTypename.toCharArray(), dimensions, GroovyCompilationUnitDeclaration.toPos(start, end - 1));
        atr.originalSourceEnd = atr.sourceStart + arrayComponentTypename.length() - 1;
        return atr;
    }

    private ArrayQualifiedTypeReference createJDTArrayQualifiedTypeReference(String arrayComponentTypename, int dimensions, int start, int end) {
        char[][] compoundName = CharOperation.splitOn('.', arrayComponentTypename.toCharArray());
        ArrayQualifiedTypeReference aqtr = new ArrayQualifiedTypeReference(compoundName, dimensions, this.positionsFor(compoundName, start, end - dimensions * 2));
        aqtr.sourceEnd = end - 1;
        return aqtr;
    }

    private TypeReference verify(TypeReference toVerify) {
        if (toVerify.getClass().equals(SingleTypeReference.class)) {
            SingleTypeReference str = (SingleTypeReference)toVerify;
            if (str.sourceStart == -1) {
                if (str.sourceEnd != -2) {
                    throw new IllegalStateException("TypeReference '" + new String(str.token) + " should end at -2");
                }
            } else if (str.sourceEnd < str.sourceStart) {
                throw new IllegalStateException("TypeReference '" + new String(str.token) + " should end at " + str.sourceStart + " or later");
            }
        } else {
            throw new IllegalStateException("Cannot verify type reference of this class " + toVerify.getClass());
        }
        return toVerify;
    }

    public void tagAsScript() {
        this.isScript = true;
    }

    static class FieldDeclarationWithInitializer
    extends FieldDeclaration {
        private Expression initializer;

        public FieldDeclarationWithInitializer(char[] name, int sourceStart, int sourceEnd) {
            super(name, sourceStart, sourceEnd);
        }

        public void setGroovyInitializer(Expression initializer) {
            this.initializer = initializer;
        }

        public Expression getGroovyInitializer() {
            return this.initializer;
        }
    }
}

