/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.jdt.groovy.internal.compiler.ast.ImmutableException;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTResolver;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class LazyGenericsType
extends GenericsType {
    private boolean initialized = false;
    private TypeVariableBinding tvBinding;
    private JDTResolver resolver;

    public LazyGenericsType(TypeVariableBinding typeVariableBinding, JDTResolver jdtResolver) {
        this.tvBinding = typeVariableBinding;
        this.resolver = jdtResolver;
        this.name = new String(typeVariableBinding.sourceName);
        this.placeholder = true;
    }

    public ClassNode getLowerBound() {
        this.ensureInitialized();
        return this.lowerBound;
    }

    public ClassNode getType() {
        this.ensureInitialized();
        return this.type;
    }

    public ClassNode[] getUpperBounds() {
        this.ensureInitialized();
        return this.upperBounds;
    }

    public boolean isResolved() {
        return true;
    }

    public boolean isWildcard() {
        return false;
    }

    public void setLowerBound(ClassNode bound) {
        throw new ImmutableException();
    }

    public void setName(String name) {
        throw new ImmutableException();
    }

    public void setPlaceholder(boolean placeholder) {
        throw new ImmutableException();
    }

    public void setResolved(boolean res) {
        throw new ImmutableException();
    }

    public void setType(ClassNode type) {
        throw new ImmutableException();
    }

    public void setUpperBounds(ClassNode[] bounds) {
        throw new ImmutableException();
    }

    public void setWildcard(boolean wildcard) {
        throw new ImmutableException();
    }

    public String toString() {
        if (!this.initialized) {
            return "LazyGenericsType instance (uninitialized) for " + this.tvBinding;
        }
        return super.toString();
    }

    private void ensureInitialized() {
        if (!this.initialized) {
            ClassNode cn = ClassHelper.makeWithoutCaching(this.name);
            cn.setGenericsPlaceHolder(true);
            ClassNode cn2 = ClassHelper.makeWithoutCaching(this.name);
            cn2.setGenericsPlaceHolder(true);
            GenericsType[] gts = new GenericsType[]{new GenericsType(cn2)};
            cn.setGenericsTypes(gts);
            cn.setRedirect(ClassHelper.OBJECT_TYPE);
            this.type = cn;
            if (this.tvBinding.firstBound == null) {
                this.type = ClassHelper.OBJECT_TYPE;
            } else {
                ClassNode firstBoundType = this.resolver.convertToClassNode(this.tvBinding.firstBound);
                TypeBinding[] otherUpperBounds = this.tvBinding.otherUpperBounds();
                if (otherUpperBounds.length == 0) {
                    this.upperBounds = new ClassNode[]{firstBoundType};
                } else {
                    ClassNode[] nodes = new ClassNode[1 + otherUpperBounds.length];
                    int idx = 0;
                    nodes[idx++] = firstBoundType;
                    TypeBinding[] typeBindingArray = otherUpperBounds;
                    int n = otherUpperBounds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TypeBinding typeBinding = typeBindingArray[n2];
                        nodes[idx++] = this.resolver.convertToClassNode(typeBinding);
                        ++n2;
                    }
                    this.upperBounds = nodes;
                }
            }
            this.lowerBound = null;
            this.initialized = true;
        }
    }
}

