/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyCompilationUnitDeclaration;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTResolver;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.util.Util;

public class ModuleNodeMapper {
    private static final ModuleNodeMapper INSTANCE = new ModuleNodeMapper();
    private final Map<JavaModelManager.PerWorkingCopyInfo, ModuleNodeInfo> infoToModuleMap = new HashMap<JavaModelManager.PerWorkingCopyInfo, ModuleNodeInfo>();
    private static final boolean DSL_BUNDLE_INSTALLED;

    static {
        boolean result = false;
        try {
            result = Platform.getBundle("org.codehaus.groovy.eclipse.dsl") != null;
        }
        catch (Exception e) {
            Util.log(e);
        }
        DSL_BUNDLE_INSTALLED = result;
    }

    static ModuleNodeMapper getInstance() {
        return INSTANCE;
    }

    synchronized void store(JavaModelManager.PerWorkingCopyInfo info, ModuleNode module, JDTResolver resolver) {
        this.sweepAndPurgeModuleNodes();
        this.infoToModuleMap.put(info, new ModuleNodeInfo(module, this.shouldStoreResovler() ? resolver : null));
    }

    private boolean shouldStoreResovler() {
        return DSL_BUNDLE_INSTALLED;
    }

    synchronized ModuleNode getModule(JavaModelManager.PerWorkingCopyInfo info) {
        ModuleNodeInfo moduleNodeInfo = this.get(info);
        return moduleNodeInfo != null ? moduleNodeInfo.module : null;
    }

    synchronized ModuleNodeInfo get(JavaModelManager.PerWorkingCopyInfo info) {
        this.sweepAndPurgeModuleNodes();
        return this.infoToModuleMap.get(info);
    }

    synchronized JDTResolver getResolver(JavaModelManager.PerWorkingCopyInfo info) {
        ModuleNodeInfo moduleNodeInfo = this.get(info);
        return moduleNodeInfo != null ? moduleNodeInfo.resolver : null;
    }

    synchronized ModuleNode remove(JavaModelManager.PerWorkingCopyInfo info) {
        this.sweepAndPurgeModuleNodes();
        ModuleNodeInfo removed = this.infoToModuleMap.remove(info);
        return removed != null ? removed.module : null;
    }

    protected synchronized void maybeCacheModuleNode(JavaModelManager.PerWorkingCopyInfo perWorkingCopyInfo, GroovyCompilationUnitDeclaration compilationUnitDeclaration) {
        ModuleNode module;
        if (perWorkingCopyInfo != null && compilationUnitDeclaration != null && (module = compilationUnitDeclaration.getModuleNode()) != null) {
            JDTResolver resolver = this.shouldStoreResovler() ? (JDTResolver)compilationUnitDeclaration.getCompilationUnit().getResolveVisitor() : null;
            ModuleNodeMapper.getInstance().store(perWorkingCopyInfo, module, resolver);
        }
    }

    public static boolean isEmpty() {
        return ModuleNodeMapper.INSTANCE.infoToModuleMap.isEmpty();
    }

    synchronized void sweepAndPurgeModuleNodes() {
        if (System.getProperty("groovy.eclipse.model.purge") == null) {
            return;
        }
        System.out.println("ModuleNodeMap.size(): " + this.infoToModuleMap.size());
        ArrayList<JavaModelManager.PerWorkingCopyInfo> toPurge = new ArrayList<JavaModelManager.PerWorkingCopyInfo>();
        for (JavaModelManager.PerWorkingCopyInfo info : this.infoToModuleMap.keySet()) {
            int useCount = (Integer)ReflectionUtils.getPrivateField(JavaModelManager.PerWorkingCopyInfo.class, "useCount", info);
            if (useCount <= 0) {
                String message = "Bad module node map entry: " + info.getWorkingCopy().getElementName();
                System.out.println(message);
                Util.log(new RuntimeException(message), message);
                toPurge.add(info);
                continue;
            }
            if (useCount <= 1) continue;
            System.out.println(String.valueOf(info.getWorkingCopy().getElementName()) + " : useCount : " + useCount);
        }
        if (toPurge.size() > 0) {
            System.out.println("ModuleNodeMap: Purging old working copies.");
            for (JavaModelManager.PerWorkingCopyInfo info : toPurge) {
                this.infoToModuleMap.remove(info);
            }
        }
    }

    public class ModuleNodeInfo {
        public final ModuleNode module;
        public final JDTResolver resolver;

        public ModuleNodeInfo(ModuleNode module, JDTResolver resolver) {
            this.module = module;
            this.resolver = resolver;
        }
    }
}

