/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compiler;

import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.PackColor;
import com.izforge.izpack.api.data.PackInfo;
import com.izforge.izpack.api.data.binding.OsModel;
import com.izforge.izpack.api.data.binding.Stage;
import com.izforge.izpack.api.event.InstallerListener;
import com.izforge.izpack.api.event.UninstallerListener;
import com.izforge.izpack.api.exception.CompilerException;
import com.izforge.izpack.compiler.helper.CompilerHelper;
import com.izforge.izpack.compiler.packager.IPackager;
import com.izforge.izpack.compiler.util.CompilerClassLoader;
import com.izforge.izpack.data.CustomData;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Compiler
extends Thread {
    private IPackager packager;
    private boolean compileFailed = true;
    private boolean javaVersionCorrect = true;
    private int expectedJavaVersion;
    private final CompilerHelper compilerHelper;
    private final CompilerClassLoader loader;
    private static final Logger logger = Logger.getLogger(Compiler.class.getName());

    public Compiler(CompilerClassLoader loader, CompilerHelper compilerHelper) {
        this.loader = loader;
        this.compilerHelper = compilerHelper;
    }

    public void setPackager(IPackager packager) {
        this.packager = packager;
    }

    @Override
    public void run() {
        try {
            this.createInstaller();
        }
        catch (CompilerException ce) {
            logger.severe(ce.getMessage());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void createInstaller() throws Exception {
        this.packager.createInstaller();
        this.compileFailed = false;
    }

    public boolean wasSuccessful() {
        return !this.compileFailed;
    }

    public void checkDependencies() throws CompilerException {
        this.checkDependencies(this.packager.getPacksList());
    }

    public void checkExcludes() throws CompilerException {
        this.checkExcludes(this.packager.getPacksList());
    }

    public void checkExcludes(List<PackInfo> packs) throws CompilerException {
        for (int q = 0; q < packs.size(); ++q) {
            PackInfo packinfo1 = packs.get(q);
            Pack pack1 = packinfo1.getPack();
            for (int w = 0; w < q; ++w) {
                PackInfo packinfo2 = packs.get(w);
                Pack pack2 = packinfo2.getPack();
                if (pack1.getExcludeGroup() == null || pack2.getExcludeGroup() == null || !pack1.getExcludeGroup().equals(pack2.getExcludeGroup()) || !pack1.isPreselected() || !pack2.isPreselected()) continue;
                this.error("Packs " + pack1.getName() + " and " + pack2.getName() + " belong to the same excludeGroup " + pack1.getExcludeGroup() + " and are both preselected. This is not allowed.");
            }
        }
    }

    public void checkDependencies(List<PackInfo> packs) throws CompilerException {
        HashMap<String, PackInfo> names = new HashMap<String, PackInfo>();
        for (PackInfo pack : packs) {
            names.put(pack.getPack().getName(), pack);
        }
        int result = this.dfs(packs, names);
        if (result == -2) {
            this.error("Circular dependency detected");
        } else if (result == -1) {
            this.error("A dependency doesn't exist");
        }
    }

    private int dfs(List<PackInfo> packs, Map<String, PackInfo> names) {
        HashMap<Edge, PackColor> edges = new HashMap<Edge, PackColor>();
        for (PackInfo pack : packs) {
            if (pack.colour != PackColor.WHITE || this.dfsVisit(pack, names, edges) == 0) continue;
            return -1;
        }
        return this.checkBackEdges(edges);
    }

    private int checkBackEdges(Map<Edge, PackColor> edges) {
        Set<Edge> keys = edges.keySet();
        for (Edge key : keys) {
            PackColor color = edges.get(key);
            if (color != PackColor.GREY) continue;
            return -2;
        }
        return 0;
    }

    private int dfsVisit(PackInfo u, Map<String, PackInfo> names, Map<Edge, PackColor> edges) {
        u.colour = PackColor.GREY;
        List deps = u.getDependencies();
        if (deps != null) {
            for (String name : deps) {
                int result;
                PackInfo v = names.get(name);
                if (v == null) {
                    System.out.println("Failed to find dependency: " + name);
                    return -1;
                }
                Edge edge = new Edge(u, v);
                if (edges.get(edge) == null) {
                    edges.put(edge, v.colour);
                }
                if (v.colour != PackColor.WHITE || (result = this.dfsVisit(v, names, edges)) == 0) continue;
                return result;
            }
        }
        u.colour = PackColor.BLACK;
        return 0;
    }

    private void error(String message) throws CompilerException {
        this.compileFailed = true;
        throw new CompilerException(message);
    }

    public void addJar(URL url, boolean uninstaller) throws IOException {
        this.loader.addURL(url);
        List<String> paths = this.compilerHelper.getContainedFilePaths(url);
        if (uninstaller) {
            CustomData data = new CustomData(null, paths, null, 3);
            this.packager.addCustomJar(data, url);
        } else {
            this.packager.addJarContent(url);
        }
    }

    public void checkJarVersions(File file, String minimalJavaVersion) throws FileNotFoundException, IOException {
        FileInputStream fis = new FileInputStream(file);
        this.extractJarInternals(file.toString(), fis, minimalJavaVersion);
    }

    private void extractJarInternals(String fileStr, InputStream is, String minimalJavaVersion) throws IOException {
        ZipEntry ze;
        ZipInputStream zis = new ZipInputStream(is);
        this.setJavaVersionCorrect(true);
        while ((ze = zis.getNextEntry()) != null) {
            if (ze.getName().endsWith(".class")) {
                this.checkClassTargetVersion(fileStr + ":" + ze.getName(), zis, minimalJavaVersion);
                continue;
            }
            if (!ze.getName().endsWith(".jar")) continue;
            this.extractJarInternals(fileStr + ":" + ze.getName(), zis, minimalJavaVersion);
        }
    }

    private void checkClassTargetVersion(String fileStr, ZipInputStream zis, String minimalJavaVersion) throws IOException {
        DataInputStream dis = new DataInputStream(zis);
        if (dis.readInt() != -889275714) {
            throw new CompilerException("Class file cannot be read: " + fileStr);
        }
        dis.readUnsignedShort();
        int major = dis.readUnsignedShort();
        this.setJavaVersionExpected(major);
        String[] splitMinimalVersion = minimalJavaVersion.split("\\.");
        int minimalVersion = Integer.parseInt(splitMinimalVersion[0]);
        if (minimalVersion < 10 && splitMinimalVersion.length > 1) {
            minimalVersion = Integer.parseInt(splitMinimalVersion[1]);
        }
        if (major > 44 + minimalVersion) {
            this.setJavaVersionCorrect(false);
        }
    }

    public void addListener(String className, Stage stage, List<OsModel> constraints) {
        int type = stage == Stage.install ? 0 : 1;
        Class<Object> clazz = stage == Stage.install ? this.loader.loadClass(className, InstallerListener.class) : this.loader.loadClass(className, UninstallerListener.class);
        CustomData data = new CustomData(clazz.getName(), null, constraints, type);
        this.packager.addCustomJar(data, null);
    }

    public void setJavaVersionCorrect(boolean javaVersionCorrect) {
        this.javaVersionCorrect = javaVersionCorrect;
    }

    public boolean getJavaVersionCorrect() {
        return this.javaVersionCorrect;
    }

    public void setJavaVersionExpected(int major) {
        this.expectedJavaVersion = major - 44;
    }

    public int getJavaVersionExpected() {
        return this.expectedJavaVersion;
    }

    private class Edge {
        PackInfo u;
        PackInfo v;

        Edge(PackInfo u, PackInfo v) {
            this.u = u;
            this.v = v;
        }
    }
}

