/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compiler.cli;

import com.izforge.izpack.api.data.PackCompression;
import com.izforge.izpack.compiler.data.CompilerData;
import com.izforge.izpack.compiler.exception.HelpRequestedException;
import com.izforge.izpack.compiler.exception.NoArgumentException;
import java.io.PrintStream;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class CliAnalyzer {
    private static final String ARG_IZPACK_HOME = "h";
    private static final String ARG_BASEDIR = "b";
    private static final String ARG_KIND = "k";
    private static final String ARG_OUTPUT = "o";
    private static final String ARG_COMPRESSION_FORMAT = "c";
    private static final String ARG_COMPRESSION_LEVEL = "l";

    private Options getOptions() {
        Options options = new Options();
        options.addOption("?", false, "Print help");
        options.addOption(ARG_IZPACK_HOME, true, "IzPack home : the root path of IzPack. This will be needed if the compiler is not called in the root directory of IzPack.Do not forget quotations if there are blanks in the path.");
        options.addOption(ARG_BASEDIR, true, "base : indicates the base path that the compiler will use for filenames. of sources. Default is the current path. Attend to -h.");
        options.addOption(ARG_KIND, true, "kind : indicates the kind of installer to generate, default is standard");
        options.addOption(ARG_OUTPUT, true, "out  : indicates the output file name default is the xml file name\n");
        options.addOption(ARG_COMPRESSION_FORMAT, true, "compression : indicates the compression format to be used for packs default is the internal deflate compression\n");
        options.addOption(ARG_COMPRESSION_LEVEL, true, "compression-level : indicates the level for the used compression format if supported. Only integer are valid\n");
        return options;
    }

    public CompilerData printAndParseArgs(String[] args) throws ParseException {
        PrintStream printStream = System.out;
        this.printHeader(printStream);
        CompilerData result = this.parseArgs(args);
        this.printTail(printStream, result);
        return result;
    }

    private void printHeader(PrintStream out) {
        out.println();
        out.format(".::  IzPack - Version %s-%s ::.%n", CompilerData.IZPACK_VERSION, CompilerData.IZPACK_BUILD);
        out.println();
        out.format("< compiler specifications version: %s >%n", "5.0");
        out.println();
        out.format("- Copyright (c) %s Julien Ponge and others. All Rights Reserved.%n", CompilerData.IZPACK_COPYYEARS);
        out.println("- Visit http://izpack.org/ for the latest releases");
        out.println("- Released under the terms of the Apache Software License version 2.0.");
        out.println();
    }

    private void printTail(PrintStream out, CompilerData result) {
        out.format("-> Processing   : %s%n", result.getInstallFile());
        out.format("-> Output       : %s%n", result.getOutput());
        out.format("-> Base path    : %s%n", result.getBasedir());
        out.format("-> Kind         : %s%n", result.getKind());
        out.format("-> Compression  : %s%n", result.getComprFormat());
        out.format("-> Compr. level : %s%n", result.getComprLevel());
        out.format("-> IzPack home  : %s%n", CompilerData.IZPACK_HOME);
        out.println();
    }

    public CompilerData parseArgs(String[] args) throws ParseException {
        PosixParser parser = new PosixParser();
        CommandLine commandLine = parser.parse(this.getOptions(), args);
        return this.analyzeCommandLine(commandLine);
    }

    private void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        String cmdLineUsage = "IzPack -> Command line parameters are : (xml file) [args]";
        String header = "(xml file): the xml file describing the installation";
        String footer = "When using vm option -DSTACKTRACE=true there is all kind of debug info ";
        formatter.printHelp(cmdLineUsage, header, this.getOptions(), footer);
    }

    private CompilerData analyzeCommandLine(CommandLine commandLine) {
        this.validateCommandLine(commandLine);
        String baseDir = ".";
        String output = "install.jar";
        String compression = PackCompression.DEFAULT.toName();
        if (commandLine.hasOption("?")) {
            this.printHelp();
            throw new HelpRequestedException();
        }
        List argList = commandLine.getArgList();
        String installFile = (String)argList.get(0);
        if (commandLine.hasOption(ARG_BASEDIR)) {
            baseDir = commandLine.getOptionValue(ARG_BASEDIR).trim();
        }
        if (commandLine.hasOption(ARG_OUTPUT)) {
            output = commandLine.getOptionValue(ARG_OUTPUT).trim();
        }
        if (commandLine.hasOption(ARG_COMPRESSION_FORMAT)) {
            compression = commandLine.getOptionValue(ARG_COMPRESSION_FORMAT).trim();
        }
        CompilerData compilerData = new CompilerData(compression, installFile, baseDir, output, false);
        if (commandLine.hasOption(ARG_COMPRESSION_LEVEL)) {
            compilerData.setComprLevel(Integer.parseInt(commandLine.getOptionValue(ARG_COMPRESSION_LEVEL).trim()));
        }
        if (commandLine.hasOption(ARG_IZPACK_HOME)) {
            CompilerData.setIzpackHome(commandLine.getOptionValue(ARG_IZPACK_HOME).trim());
        }
        if (commandLine.hasOption(ARG_KIND)) {
            compilerData.setKind(commandLine.getOptionValue(ARG_KIND).trim());
        }
        return compilerData;
    }

    private void validateCommandLine(CommandLine commandLine) {
        if (commandLine.getArgList().size() == 0) {
            this.printHelp();
            throw new NoArgumentException();
        }
    }
}

