/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compiler.container.provider;

import com.izforge.izpack.compiler.data.CompilerData;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.jar.JarOutputStream;
import org.picocontainer.injectors.Provider;

public class JarOutputStreamProvider
implements Provider {
    public JarOutputStream provide(CompilerData compilerData) {
        try {
            Path file = Paths.get(compilerData.getOutput(), new String[0]);
            if (compilerData.isMkdirs()) {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
            }
            JarOutputStream jarOutputStream = new JarOutputStream(new BufferedOutputStream(Files.newOutputStream(file, new OpenOption[0])));
            int level = compilerData.getComprLevel();
            if (level >= 0 && level < 10) {
                jarOutputStream.setLevel(level);
            } else {
                jarOutputStream.setLevel(9);
            }
            return jarOutputStream;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

