/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compiler.data;

import com.izforge.izpack.api.data.Info;
import java.util.ResourceBundle;

public class CompilerData {
    public static String IZPACK_HOME = ".";
    public static final String VERSION = "5.0";
    public static final String STANDARD = "standard";
    public static final String WEB = "web";
    private String packCompression = null;
    private String kind = "standard";
    private String installFile;
    private String installText;
    private String basedir;
    private String output;
    private boolean mkdirs = false;
    private int comprLevel = -1;
    private Info externalInfo = new Info();
    private static final String VERSION_BUNDLE = "version";
    public static final String IZPACK_VERSION = ResourceBundle.getBundle("version").getString("izpack.version");
    public static final String IZPACK_BUILD = ResourceBundle.getBundle("version").getString("izpack.build");
    public static final String IZPACK_COPYYEARS = ResourceBundle.getBundle("version").getString("izpack.copyyears");

    private CompilerData() {
        String izHome = System.getProperty("izpack.home");
        if (izHome != null) {
            IZPACK_HOME = izHome;
        } else {
            izHome = System.getenv("IZPACK_HOME");
            if (izHome != null) {
                IZPACK_HOME = izHome;
            }
        }
    }

    public CompilerData(String packCompression, String installFile, String basedir, String output, boolean mkdirs) {
        this();
        this.packCompression = packCompression;
        this.installFile = installFile;
        this.basedir = basedir;
        this.output = output;
        this.mkdirs = mkdirs;
    }

    public CompilerData(String installFile, String basedir, String output, boolean mkdirs) {
        this(null, installFile, basedir, output, mkdirs);
    }

    public CompilerData(String packCompression, String kind, String installFile, String installText, String basedir, String output, boolean mkdirs, int comprLevel) {
        this(packCompression, installFile, basedir, output, mkdirs);
        this.kind = kind;
        this.installText = installText;
        this.comprLevel = comprLevel;
    }

    public CompilerData(String packCompression, String kind, String installFile, String installText, String basedir, String output, boolean mkdirs, int comprLevel, Info externalInfo) {
        this(packCompression, kind, installFile, installText, basedir, output, mkdirs, comprLevel);
        this.externalInfo = externalInfo;
    }

    public static void setIzpackHome(String izHome) {
        IZPACK_HOME = izHome;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public String getInstallFile() {
        return this.installFile;
    }

    public String getInstallText() {
        return this.installText;
    }

    public String getBasedir() {
        return this.basedir;
    }

    public void setBasedir(String basedir) {
        this.basedir = basedir;
    }

    public String getOutput() {
        return this.output;
    }

    public boolean isMkdirs() {
        return this.mkdirs;
    }

    public void setMkdirs(boolean mkdirs) {
        this.mkdirs = mkdirs;
    }

    public String getComprFormat() {
        return this.packCompression;
    }

    public void setComprFormat(String packCompression) {
        this.packCompression = packCompression;
    }

    public int getComprLevel() {
        return this.comprLevel;
    }

    public void setComprLevel(int comprLevel) {
        this.comprLevel = comprLevel;
    }

    public Info getExternalInfo() {
        return this.externalInfo;
    }
}

