/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compiler.data;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.exception.CompilerException;
import com.izforge.izpack.api.substitutor.SubstitutionType;
import com.izforge.izpack.compiler.data.CompilerData;
import com.izforge.izpack.compiler.helper.AssertionHelper;
import com.izforge.izpack.compiler.listener.PackagerListener;
import com.izforge.izpack.core.substitutor.VariableSubstitutorReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;

public class PropertyManager {
    private final Properties properties;
    private final Variables variables;
    private final PackagerListener packagerListener;
    private final AssertionHelper assertionHelper;
    private final String basedir;

    public PropertyManager(Properties properties, Variables variables, CompilerData compilerData, PackagerListener packagerListener, AssertionHelper assertionHelper) {
        this.assertionHelper = assertionHelper;
        this.properties = properties;
        this.variables = variables;
        this.packagerListener = packagerListener;
        this.basedir = compilerData.getBasedir();
        this.setProperty("izpack.version", CompilerData.IZPACK_VERSION);
        this.setProperty("basedir", this.basedir);
    }

    public boolean addProperty(String name, String value) {
        if (this.properties.containsKey(name)) {
            return false;
        }
        this.addPropertySubstitute(name, value);
        return true;
    }

    public boolean setProperty(String name, String value) {
        if (System.getProperties().containsKey(name)) {
            return false;
        }
        this.addPropertySubstitute(name, value);
        return true;
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public void execute(IXMLElement propertyNode) throws CompilerException {
        String prefix;
        String name = propertyNode.getAttribute("name");
        String value = propertyNode.getAttribute("value");
        String environment = propertyNode.getAttribute("environment");
        if (environment != null && !environment.endsWith(".")) {
            environment = environment + ".";
        }
        if ((prefix = propertyNode.getAttribute("prefix")) != null && !prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        String fileName = propertyNode.getAttribute("file");
        if (name != null) {
            if (value == null) {
                this.assertionHelper.parseError(propertyNode, "You must specify a value with the name attribute");
            }
        } else if (fileName == null && environment == null) {
            this.assertionHelper.parseError(propertyNode, "You must specify file, or environment when not using the name attribute");
        }
        if (fileName == null && prefix != null) {
            this.assertionHelper.parseError(propertyNode, "Prefix is only valid when loading from a file ");
        }
        if (name != null && value != null) {
            this.addProperty(name, value);
        } else if (environment != null) {
            try {
                this.loadEnvironment(environment);
            }
            catch (IOException e) {
                this.assertionHelper.parseError(propertyNode, "Failed loading properties from environment variables", e);
            }
        } else if (fileName != null) {
            String expandedFileName = this.variables.replace(fileName);
            try {
                this.loadFile(expandedFileName, prefix);
            }
            catch (IOException e) {
                this.packagerListener.packagerMsg("Unable to load property file: " + expandedFileName, 3);
                this.assertionHelper.parseError(propertyNode, "Failed loading properties from file " + expandedFileName, e);
            }
        }
    }

    private void loadFile(String fileName, String prefix) throws IOException {
        File file = new File(fileName);
        if (!file.isAbsolute()) {
            file = new File(this.basedir, fileName);
        }
        this.packagerListener.packagerMsg("Loading " + file, 3);
        Properties props = new Properties();
        try (FileInputStream fis = new FileInputStream(file);){
            props.load(fis);
        }
        this.addProperties(props, prefix);
    }

    private void loadEnvironment(String prefix) throws IOException {
        this.packagerListener.packagerMsg("Loading Environment " + prefix, 3);
        Properties props = new Properties();
        Map<String, String> envVarMap = System.getenv();
        for (String key : envVarMap.keySet()) {
            props.put(prefix + key, envVarMap.get(key));
        }
        this.addProperties(props, prefix);
    }

    private void addProperties(Properties props, String prefix) throws IOException {
        this.resolveAllProperties(props);
        for (String name : props.stringPropertyNames()) {
            String value = props.getProperty(name);
            if (prefix != null) {
                name = prefix + name;
            }
            this.addPropertySubstitute(name, value);
        }
    }

    private void addPropertySubstitute(String name, String value) {
        try {
            this.properties.put(name, IOUtils.toString((Reader)new VariableSubstitutorReader((Reader)new StringReader(value), this.variables, SubstitutionType.TYPE_AT)));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void resolveAllProperties(Properties props) throws IOException {
        for (String name : props.stringPropertyNames()) {
            String value = props.getProperty(name);
            props.put(name, IOUtils.toString((Reader)new VariableSubstitutorReader((Reader)new StringReader(value), this.variables, SubstitutionType.TYPE_AT, true)));
        }
    }
}

