/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compiler.packager.impl;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.PackFile;
import com.izforge.izpack.api.data.PackInfo;
import com.izforge.izpack.api.data.XPackFile;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.compiler.data.CompilerData;
import com.izforge.izpack.compiler.listener.PackagerListener;
import com.izforge.izpack.compiler.merge.CompilerPathResolver;
import com.izforge.izpack.compiler.packager.impl.PackagerBase;
import com.izforge.izpack.core.io.FileSpanningOutputStream;
import com.izforge.izpack.merge.MergeManager;
import com.izforge.izpack.merge.resolve.MergeableResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class MultiVolumePackager
extends PackagerBase {
    private long maxFirstVolumeSize = 650000000L;
    private long maxVolumeSize = 650000000L;
    private static final String VOLUME_SIZE = "volumesize";
    private static final String FIRST_VOLUME_FREE_SPACE = "firstvolumefreespace";
    private static final Logger logger = Logger.getLogger(MultiVolumePackager.class.getName());

    public MultiVolumePackager(Properties properties, PackagerListener listener, JarOutputStream installerJar, MergeManager mergeManager, CompilerPathResolver pathResolver, MergeableResolver mergeableResolver, CompilerData compilerData, RulesEngine rulesEngine) {
        super(properties, listener, installerJar, mergeManager, pathResolver, mergeableResolver, compilerData, rulesEngine);
    }

    public void setMaxFirstVolumeSize(long size) {
        this.maxFirstVolumeSize = size;
    }

    public void setMaxVolumeSize(long size) {
        this.maxVolumeSize = size;
    }

    @Override
    public void addConfigurationInformation(IXMLElement data) {
        if (data != null) {
            long freeSpace = Long.valueOf(data.getAttribute(FIRST_VOLUME_FREE_SPACE, "0"));
            long size = Long.valueOf(data.getAttribute(VOLUME_SIZE, Long.toString(this.maxVolumeSize)));
            this.setMaxFirstVolumeSize(size - freeSpace);
            this.setMaxVolumeSize(size);
        }
    }

    @Override
    protected void writePacks(JarOutputStream installerJar) throws IOException {
        String classname = this.getClass().getSimpleName();
        this.getVariables().setProperty(classname + "." + FIRST_VOLUME_FREE_SPACE, Long.toString(this.maxFirstVolumeSize));
        this.getVariables().setProperty(classname + "." + VOLUME_SIZE, Long.toString(this.maxVolumeSize));
        List<PackInfo> packs = this.getPacksList();
        int count = packs.size();
        this.sendMsg("Writing " + count + " Pack" + (count > 1 ? "s" : "") + " into installer");
        logger.fine("Writing " + count + " Pack" + (count > 1 ? "s" : "") + " into installer");
        logger.fine("First volume size: " + this.maxFirstVolumeSize);
        logger.fine("Subsequent volume size: " + this.maxVolumeSize);
        File volume = new File(this.getInfo().getInstallerBase() + ".pak").getAbsoluteFile();
        int volumes = this.writePacks(installerJar, packs, volume);
        logger.fine("Written " + volumes + " volumes");
        installerJar.putNextEntry(new ZipEntry("resources/volumes.info"));
        ObjectOutputStream out = new ObjectOutputStream(installerJar);
        out.writeInt(volumes);
        out.writeUTF(volume.getName());
        out.flush();
        installerJar.closeEntry();
        installerJar.putNextEntry(new ZipEntry("resources/packs.info"));
        out = new ObjectOutputStream(installerJar);
        out.writeObject(packs);
        out.flush();
        installerJar.closeEntry();
    }

    private int writePacks(JarOutputStream installerJar, List<PackInfo> packs, File volume) throws IOException {
        FileSpanningOutputStream volumes = new FileSpanningOutputStream(volume, this.maxFirstVolumeSize, this.maxVolumeSize);
        File targetDir = volume.getParentFile();
        if (targetDir == null) {
            throw new IOException("Cannot determine parent directory of " + volume);
        }
        for (PackInfo packInfo : packs) {
            this.writePack(installerJar, packInfo, volumes, targetDir);
        }
        volumes.flush();
        volumes.close();
        return volumes.getVolumes();
    }

    private void writePack(JarOutputStream installerJar, PackInfo packInfo, FileSpanningOutputStream volumes, File targetDir) throws IOException {
        Pack pack = packInfo.getPack();
        pack.setFileSize(0L);
        String name = pack.getName();
        this.sendMsg("Writing Pack: " + name, 3);
        logger.fine("Writing Pack: " + name);
        ZipEntry entry = new ZipEntry("resources/packs/pack-" + name);
        installerJar.putNextEntry(entry);
        ObjectOutputStream packStream = new ObjectOutputStream(installerJar);
        this.writePackFiles(packInfo, volumes, pack, packStream, targetDir);
        packStream.flush();
    }

    private void writePackFiles(PackInfo packInfo, FileSpanningOutputStream volumes, Pack pack, ObjectOutputStream packStream, File targetDir) throws IOException {
        Set files = packInfo.getPackFiles();
        LinkedHashMap<XPackFile, File> xFiles = new LinkedHashMap<XPackFile, File>();
        for (PackFile packfile : files) {
            XPackFile pf = new XPackFile(packfile);
            File file = packInfo.getFile(packfile);
            logger.fine("Next file: " + file.getAbsolutePath());
            if (!pf.isDirectory()) {
                if (!pack.isLoose()) {
                    this.writePackFile(file, volumes, pf);
                } else {
                    FileUtils.copyFile((File)file, (File)new File(targetDir, pf.getRelativeSourcePath()));
                }
            }
            xFiles.put(pf, file);
            pack.addFileSize(pf.length());
        }
        Map packFilesMap = packInfo.getPackFilesMap();
        packFilesMap.clear();
        packFilesMap.putAll(xFiles);
        if (pack.getFileSize() > pack.getSize()) {
            pack.setSize(pack.getFileSize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePackFile(File file, FileSpanningOutputStream volumes, XPackFile packFile) throws IOException {
        long beforePosition = volumes.getFilePointer();
        packFile.setArchiveFilePosition(beforePosition);
        int volumeCount = volumes.getVolumes();
        FileInputStream in = FileUtils.openInputStream((File)file);
        try {
            long bytesWritten = IOUtils.copyLarge((InputStream)in, (OutputStream)volumes);
            long afterPosition = volumes.getFilePointer();
            logger.fine("File (" + packFile.getFile() + ") " + beforePosition + " <-> " + afterPosition);
            if (volumes.getFilePointer() != beforePosition + bytesWritten) {
                logger.fine("file: " + file.getName());
                logger.fine("(Filepos/BytesWritten/ExpectedNewFilePos/NewFilePointer) (" + beforePosition + "/" + bytesWritten + "/" + (beforePosition + bytesWritten) + "/" + volumes.getFilePointer() + ")");
                logger.fine("Volumes (before/after) (" + volumeCount + "/" + volumes.getVolumes() + ")");
                throw new IOException("Error new file pointer is illegal");
            }
            if (bytesWritten != packFile.length()) {
                throw new IOException("File size mismatch when reading " + file);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }
}

