/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compiler.packager.impl;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.PackCompression;
import com.izforge.izpack.api.data.PackFile;
import com.izforge.izpack.api.data.PackInfo;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.compiler.data.CompilerData;
import com.izforge.izpack.compiler.listener.PackagerListener;
import com.izforge.izpack.compiler.merge.CompilerPathResolver;
import com.izforge.izpack.compiler.packager.impl.PackagerBase;
import com.izforge.izpack.merge.MergeManager;
import com.izforge.izpack.merge.resolve.MergeableResolver;
import com.izforge.izpack.util.NoCloseOutputStream;
import com.izforge.izpack.util.StreamSupport;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.apache.commons.io.output.CountingOutputStream;

public class Packager
extends PackagerBase {
    private static final Logger logger = Logger.getLogger(Packager.class.getName());
    private final CompilerData compilerData;

    public Packager(Properties properties, PackagerListener listener, JarOutputStream jarOutputStream, MergeManager mergeManager, CompilerPathResolver pathResolver, MergeableResolver mergeableResolver, CompilerData compilerData, RulesEngine rulesEngine) {
        super(properties, listener, jarOutputStream, mergeManager, pathResolver, mergeableResolver, compilerData, rulesEngine);
        this.compilerData = compilerData;
    }

    private JarOutputStream getJarOutputStream(Path jarFile) throws IOException {
        Files.deleteIfExists(jarFile);
        if (this.compilerData.isMkdirs()) {
            Files.createDirectories(jarFile.getParent(), new FileAttribute[0]);
        }
        JarOutputStream jarOutputStream = new JarOutputStream(new BufferedOutputStream(Files.newOutputStream(jarFile, new OpenOption[0])));
        int level = this.compilerData.getComprLevel();
        if (level >= 0 && level < 10) {
            jarOutputStream.setLevel(level);
        } else {
            jarOutputStream.setLevel(9);
        }
        return jarOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writePacks(JarOutputStream installerJar) throws IOException {
        List<PackInfo> packs = this.getPacksList();
        int num = packs.size();
        this.sendMsg("Writing " + num + " Pack" + (num > 1 ? "s" : "") + " into installer");
        HashMap<Path, PackFile> storedFiles = new HashMap<Path, PackFile>();
        ArrayList<PackFile> pack200Files = new ArrayList<PackFile>();
        int packNumber = 0;
        XMLElementImpl root = new XMLElementImpl("packs");
        for (PackInfo packInfo : packs) {
            ZipEntry entry;
            JarOutputStream packJar;
            Pack pack = packInfo.getPack();
            pack.setFileSize(0L);
            this.sendMsg("Writing Pack " + packNumber + ": " + pack.getName(), 3);
            String streamResourceName = "packs/pack-" + pack.getName();
            if (this.packSeparateJars()) {
                Path jarFile = Paths.get(this.getInfo().getInstallerBase() + ".pack-" + pack.getName() + ".jar", new String[0]);
                packJar = this.getJarOutputStream(jarFile);
                entry = new ZipEntry(streamResourceName);
            } else {
                packJar = installerJar;
                entry = new ZipEntry("resources/" + streamResourceName);
            }
            packJar.putNextEntry(entry);
            packJar.flush();
            try (CountingOutputStream packOutputStream = new CountingOutputStream((OutputStream)new NoCloseOutputStream((OutputStream)packJar));){
                for (PackFile packFile : packInfo.getPackFiles()) {
                    boolean addFile = !pack.isLoose();
                    Path file = packInfo.getFile(packFile).toPath();
                    boolean pack200 = packFile.isPack200Jar();
                    PackFile linkedPackFile = (PackFile)storedFiles.get(file);
                    if (linkedPackFile != null && !this.packSeparateJars()) {
                        logger.fine("File " + packFile.getTargetPath() + " is a backreference, linked to " + linkedPackFile.getTargetPath());
                        packFile.setLinkedPackFile(linkedPackFile);
                        addFile = false;
                    }
                    if (addFile && !packFile.isDirectory()) {
                        if (pack200) {
                            packFile.setStreamResourceName("packs/pack200-" + packFile.getId());
                            packFile.setStreamOffset(0L);
                            pack200Files.add(packFile);
                        } else {
                            packFile.setStreamResourceName(streamResourceName);
                            packFile.setStreamOffset(packOutputStream.getByteCount());
                            PackCompression comprFormat = this.getInfo().getCompressionFormat();
                            CountingOutputStream proxyOutputStream = new CountingOutputStream((OutputStream)new NoCloseOutputStream((OutputStream)packOutputStream));
                            try (OutputStream finalStream = StreamSupport.compressedOutput((PackCompression)comprFormat, (OutputStream)proxyOutputStream);){
                                long bytesWritten = Files.copy(file, finalStream);
                                if (bytesWritten != packFile.length()) {
                                    throw new IOException("File size mismatch when reading " + file);
                                }
                            }
                            packFile.setSize(proxyOutputStream.getByteCount());
                            logger.fine("File " + packFile.getTargetPath() + " added compressed as " + comprFormat.toName() + " (" + packFile.length() + " -> " + packFile.size() + " bytes)");
                        }
                        storedFiles.put(file, packFile);
                    }
                    pack.addFileSize(packFile.length());
                }
                if (pack.getFileSize() > pack.getSize()) {
                    pack.setSize(pack.getFileSize());
                }
                packOutputStream.flush();
                packOutputStream.close();
                packJar.closeEntry();
            }
            finally {
                packJar.flush();
                if (this.packSeparateJars()) {
                    packJar.close();
                }
            }
            XMLElementImpl child = new XMLElementImpl("pack", (IXMLElement)root);
            child.setAttribute("name", pack.getName());
            child.setAttribute("size", Long.toString(pack.getSize()));
            child.setAttribute("fileSize", Long.toString(pack.getFileSize()));
            if (pack.getLangPackId() != null) {
                child.setAttribute("id", pack.getLangPackId());
            }
            root.addChild((IXMLElement)child);
            ++packNumber;
        }
        installerJar.putNextEntry(new ZipEntry("resources/packs.info"));
        Throwable throwable = null;
        try (ObjectOutputStream out = new ObjectOutputStream((OutputStream)new NoCloseOutputStream((OutputStream)installerJar));){
            out.writeObject(packs);
        }
        catch (Throwable pack) {
            Throwable throwable2 = pack;
            throw pack;
        }
        installerJar.closeEntry();
        for (PackFile packFile : pack200Files) {
            try {
                installerJar.putNextEntry(new ZipEntry("resources/" + packFile.getStreamResourceName()));
                Path tmpfile = Files.createTempFile("izpack-compress", ".pack200", new FileAttribute[0]);
                try {
                    OutputStream tmpOut = Files.newOutputStream(tmpfile, new OpenOption[0]);
                    Throwable throwable3 = null;
                    try {
                        BufferedOutputStream bufferedOut = new BufferedOutputStream(tmpOut);
                        Throwable throwable4 = null;
                        try {
                            CountingOutputStream proxyOutputStream = new CountingOutputStream((OutputStream)bufferedOut);
                            Pack200.Packer packer = this.createPack200Packer(packFile);
                            try (JarFile jar = new JarFile(packFile.getFile());){
                                packer.pack(jar, (OutputStream)proxyOutputStream);
                            }
                            packFile.setSize(proxyOutputStream.getByteCount());
                            Files.copy(tmpfile, installerJar);
                            logger.fine("File " + packFile.getTargetPath() + " added compressed as Pack 200 (" + packFile.length() + " -> " + packFile.size() + " bytes)");
                        }
                        catch (Throwable throwable5) {
                            throwable4 = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (bufferedOut == null) continue;
                            if (throwable4 != null) {
                                try {
                                    bufferedOut.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable4.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            bufferedOut.close();
                        }
                    }
                    catch (Throwable throwable7) {
                        throwable3 = throwable7;
                        throw throwable7;
                    }
                    finally {
                        if (tmpOut == null) continue;
                        if (throwable3 != null) {
                            try {
                                tmpOut.close();
                            }
                            catch (Throwable throwable8) {
                                throwable3.addSuppressed(throwable8);
                            }
                            continue;
                        }
                        tmpOut.close();
                    }
                }
                finally {
                    Files.deleteIfExists(tmpfile);
                }
            }
            finally {
                installerJar.closeEntry();
                installerJar.flush();
            }
        }
    }

    private Pack200.Packer createPack200Packer(PackFile packFile) {
        Pack200.Packer packer = Pack200.newPacker();
        SortedMap defaultPackerProperties = packer.properties();
        Map localPackerProperties = packFile.getPack200Properties();
        if (localPackerProperties != null) {
            defaultPackerProperties.putAll(localPackerProperties);
        }
        return packer;
    }

    @Override
    public void addConfigurationInformation(IXMLElement data) {
    }
}

