/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.file;

import com.izforge.izpack.util.OsVersion;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;

public class FileUtils {
    public static final long FAT_FILE_TIMESTAMP_GRANULARITY = 2000L;
    public static final long UNIX_FILE_TIMESTAMP_GRANULARITY = 1000L;

    public static void copyFile(String sourceFile, String destFile, boolean overwrite, boolean preserveLastModified) throws IOException {
        FileUtils.copyFile(new File(sourceFile), new File(destFile), overwrite, preserveLastModified);
    }

    public static void copyFile(File sourceFile, File destFile, boolean overwrite, boolean preserveLastModified) throws IOException {
        if (overwrite || !destFile.exists() || destFile.lastModified() < sourceFile.lastModified()) {
            org.apache.commons.io.FileUtils.copyFile((File)sourceFile, (File)destFile, (boolean)preserveLastModified);
        }
    }

    public static File resolveFile(File file, String filename) throws Exception {
        return new File(FilenameUtils.concat((String)(file == null ? null : file.getPath()), (String)filename));
    }

    public static File getParentFile(File f) {
        return f == null ? null : f.getParentFile();
    }

    public static boolean isSymbolicLink(File parent, String name) throws IOException {
        if (parent == null) {
            File f = new File(name);
            parent = f.getParentFile();
            name = f.getName();
        }
        File toTest = new File(parent.getCanonicalPath(), name);
        return org.apache.commons.io.FileUtils.isSymlink((File)toTest);
    }

    public static String removeLeadingPath(File leading, File path) throws Exception {
        String p;
        String l = FilenameUtils.normalize((String)leading.getAbsolutePath());
        if (l.equals(p = FilenameUtils.normalize((String)path.getAbsolutePath()))) {
            return "";
        }
        if (!l.endsWith(File.separator)) {
            l = l + File.separator;
        }
        return p.startsWith(l) ? p.substring(l.length()) : p;
    }

    public static long getFileTimestampGranularity() {
        return OsVersion.IS_WINDOWS ? 2000L : 1000L;
    }

    public static File createTempDirectory(String prefix, File directory) throws IOException {
        File tempFile = File.createTempFile(prefix, "", directory);
        tempFile.delete();
        File tempDirectory = new File(tempFile.getPath() + ".tmp");
        if (!tempDirectory.mkdirs()) {
            throw new IOException("Failed to create temporary directory: " + tempDirectory);
        }
        return tempDirectory;
    }
}

