package org.codehaus.mojo.axistools;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on axistools-maven-plugin.<br/> Call <pre>  mvn axistools:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Tue Aug 10 19:27:43 CEST 2010
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.5.1)
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.codehaus.mojo:axistools-maven-plugin:1.4", 0 );
        append( sb, "", 0 );

        append( sb, "Axis Tools Maven Plugin", 0 );
        append( sb, "This plugin supports the wsdl2java and java2wsdl tools from the Apache Axis (1) project.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 4 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "admin".equals( goal ) )
        {
            append( sb, "axistools:admin", 0 );
            append( sb, "Utility for turning xml into Axis deployment operations (wraps org.apache.axis.utils.Admin)", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "configOutputDirectory (Default: ${basedir}/src/main/webapp/WEB-INF)", 2 );
                append( sb, "Where the server-config.wsdd or client-config.wsdd should go.", 3 );
                append( sb, "", 0 );

                append( sb, "inputFiles", 2 );
                append( sb, "Files used to create deployment file.", 3 );
                append( sb, "", 0 );

                append( sb, "isServerConfig (Default: true)", 2 );
                append( sb, "Generate a server or client deployment file.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "axistools:help", 0 );
            append( sb, "Display help information on axistools-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0axistools:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "java2wsdl".equals( goal ) )
        {
            append( sb, "axistools:java2wsdl", 0 );
            append( sb, "A Plugin for generating WSDL files using Axis Java2WSDL.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "all", 2 );
                append( sb, "Look for allowed methods in inherited class. Corresponds to the -a, --all option in the Java2WSDL command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "bindingName", 2 );
                append( sb, "Indicates the name to use for the binding element. If not specified, the value of the servicePortName + \'SoapBinding\' is used. Corresponds to the -b, --bindingName option in the Java2WSDL command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "classesDirectory (Default: ${project.build.outputDirectory})", 2 );
                append( sb, "The directory the compile objects will be located for java2wsdl to source from.", 3 );
                append( sb, "", 0 );

                append( sb, "classOfPortType", 2 );
                append( sb, "The class-of-portType.", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "List of methods not to export. Corresponds to the -x, --exclude option in the Java2WSDL command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "extraClasses", 2 );
                append( sb, "Specify a list of class names which should be included in the types section of the WSDL document. This is useful in the case where your service interface references a base class and you would like your WSDL to contain XML Schema type definitions for these other classes. Corresponds to the -e, --extraClasses option in the Java2WSDL command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "filename", 2 );
                append( sb, "Indicates the name of the output WSDL file. Corresponds to the -o, --output option in the Java2WSDL command line tool, together with the outputDirectory parameter.", 3 );
                append( sb, "", 0 );

                append( sb, "implClass", 2 );
                append( sb, "Sometimes extra information is available in the implementation class file. Use this option to specify the implementation class. Corresponds to the -i, --implClass option in the Java2WSDL command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "importSchema", 2 );
                append( sb, "A file or URL to an XML Schema that should be physically imported into the generated WSDL. Corresponds to the -C, --importSchema option in the Java2WSDL command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "input", 2 );
                append( sb, "Optional parameter that indicates the name of the input wsdl file. The output wsdl file will contain everything from the input wsdl file plus the new constructs. If a new construct is already present in the input wsdl file, it is not added. This option is useful for constructing a wsdl file with multiple ports, bindings, or portTypes. Corresponds to the -I, --input option in the Java2WSDL command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "location", 2 );
                append( sb, "Indicates the url of the location of the service. The name after the last slash or backslash is the name of the service port (unless overridden by the servicePortName option). The service port address location attribute is assigned the specified value. Corresponds to the -l, --location option in the Java2WSDL command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "locationImport", 2 );
                append( sb, "Used to indicate the location of the interface WSDL when generating an implementation WSDL. Corresponds to the -L, --locationImport option in the Java2WSDL command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "methods", 2 );
                append( sb, "Methods to export. Corresponds to the -m, --methods option in the Java2WSDL command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "namespace", 2 );
                append( sb, "Indicates the name of the target namespace of the WSDL. Corresponds to the -n, --namespace option in the Java2WSDL command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "namespaceImpl", 2 );
                append( sb, "Namespace of the implementation WSDL. Corresponds to the -N, --namespaceImpl option in the Java2WSDL command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory}/generated-sources/axistools/java2wsdl)", 2 );
                append( sb, "Directory for generated content. Corresponds to the -o, --output option in the Java2WSDL command line tool, together with the filename parameter.", 3 );
                append( sb, "", 0 );

                append( sb, "outputImpl", 2 );
                append( sb, "Use this option to indicate the name of the output implementation WSDL file. If specified, Java2WSDL will produce interface and implementation WSDL files. If this option is used, the outputWSDLMode option is ignored. Corresponds to the -O, --outputImpl option in the Java2WSDL command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "outputWSDLMode", 2 );
                append( sb, "Indicates the kind of WSDL to generate. Accepted values are:\n-\tAll --- (default) Generates wsdl containing both interface and implementation WSDL constructs.\n-\tInterface --- Generates a WSDL containing the interface constructs (no service element).\n-\tImplementation -- Generates a WSDL containing the implementation. The interface WSDL is imported via the locationImport option.\nCorresponds to the -w, --outputWsdlMode option in the Java2WSDL command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "packageToNamespace", 2 );
                append( sb, "Package=namespace, name value pair. The plugin currently only supports one name value pair. Corresponds to the -p, --PkgtoNS option in the Java2WSDL command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "portTypeName", 2 );
                append( sb, "Indicates the name to use for the portType element. If not specified, the classOfPortType name is used. Corresponds to the -P, --portTypeName option in the Java2WSDL command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "serviceElementName", 2 );
                append( sb, "Service element name (defaults to servicePortName value + \'Service\'). Corresponds to the -S, --serviceElementName option in the Java2WSDL command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "servicePortName", 2 );
                append( sb, "Indicates the name of the service port. If not specified, the service port name is derived from the location value. Corresponds to the -s, --servicePortName option in the Java2WSDL command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "soapAction", 2 );
                append( sb, "The value of the operations soapAction field. Values are DEFAULT, OPERATION or NONE. OPERATION forces soapAction to the name of the operation. DEFAULT causes the soapAction to be set according to the operation\'s meta data (usually \'\'). NONE forces the soapAction to \'\'. The default is DEFAULT. Corresponds to the -A, --soapAction option in the Java2WSDL command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "stopClasses", 2 );
                append( sb, "List of classes which stop the Java2WSDL inheritance search. Corresponds to the -c, --stopClasses option in the Java2WSDL command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "style", 2 );
                append( sb, "The style of the WSDL document: RPC, DOCUMENT or WRAPPED. The default is RPC. If RPC is specified, an rpc wsdl is generated. If DOCUMENT is specified, a document wsdl is generated. If WRAPPED is specified, a document/literal wsdl is generated using the wrapped approach. Wrapped style forces the use attribute to be literal. Corresponds to the -y, --style option in the Java2WSDL command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "typeMappingVersion", 2 );
                append( sb, "Choose the default type mapping registry to use. Either 1.1 or 1.2. Corresponds to the -T, --typeMappingVersion option in the Java2WSDL command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "use", 2 );
                append( sb, "The use of the WSDL document: LITERAL or ENCODED. If LITERAL is specified, the XML Schema defines the representation of the XML for the request. If ENCODED is specified, SOAP encoding is specified in the generated WSDL. Corresponds to the -u, --use option in the Java2WSDL command line tool.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "wsdl2java".equals( goal ) )
        {
            append( sb, "axistools:wsdl2java", 0 );
            append( sb, "A Plugin for generating stubs for WSDL files using Axis WSDL2Java.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "allElements", 2 );
                append( sb, "Generate code for all elements, even unreferenced ones. By default, WSDL2Java only generates code for those elements in the WSDL file that are referenced. A note about what it means to be referenced. We cannot simply say: start with the services, generate all bindings referenced by the service, generate all portTypes referenced by the referenced bindings, etc. What if we\'re generating code from a WSDL file that only contains portTypes, messages, and types? If WSDL2Java used service as an anchor, and there\'s no service in the file, then nothing will be generated. So the anchor is the lowest element that exists in the WSDL file in the order:\n1.\ttypes\n2.\tportTypes\n3.\tbindings\n4.\tservices\nFor example, if a WSDL file only contained types, then all the listed types would be generated. But if a WSDL file contained types and a portType, then that portType will be generated and only those types that are referenced by that portType. Note that the anchor is searched for in the WSDL file appearing on the command line, not in imported WSDL files. This allows one WSDL file to import constructs defined in another WSDL file without the nuisance of having all the imported WSDL file\'s constructs generated. Corresponds to the -a, --all option in the WSDL2Java command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "debug (Default: false)", 2 );
                append( sb, "Print debug information, which currently is WSDL2Java\'s symbol table. Note that this is only printed after the symbol table is complete, ie., after the WSDL is parsed successfully. Corresponds to the -D, --Debug option in the WSDL2Java command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "deployScope", 2 );
                append( sb, "Add scope to deploy.xml: \'Application\', \'Request\', \'Session\'. Corresponds to the -d, --deployScope option in the WSDL2Java command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "factory", 2 );
                append( sb, "Name of a custom class that implements GeneratorFactory interface (for extending Java generation functions). Corresponds to the -F, --factory option in the WSDL2Java command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "fileNamespaceToPackage", 2 );
                append( sb, "File containing namespace to package mappings. Corresponds to the -f, --fileNStoPkg option in the WSDL2Java command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "helperGen (Default: false)", 2 );
                append( sb, "Emits separate Helper classes for meta data. Corresponds to the -H, --helperGen option in the WSDL2Java command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "implementationClassName", 2 );
                append( sb, "Use this as the implementation class. Corresponds to the -c, --implementationClassName option in the WSDL2Java command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "mappings", 2 );
                append( sb, "Mappings of <namespace> to <targetPackage>.", 3 );
                append( sb, "", 0 );

                append( sb, "namespaceToPackage", 2 );
                append( sb, "Mapping of namespace to package. This is only used when useEmitter is set to true. If useEmitter is set to false you should use mappings instead. Corresponds to the -N, --NStoPkg option in the WSDL2Java command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "noImports (Default: false)", 2 );
                append( sb, "Only generate code for the immediate WSDL document. Corresponds to the -n, --noImports option in the WSDL2Java command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "noWrapped (Default: false)", 2 );
                append( sb, "Turn off support for \'wrapped\' document/literal. Corresponds to the -W, --noWrapped option in the WSDL2Java command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "nsExcludes", 2 );
                append( sb, "Namespace to specifically exclude from the generated code (defaults to none excluded until first namespace included with nsIncludes option). Corresponds to the -x, --nsExclude option in the WSDL2Java command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "nsIncludes", 2 );
                append( sb, "Namescape to specifically include in the generated code (defaults to all namespaces unless specifically excluded with the nsExcludes option). Corresponds to the -i, --nsInclude option in the WSDL2Java command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory}/generated-sources/axistools/wsdl2java)", 2 );
                append( sb, "Location to place generated java source files. Corresponds to the -o, --output option in the WSDL2Java command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "packageSpace", 2 );
                append( sb, "Package to create the java files under, for example com.company.wsdl. Corresponds to the -p, --package option in the WSDL2Java command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "password", 2 );
                append( sb, "Password to access the WSDL-URI. Corresponds to the -P, --password option in the WSDL2Java command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "runTestCasesAsUnitTests (Default: false)", 2 );
                append( sb, "Copy the generated test cases to a generated-sources test directory to be compiled and run as normal Surefire unit tests.", 3 );
                append( sb, "", 0 );

                append( sb, "serverSide", 2 );
                append( sb, "Emit server-side bindings for web service. Corresponds to the -s, --server-side option in the WSDL2Java command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "skeletonDeploy (Default: false)", 2 );
                append( sb, "Deploy skeleton (true) or implementation (false) in deploy.wsdd. Corresponds to the -S, --skeletonDeploy option in the WSDL2Java command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "sourceDependencies", 2 );
                append( sb, "List of source dependencies in the format groupId:artifactId:version:file.", 3 );
                append( sb, "", 0 );

                append( sb, "sourceDependencyDirectory (Default: ${project.build.directory}/axistools/wsdl2java/sourceDependencies)", 2 );
                append( sb, "Cache directory for WSDLs from sourceDependencies.", 3 );
                append( sb, "", 0 );

                append( sb, "sourceDirectory (Default: ${basedir}/src/main/wsdl)", 2 );
                append( sb, "Source directory that contains .wsdl files.", 3 );
                append( sb, "", 0 );

                append( sb, "staleMillis (Default: 0)", 2 );
                append( sb, "The granularity in milliseconds of the last modification date for testing whether a source needs recompilation.", 3 );
                append( sb, "", 0 );

                append( sb, "subPackageByFileName", 2 );
                append( sb, "load.wsdl would further subpackage into load.*", 3 );
                append( sb, "", 0 );

                append( sb, "testCases", 2 );
                append( sb, "Generate the test cases. Corresponds to the -t, --testCase option in the WSDL2Java command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "testSourceDirectory (Default: ${project.build.directory}/generated-test-sources/wsdl)", 2 );
                append( sb, "Location to place generated test source files.", 3 );
                append( sb, "", 0 );

                append( sb, "timeout", 2 );
                append( sb, "Timeout in seconds (default is 45, specify -1 to disable). Corresponds to the -O, --timeout option in the WSDL2Java command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "timestampDirectory (Default: ${project.build.directory})", 2 );
                append( sb, "Directory used when evaluating whether files are up to date or stale.", 3 );
                append( sb, "", 0 );

                append( sb, "typeMappingVersion (Default: 1.1)", 2 );
                append( sb, "Indicate either 1.1 or 1.2, where 1.1 means SOAP 1.1 JAX-RPC compliant and 1.2 indicates SOAP 1.1 encoded. Corresponds to the -T, --typeMappingVersion option in the WSDL2Java command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "urlDownloadDirectory (Default: ${project.build.directory}/axistools/wsdl2java/urlDownloads)", 2 );
                append( sb, "Cache directory for WSDLs from URLs.", 3 );
                append( sb, "", 0 );

                append( sb, "urls", 2 );
                append( sb, "List of URLs to process.", 3 );
                append( sb, "", 0 );

                append( sb, "useEmitter (Default: false)", 2 );
                append( sb, "Use the Emitter for generating the java files as opposed to the commandline wsdl2java tool.", 3 );
                append( sb, "", 0 );

                append( sb, "username", 2 );
                append( sb, "Username to access the WSDL-URI. Corresponds to the -U, --user option in the WSDL2Java command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "verbose", 2 );
                append( sb, "See what the tool is generating as it is generating it. Corresponds to the -v, --verbose option in the WSDL2Java command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "wrapArrays (Default: true)", 2 );
                append( sb, "Prefer generating JavaBean classes like \'ArrayOfString\' for certain schema array patterns. Corresponds to the -w, --wrapArrays option in the WSDL2Java command line tool.", 3 );
                append( sb, "", 0 );

                append( sb, "wsdlFiles", 2 );
                append( sb, "List of WSDL files from sourceDirectory to process. The files will be processed in the order they appear in your configuration.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
