/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.keytool;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.keytool.AbstractKeyToolMojo;
import org.codehaus.mojo.keytool.KeyTool;
import org.codehaus.mojo.keytool.KeyToolException;
import org.codehaus.mojo.keytool.KeyToolRequest;
import org.codehaus.mojo.keytool.KeyToolResult;
import org.codehaus.plexus.util.cli.Commandline;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractKeyToolRequestMojo<R extends KeyToolRequest>
extends AbstractKeyToolMojo {
    private String[] arguments;
    private File workingDirectory;
    private final Class<R> requestType;
    private KeyTool keyTool;

    protected AbstractKeyToolRequestMojo(Class<R> requestType) {
        this.requestType = requestType;
    }

    public final void execute() throws MojoExecutionException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)this.getMessage("disabled"));
        } else {
            R request = this.createKeytoolRequest();
            try {
                KeyToolResult result = this.keyTool.execute(request);
                this.consumeResult(result);
            }
            catch (KeyToolException e) {
                throw new MojoExecutionException(this.getMessage("commandLineException", e.getMessage()), (Exception)((Object)e));
            }
        }
    }

    protected R createKeytoolRequest() {
        KeyToolRequest request;
        try {
            request = (KeyToolRequest)this.requestType.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create keytool request ", e);
        }
        request.setVerbose(this.isVerbose());
        request.setWorkingDirectory(this.workingDirectory);
        request.setArguments(this.arguments);
        return (R)request;
    }

    protected String getCommandlineInfo(Commandline commandLine) {
        if (commandLine == null) {
            throw new NullPointerException("commandLine");
        }
        return commandLine.toString();
    }

    protected final void consumeResult(KeyToolResult result) throws MojoExecutionException {
        Commandline commandLine = result.getCommandline();
        int resultCode = result.getExitCode();
        if (resultCode != 0) {
            throw new MojoExecutionException(this.getMessage("failure", this.getCommandlineInfo(commandLine), resultCode));
        }
    }
}

