/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.codehaus.mojo.license.AbstractLicenseNameMojo;
import org.codehaus.mojo.license.FileUtil;
import org.codehaus.mojo.license.MojoHelper;
import org.codehaus.mojo.license.header.FileHeader;
import org.codehaus.mojo.license.header.FileHeaderProcessor;
import org.codehaus.mojo.license.header.FileHeaderProcessorConfiguration;
import org.codehaus.mojo.license.header.InvalideFileHeaderException;
import org.codehaus.mojo.license.header.UpdateFileHeaderFilter;
import org.codehaus.mojo.license.header.transformer.FileHeaderTransformer;
import org.codehaus.mojo.license.model.License;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateFileHeaderMojo
extends AbstractLicenseNameMojo
implements FileHeaderProcessorConfiguration {
    protected String projectName;
    protected String organizationName;
    protected String inceptionYear;
    protected boolean addSvnKeyWords;
    protected boolean canUpdateDescription;
    protected boolean canUpdateCopyright;
    protected boolean canUpdateLicense;
    protected boolean updateCopyright;
    protected String ignoreTag;
    protected boolean skipUpdateLicense;
    protected boolean dryRun;
    protected boolean clearAfterOperation;
    protected String[] roots;
    protected String[] includes;
    protected String[] excludes;
    protected Map<String, String> extraExtensions;
    private FileHeaderProcessor processor;
    private UpdateFileHeaderFilter filter;
    private Map<String, FileHeaderTransformer> transformers;
    private FileHeaderTransformer transformer;
    private FileHeader header;
    private long timestamp;
    private Map<String, String> extensionToCommentStyle;
    public static final String[] DEFAULT_INCLUDES = new String[]{"**/*"};
    public static final String[] DEFAULT_EXCLUDES = new String[]{"**/*.zargo", "**/*.uml", "**/*.umldi", "**/*.xmi", "**/*.img", "**/*.png", "**/*.jpg", "**/*.jpeg", "**/*.gif", "**/*.zip", "**/*.jar", "**/*.war", "**/*.ear", "**/*.tgz", "**/*.gz"};
    public static final String[] DEFAULT_ROOTS = new String[]{"src", "target/generated-sources", "target/processed-sources"};
    private Set<File> processedFiles;
    private EnumMap<FileState, Set<File>> result;
    private Map<String, List<File>> filesToTreateByCommentStyle;

    @Override
    public void init() throws Exception {
        if (this.isSkip()) {
            return;
        }
        if (StringUtils.isEmpty((String)this.getIgnoreTag())) {
            this.setIgnoreTag("%%Ignore-License");
        }
        if (this.isVerbose()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("config - available comment styles :");
            String string = "\n  * %1$s (%2$s)";
            for (String transformerName : this.getTransformers().keySet()) {
                FileHeaderTransformer transformer = this.getTransformer(transformerName);
                String str = String.format(string, transformer.getName(), transformer.getDescription());
                buffer.append(str);
            }
            this.getLog().info((CharSequence)buffer.toString());
        }
        if (this.isUpdateCopyright()) {
            this.getLog().warn((CharSequence)"\n\nupdateCopyright is not still available...\n\n");
        }
        this.setTimestamp(System.nanoTime());
        this.getFilter().setUpdateCopyright(this.isCanUpdateCopyright());
        this.getFilter().setUpdateDescription(this.isCanUpdateDescription());
        this.getFilter().setUpdateLicense(this.isCanUpdateLicense());
        this.getFilter().setLog(this.getLog());
        this.getProcessor().setConfiguration(this);
        this.getProcessor().setFilter(this.filter);
        super.init();
        if (this.roots == null || this.roots.length == 0) {
            this.roots = DEFAULT_ROOTS;
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Will use default roots " + Arrays.toString(this.roots)));
            }
        }
        if (this.includes == null || this.includes.length == 0) {
            this.includes = DEFAULT_INCLUDES;
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Will use default includes " + Arrays.toString(this.includes)));
            }
        }
        if (this.excludes == null || this.excludes.length == 0) {
            this.excludes = DEFAULT_EXCLUDES;
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Will use default excludes" + Arrays.toString(this.excludes)));
            }
        }
        this.extensionToCommentStyle = new TreeMap<String, String>();
        for (Map.Entry<String, FileHeaderTransformer> entry : this.transformers.entrySet()) {
            String[] extensions;
            String commentStyle = entry.getKey();
            FileHeaderTransformer transformer = entry.getValue();
            for (String extension : extensions = transformer.getDefaultAcceptedExtensions()) {
                if (this.isVerbose()) {
                    this.getLog().info((CharSequence)("Associate extension " + extension + " to comment style " + commentStyle));
                }
                this.extensionToCommentStyle.put(extension, commentStyle);
            }
        }
        if (this.extraExtensions != null) {
            for (Map.Entry<String, Object> entry : this.extraExtensions.entrySet()) {
                String extension = entry.getKey();
                if (this.extensionToCommentStyle.containsKey(extension)) {
                    this.getLog().warn((CharSequence)("The extension " + extension + " is already accepted for comment style " + this.extensionToCommentStyle.get(extension)));
                }
                String commentStyle = (String)entry.getValue();
                this.getTransformer(commentStyle);
                if (this.isVerbose()) {
                    this.getLog().info((CharSequence)("Associate extension '" + extension + "' to comment style '" + commentStyle + "'"));
                }
                this.extensionToCommentStyle.put(extension, commentStyle);
            }
        }
        this.filesToTreateByCommentStyle = this.obtainFilesToTreateByCommentStyle();
    }

    protected Map<String, List<File>> obtainFilesToTreateByCommentStyle() {
        HashMap<String, List<File>> result = new HashMap<String, List<File>>();
        for (String commentStyle : this.transformers.keySet()) {
            result.put(commentStyle, new ArrayList());
        }
        ArrayList<String> rootsList = new ArrayList<String>(this.roots.length);
        for (String string : this.roots) {
            File f = new File(string);
            if (f.isAbsolute()) {
                rootsList.add(f.getAbsolutePath());
            } else {
                f = new File(this.getProject().getBasedir(), string);
            }
            if (f.exists()) {
                this.getLog().info((CharSequence)("Will search files to update from root " + f));
                rootsList.add(f.getAbsolutePath());
                continue;
            }
            if (!this.isVerbose()) continue;
            this.getLog().info((CharSequence)("Skip not found root " + f));
        }
        HashMap<File, String[]> allFiles = new HashMap<File, String[]>();
        this.getFilesToTreateForRoots(this.includes, this.excludes, rootsList, allFiles);
        for (Map.Entry entry : allFiles.entrySet()) {
            String[] filesPath;
            File file = (File)entry.getKey();
            for (String path : filesPath = (String[])entry.getValue()) {
                String extension = FileUtils.extension((String)path);
                String commentStyle = this.extensionToCommentStyle.get(extension);
                if (StringUtils.isEmpty((String)commentStyle)) continue;
                File file2 = new File(file, path);
                List files = (List)result.get(commentStyle);
                files.add(file2);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAction() throws Exception {
        block14: {
            int nbFiles2;
            long t0;
            block13: {
                t0 = System.nanoTime();
                this.clear();
                this.processedFiles = new HashSet<File>();
                this.result = new EnumMap(FileState.class);
                try {
                    for (Map.Entry<String, List<File>> commentStyleFiles : this.getFilesToTreateByCommentStyle().entrySet()) {
                        String commentStyle = commentStyleFiles.getKey();
                        List<File> files = commentStyleFiles.getValue();
                        this.processCommentStyle(commentStyle, files);
                    }
                    Object var8_6 = null;
                    nbFiles2 = this.getProcessedFiles().size();
                    if (nbFiles2 != 0) break block13;
                }
                catch (Throwable throwable) {
                    Object var8_7 = null;
                    int nbFiles2 = this.getProcessedFiles().size();
                    if (nbFiles2 == 0) {
                        this.getLog().warn((CharSequence)"No file to scan.");
                    } else {
                        String delay = MojoHelper.convertTime(System.nanoTime() - t0);
                        String message = String.format("Scan %s file%s header done in %s.", nbFiles2, nbFiles2 > 1 ? "s" : "", delay);
                        this.getLog().info((CharSequence)message);
                    }
                    Set<FileState> states = this.result.keySet();
                    if (states.size() == 1 && states.contains((Object)FileState.uptodate)) {
                        this.getLog().info((CharSequence)"All files are up-to-date.");
                    } else {
                        StringBuilder buffer = new StringBuilder();
                        for (FileState state : FileState.values()) {
                            this.reportType(state, buffer);
                        }
                        this.getLog().info((CharSequence)buffer.toString());
                    }
                    if (this.isClearAfterOperation()) {
                        this.clear();
                    }
                    throw throwable;
                }
                this.getLog().warn((CharSequence)"No file to scan.");
                break block14;
            }
            String delay = MojoHelper.convertTime(System.nanoTime() - t0);
            String message = String.format("Scan %s file%s header done in %s.", nbFiles2, nbFiles2 > 1 ? "s" : "", delay);
            this.getLog().info((CharSequence)message);
        }
        Set<FileState> states = this.result.keySet();
        if (states.size() == 1 && states.contains((Object)FileState.uptodate)) {
            this.getLog().info((CharSequence)"All files are up-to-date.");
        } else {
            StringBuilder buffer = new StringBuilder();
            for (FileState state : FileState.values()) {
                this.reportType(state, buffer);
            }
            this.getLog().info((CharSequence)buffer.toString());
        }
        if (this.isClearAfterOperation()) {
            this.clear();
        }
    }

    protected void processCommentStyle(String commentStyle, List<File> filesToTreat) throws IOException {
        License license = this.getLicense(this.getLicenseName(), true);
        this.getLog().info((CharSequence)("Process header '" + commentStyle + "'"));
        this.getLog().info((CharSequence)(" - using " + license.getDescription()));
        this.setTransformer(this.getTransformer(commentStyle));
        FileHeader defaultFileHeader = this.buildDefaultFileHeader(license, this.getProjectName(), this.getInceptionYear(), this.getOrganizationName(), this.isAddSvnKeyWords(), this.getEncoding());
        this.setHeader(defaultFileHeader);
        this.getProcessor().populateFilter();
        for (File file : filesToTreat) {
            this.prepareProcessFile(file);
        }
        filesToTreat.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void prepareProcessFile(File file) throws IOException {
        if (this.getProcessedFiles().contains(file)) {
            this.getLog().info((CharSequence)(" - skip already processed file " + file));
            return;
        }
        File processFile = new File(file.getAbsolutePath() + "_" + this.getTimestamp());
        boolean doFinalize = false;
        try {
            try {
                doFinalize = this.processFile(file, processFile);
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("skip failed file : " + e.getMessage() + (e.getCause() == null ? "" : " Cause : " + e.getCause().getMessage())), (Throwable)e);
                FileState.fail.addFile(file, this.getResult());
                doFinalize = false;
                Object var6_5 = null;
                this.getProcessor().reset();
                this.getProcessedFiles().add(file);
                if (doFinalize) {
                    this.finalizeFile(file, processFile);
                    return;
                }
                FileUtil.deleteFile(processFile);
                return;
            }
            Object var6_4 = null;
            this.getProcessor().reset();
            this.getProcessedFiles().add(file);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.getProcessor().reset();
            this.getProcessedFiles().add(file);
            if (doFinalize) {
                this.finalizeFile(file, processFile);
                throw throwable;
            }
            FileUtil.deleteFile(processFile);
            throw throwable;
        }
        if (doFinalize) {
            this.finalizeFile(file, processFile);
            return;
        }
        FileUtil.deleteFile(processFile);
    }

    protected boolean processFile(File file, File processFile) throws IOException {
        String content;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)(" - process file " + file));
            this.getLog().debug((CharSequence)(" - will process into file " + processFile));
        }
        try {
            content = FileUtil.readAsString(file, this.getEncoding());
        }
        catch (IOException e) {
            throw new IOException("Could not obtain content of file " + file);
        }
        if (content.contains(this.getIgnoreTag())) {
            this.getLog().info((CharSequence)(" - ignore file (detected " + this.getIgnoreTag() + ") " + file));
            FileState.ignore.addFile(file, this.getResult());
            return false;
        }
        FileHeaderProcessor processor = this.getProcessor();
        try {
            processor.process(file, processFile);
        }
        catch (IllegalStateException e) {
            throw new InvalideFileHeaderException("Could not extract header on file " + file + " for reason " + e.getMessage());
        }
        catch (Exception e) {
            if (e instanceof InvalideFileHeaderException) {
                throw (InvalideFileHeaderException)e;
            }
            throw new IOException("Could not process file " + file + " for reason " + e.getMessage());
        }
        if (processor.isTouched()) {
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)(" - header was updated for " + file));
            }
            if (processor.isModified()) {
                FileState.update.addFile(file, this.getResult());
                return true;
            }
            FileState.uptodate.addFile(file, this.getResult());
            return false;
        }
        if (processor.isDetectHeader()) {
            throw new InvalideFileHeaderException("Could not find header end on file " + file);
        }
        this.getLog().info((CharSequence)(" - adding license header on file " + file));
        content = this.getTransformer().addHeader(this.getFilter().getFullHeaderContent(), content);
        if (!this.isDryRun()) {
            FileUtil.writeString(processFile, content, this.getEncoding());
        }
        FileState.add.addFile(file, this.getResult());
        return true;
    }

    protected void finalizeFile(File file, File processFile) throws IOException {
        if (this.isKeepBackup() && !this.isDryRun()) {
            File backupFile = FileUtil.getBackupFile(file);
            if (backupFile.exists()) {
                FileUtil.deleteFile(backupFile);
            }
            if (this.isVerbose()) {
                this.getLog().debug((CharSequence)(" - backup original file " + file));
            }
            FileUtil.renameFile(file, backupFile);
        }
        if (this.isDryRun()) {
            FileUtil.deleteFile(processFile);
        } else {
            try {
                FileUtil.renameFile(processFile, file);
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)e.getMessage());
                FileUtils.copyFile((File)processFile, (File)file);
                FileUtil.deleteFile(processFile);
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.clear();
    }

    protected void clear() {
        EnumMap<FileState, Set<File>> result;
        Set<File> files = this.getProcessedFiles();
        if (files != null) {
            files.clear();
        }
        if ((result = this.getResult()) != null) {
            for (Set<File> fileSet : result.values()) {
                fileSet.clear();
            }
            result.clear();
        }
    }

    protected void reportType(FileState state, StringBuilder buffer) {
        String operation = state.name();
        Set<File> set = this.getFiles(state);
        if (set == null || set.isEmpty()) {
            if (this.isVerbose()) {
                buffer.append("\n * no header to ");
                buffer.append(operation);
                buffer.append(".");
            }
            return;
        }
        buffer.append("\n * ").append(operation).append(" header on ");
        buffer.append(set.size());
        if (set.size() == 1) {
            buffer.append(" file.");
        } else {
            buffer.append(" files.");
        }
        if (this.isVerbose()) {
            for (File file : set) {
                buffer.append("\n   - ").append(file);
            }
        }
    }

    protected FileHeader buildDefaultFileHeader(License license, String projectName, String inceptionYear, String copyrightHolder, boolean addSvnKeyWords, String encoding) throws IOException {
        FileHeader result = new FileHeader();
        StringBuilder buffer = new StringBuilder();
        buffer.append(projectName);
        if (addSvnKeyWords) {
            char ls = '\n';
            buffer.append(ls);
            buffer.append(ls).append("$Id$");
            buffer.append(ls).append("$HeadURL$");
        }
        result.setDescription(buffer.toString());
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("header description : " + result.getDescription()));
        }
        String licenseContent = license.getHeaderContent(encoding);
        result.setLicense(licenseContent);
        Integer firstYear = Integer.valueOf(inceptionYear);
        result.setCopyrightFirstYear(firstYear);
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        Integer lastYear = cal.get(1);
        if (firstYear < lastYear) {
            result.setCopyrightLastYear(lastYear);
        }
        result.setCopyrightHolder(copyrightHolder);
        return result;
    }

    public FileHeaderTransformer getTransformer(String transformerName) throws IllegalArgumentException, IllegalStateException {
        if (StringUtils.isEmpty((String)transformerName)) {
            throw new IllegalArgumentException("transformerName can not be null, nor empty!");
        }
        Map<String, FileHeaderTransformer> transformers = this.getTransformers();
        if (transformers == null) {
            throw new IllegalStateException("No transformers initialized!");
        }
        FileHeaderTransformer transformer = transformers.get(transformerName);
        if (transformer == null) {
            throw new IllegalArgumentException("transformerName " + transformerName + " is unknow, use one this one : " + transformers.keySet());
        }
        return transformer;
    }

    public boolean isClearAfterOperation() {
        return this.clearAfterOperation;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getInceptionYear() {
        return this.inceptionYear;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public boolean isUpdateCopyright() {
        return this.updateCopyright;
    }

    public boolean isCanUpdateDescription() {
        return this.canUpdateDescription;
    }

    public boolean isCanUpdateCopyright() {
        return this.canUpdateCopyright;
    }

    public boolean isCanUpdateLicense() {
        return this.canUpdateLicense;
    }

    public String getIgnoreTag() {
        return this.ignoreTag;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public UpdateFileHeaderFilter getFilter() {
        return this.filter;
    }

    @Override
    public FileHeader getFileHeader() {
        return this.header;
    }

    @Override
    public FileHeaderTransformer getTransformer() {
        return this.transformer;
    }

    @Override
    public boolean isSkip() {
        return this.skipUpdateLicense;
    }

    public Set<File> getProcessedFiles() {
        return this.processedFiles;
    }

    public EnumMap<FileState, Set<File>> getResult() {
        return this.result;
    }

    public Set<File> getFiles(FileState state) {
        return this.result.get((Object)state);
    }

    public boolean isAddSvnKeyWords() {
        return this.addSvnKeyWords;
    }

    public FileHeaderProcessor getProcessor() {
        return this.processor;
    }

    public Map<String, FileHeaderTransformer> getTransformers() {
        return this.transformers;
    }

    public Map<String, List<File>> getFilesToTreateByCommentStyle() {
        return this.filesToTreateByCommentStyle;
    }

    @Override
    public void setSkip(boolean skipUpdateLicense) {
        this.skipUpdateLicense = skipUpdateLicense;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setSkipUpdateLicense(boolean skipUpdateLicense) {
        this.skipUpdateLicense = skipUpdateLicense;
    }

    public void setInceptionYear(String inceptionYear) {
        this.inceptionYear = inceptionYear;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public void setUpdateCopyright(boolean updateCopyright) {
        this.updateCopyright = updateCopyright;
    }

    public void setIgnoreTag(String ignoreTag) {
        this.ignoreTag = ignoreTag;
    }

    public void setAddSvnKeyWords(boolean addSvnKeyWords) {
        this.addSvnKeyWords = addSvnKeyWords;
    }

    public void setClearAfterOperation(boolean clearAfterOperation) {
        this.clearAfterOperation = clearAfterOperation;
    }

    public void setTransformer(FileHeaderTransformer transformer) {
        this.transformer = transformer;
    }

    public void setHeader(FileHeader header) {
        this.header = header;
    }

    public void setProcessor(FileHeaderProcessor processor) {
        this.processor = processor;
    }

    public void setFilter(UpdateFileHeaderFilter filter) {
        this.filter = filter;
    }

    public void setCanUpdateDescription(boolean canUpdateDescription) {
        this.canUpdateDescription = canUpdateDescription;
    }

    public void setCanUpdateCopyright(boolean canUpdateCopyright) {
        this.canUpdateCopyright = canUpdateCopyright;
    }

    public void setCanUpdateLicense(boolean canUpdateLicense) {
        this.canUpdateLicense = canUpdateLicense;
    }

    public void setTransformers(Map<String, FileHeaderTransformer> transformers) {
        this.transformers = transformers;
    }

    public void setFilesToTreateByCommentStyle(Map<String, List<File>> filesToTreateByCommentStyle) {
        this.filesToTreateByCommentStyle = filesToTreateByCommentStyle;
    }

    public void setRoots(String[] roots) {
        this.roots = roots;
    }

    public void setRoots(String roots) {
        this.roots = roots.split(",");
    }

    public void setIncludes(String[] includes) {
        this.includes = includes;
    }

    public void setIncludes(String includes) {
        this.includes = includes.split(",");
    }

    public void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes.split(",");
    }

    protected void getFilesToTreateForRoots(String[] includes, String[] excludes, List<String> roots, Map<File, String[]> files) {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setIncludes(includes);
        if (excludes != null) {
            ds.setExcludes(excludes);
        }
        for (String src : roots) {
            File f = new File(src);
            if (!f.exists()) continue;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("discovering source files in " + src));
            }
            ds.setBasedir(f);
            ds.scan();
            String[] tmp = ds.getIncludedFiles();
            if (tmp.length < 1) continue;
            ArrayList<String> toTreate = new ArrayList<String>();
            for (String filePath : tmp) {
                File srcFile = new File(f, filePath);
                toTreate.add(filePath);
            }
            if (toTreate.isEmpty()) continue;
            files.put(f, toTreate.toArray(new String[toTreate.size()]));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum FileState {
        update,
        uptodate,
        add,
        ignore,
        fail;


        public void addFile(File file, EnumMap<FileState, Set<File>> result) {
            Set<File> fileSet = result.get((Object)this);
            if (fileSet == null) {
                fileSet = new HashSet<File>();
                result.put(this, fileSet);
            }
            fileSet.add(file);
        }
    }
}

