/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.File;
import org.codehaus.mojo.license.AbstractLicenseNameMojo;
import org.codehaus.mojo.license.FileUtil;
import org.codehaus.mojo.license.model.License;

public class UpdateProjectLicenseMojo
extends AbstractLicenseNameMojo {
    protected File licenseFile;
    protected File outputDirectory;
    protected boolean generateBundle;
    protected String bundleLicensePath;
    protected boolean force;
    protected boolean skipUpdateProjectLicense;
    private boolean doGenerate;

    protected void init() throws Exception {
        if (this.isSkip()) {
            return;
        }
        super.init();
        File licenseFile = this.getLicenseFile();
        if (licenseFile != null) {
            File pomFile = this.getProject().getFile();
            this.setDoGenerate(this.isForce() || !licenseFile.exists() || licenseFile.lastModified() <= pomFile.lastModified());
        }
    }

    protected void doAction() throws Exception {
        License license = this.getLicense();
        File target = this.getLicenseFile();
        if (this.isDoGenerate()) {
            this.getLog().info((CharSequence)("Will create or update license file [" + license.getName() + "] to " + target));
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("detail of license :\n" + license));
            }
            if (target.exists() && this.isKeepBackup()) {
                if (this.isVerbose()) {
                    this.getLog().info((CharSequence)("backup " + target));
                }
                FileUtil.backupFile(target);
            }
        }
        String licenseContent = license.getLicenseContent(this.getEncoding());
        if (this.isDoGenerate()) {
            FileUtil.writeString(target, licenseContent, this.getEncoding());
        }
        if (this.hasClassPath()) {
            File resourceTarget = new File(this.getOutputDirectory(), target.getName());
            FileUtil.copyFile(this.getLicenseFile(), resourceTarget);
            this.addResourceDir(this.getOutputDirectory(), "**/" + resourceTarget.getName());
            if (this.isGenerateBundle()) {
                File bundleTarget = FileUtil.getFile(this.getOutputDirectory(), this.getBundleLicensePath());
                FileUtil.copyFile(target, bundleTarget);
                if (!resourceTarget.getName().equals(bundleTarget.getName())) {
                    this.addResourceDir(this.getOutputDirectory(), "**/" + bundleTarget.getName());
                }
            }
        }
    }

    public File getLicenseFile() {
        return this.licenseFile;
    }

    public boolean isGenerateBundle() {
        return this.generateBundle;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public String getBundleLicensePath() {
        return this.bundleLicensePath;
    }

    public boolean isDoGenerate() {
        return this.doGenerate;
    }

    public boolean isForce() {
        return this.force;
    }

    public boolean isSkip() {
        return this.skipUpdateProjectLicense;
    }

    public void setLicenseFile(File licenseFile) {
        this.licenseFile = licenseFile;
    }

    public void setGenerateBundle(boolean generateBundle) {
        this.generateBundle = generateBundle;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setBundleLicensePath(String bundleLicensePath) {
        this.bundleLicensePath = bundleLicensePath;
    }

    public void setDoGenerate(boolean doGenerate) {
        this.doGenerate = doGenerate;
    }

    public void setSkip(boolean skipUpdateProjectLicense) {
        this.skipUpdateProjectLicense = skipUpdateProjectLicense;
    }

    public void setForce(boolean force) {
        this.force = force;
    }
}

