/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.header.transformer;

import org.codehaus.mojo.license.header.transformer.AbstractFileHeaderTransformer;

public class JavaFileHeaderTransformer
extends AbstractFileHeaderTransformer {
    protected boolean addJavaLicenseAfterPackage;

    public JavaFileHeaderTransformer() {
        super("java", "header transformer with java comment style", "/*", " */", " * ");
    }

    public String[] getDefaultAcceptedExtensions() {
        return new String[]{"java", "groovy", "css", "cs", "as", "aj", "c", "h", "cpp", "js", "json"};
    }

    public void setAddJavaLicenseAfterPackage(boolean addJavaLicenseAfterPackage) {
        this.addJavaLicenseAfterPackage = addJavaLicenseAfterPackage;
    }

    public String addHeader(String header, String content) {
        String result;
        int endProlog;
        if (!this.addJavaLicenseAfterPackage) {
            return super.addHeader(header, content);
        }
        String prolog = null;
        int startProlog = content.indexOf("package");
        if (startProlog > -1 && (endProlog = content.indexOf(";", startProlog)) > -1) {
            int lastIndex = endProlog + 1;
            prolog = content.substring(0, lastIndex);
            prolog = prolog + "\n";
            if (lastIndex == content.length()) {
                content = content + "\n";
            }
        }
        if (prolog == null) {
            result = super.addHeader(header, content);
        } else {
            content = content.substring(prolog.length());
            result = super.addHeader(prolog + "\n" + header, content);
        }
        return result;
    }
}

