/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.header;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.codehaus.mojo.license.header.FileHeader;
import org.codehaus.mojo.license.header.FileHeaderFilter;
import org.codehaus.mojo.license.header.transformer.FileHeaderTransformer;
import org.nuiton.processor.Processor;
import org.nuiton.processor.filters.Filter;

public class FileHeaderProcessor
extends Processor {
    private final FileHeaderFilter filter;

    public FileHeaderProcessor(FileHeaderFilter filter, FileHeader fileHeader, FileHeaderTransformer transformer) {
        if (filter == null) {
            throw new IllegalStateException("no file header filter set.");
        }
        if (fileHeader == null) {
            throw new IllegalStateException("no file header set.");
        }
        if (transformer == null) {
            throw new IllegalStateException("no file header transformer set.");
        }
        this.filter = filter;
        this.setInputFilter((Filter)filter);
        filter.setFileHeader(fileHeader);
        filter.setTransformer(transformer);
        filter.resetContent();
    }

    public String addHeader(String content) {
        return this.filter.getTransformer().addHeader(this.filter.getFullHeaderContent(), content);
    }

    public boolean isTouched() {
        return this.filter.isTouched();
    }

    public boolean isModified() {
        return this.filter.isModified();
    }

    public boolean isDetectHeader() {
        return this.filter.isDetectHeader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void process(String inputContent, File outputFile, String encoding) throws IOException {
        this.filter.reset();
        try (InputStreamReader input = new InputStreamReader((InputStream)new ByteArrayInputStream(inputContent.getBytes(encoding)), encoding);
             OutputStreamWriter output = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), encoding);){
            this.process(input, output);
        }
    }

    public String getFileHeaderDescription() {
        return this.filter.getFileHeader().getDescription();
    }

    public void updateDescription(String description) {
        this.filter.getFileHeader().setDescription(description);
        this.filter.resetContent();
    }
}

