/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.versions.AbstractVersionsUpdaterMojo;
import org.codehaus.mojo.versions.Property;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

@Mojo(name="set-property", requiresProject=true, requiresDirectInvocation=true)
public class SetPropertyMojo
extends AbstractVersionsUpdaterMojo {
    @Parameter(property="property")
    private String property = null;
    @Parameter(property="newVersion")
    private String newVersion = null;
    @Parameter(property="autoLinkItems", defaultValue="true")
    private boolean autoLinkItems;

    @Override
    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        Property propertyConfig = new Property(this.property);
        propertyConfig.setVersion(this.newVersion);
        Map<Property, PropertyVersions> propertyVersions = this.getHelper().getVersionPropertiesMap(this.getProject(), new Property[]{propertyConfig}, this.property, "", this.autoLinkItems);
        for (Map.Entry<Property, PropertyVersions> entry : propertyVersions.entrySet()) {
            Property property = entry.getKey();
            PropertyVersions version = entry.getValue();
            String currentVersion = this.getProject().getProperties().getProperty(property.getName());
            if (currentVersion == null) continue;
            PomHelper.setPropertyVersion(pom, version.getProfileId(), property.getName(), this.newVersion);
        }
    }
}

