/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.webstart.sign.SignTool;

@Mojo(name="unsign", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true)
public class JarUnsignMojo
extends AbstractMojo {
    @Parameter(property="maven.jar.unsign.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="tempdir", defaultValue="${basedir}", required=true)
    private File tempDirectory;
    @Parameter(alias="jarpath", defaultValue="${project.build.directory}/${project.build.finalName}.${project.packaging}")
    private File jarPath;
    @Parameter(property="verbose", defaultValue="false")
    private boolean verbose;
    @Component
    private SignTool signTool;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)("Skipping JAR unsigning for file: " + this.jarPath.getAbsolutePath()));
            return;
        }
        this.signTool.unsign(this.jarPath, this.verbose);
    }

    public void setJarPath(File jarPath) {
        this.jarPath = jarPath;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setSignTool(SignTool signTool) {
        this.signTool = signTool;
    }
}

