/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart.dependency;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.shared.jarsigner.JarSignerUtil;
import org.codehaus.mojo.webstart.dependency.JnlpDependencyConfig;
import org.codehaus.mojo.webstart.dependency.JnlpDependencyGlobalConfig;
import org.codehaus.mojo.webstart.dependency.JnlpDependencyRequest;
import org.codehaus.mojo.webstart.dependency.JnlpDependencyRequestBuilder;
import org.codehaus.mojo.webstart.dependency.JnlpDependencyRequests;
import org.codehaus.mojo.webstart.dependency.task.JnlpDependencyTask;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=JnlpDependencyRequestBuilder.class, instantiationStrategy="per-lookup")
public class DefaultJnlpDependencyRequestBuilder
extends AbstractLogEnabled
implements JnlpDependencyRequestBuilder,
Contextualizable {
    private PlexusContainer container;
    private JnlpDependencyGlobalConfig globalConfig;

    @Override
    public void init(JnlpDependencyGlobalConfig globalConfig) {
        if (globalConfig == null) {
            throw new NullPointerException("Can't use a null *globalConfig*");
        }
        this.globalConfig = globalConfig;
    }

    @Override
    public JnlpDependencyRequests createRequests() {
        return new JnlpDependencyRequests(this.globalConfig);
    }

    @Override
    public JnlpDependencyRequest createRequest(Artifact artifact, boolean outputJarVersion) {
        if (this.globalConfig == null) {
            throw new IllegalStateException("No config found, use init method before creating a request");
        }
        JnlpDependencyConfig config = this.createConfig(artifact, outputJarVersion);
        JnlpDependencyTask[] tasks = this.createTasks(config);
        JnlpDependencyRequest request = new JnlpDependencyRequest(config, tasks);
        return request;
    }

    private JnlpDependencyConfig createConfig(Artifact artifact, boolean outputJarVersion) {
        String finalName = this.globalConfig.getDependencyFilenameStrategy().getDependencyFileBasename(artifact, false);
        return new JnlpDependencyConfig(this.globalConfig, artifact, finalName, outputJarVersion);
    }

    private JnlpDependencyTask[] createTasks(JnlpDependencyConfig config) {
        ArrayList<JnlpDependencyTask> tasks = new ArrayList<JnlpDependencyTask>();
        boolean doPack200 = config.isPack200();
        if (config.isSign()) {
            if (config.isUnsignAlreadySignedJars()) {
                boolean signed;
                try {
                    signed = JarSignerUtil.isArchiveSigned((File)config.getArtifact().getFile());
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not check if jar is signed", e);
                }
                if (signed && config.isCanUnsign()) {
                    this.registerTask(tasks, "UnsignTask", config);
                }
            }
            if (doPack200) {
                this.registerTask(tasks, "Pack200Task", config);
                this.registerTask(tasks, "UnPack200Task", config);
            }
            if (config.isUpdateManifest()) {
                this.registerTask(tasks, "UpdateManifestTask", config);
            }
            this.registerTask(tasks, "SignTask", config);
        }
        if (doPack200) {
            this.registerTask(tasks, "Pack200Task", config);
        }
        return tasks.toArray(new JnlpDependencyTask[tasks.size()]);
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    protected void setContainer(PlexusContainer container) {
        this.container = container;
    }

    protected <Task extends JnlpDependencyTask> Task registerTask(List<JnlpDependencyTask> tasks, String roleHint, JnlpDependencyConfig config) {
        try {
            JnlpDependencyTask result = (JnlpDependencyTask)this.container.lookup(JnlpDependencyTask.ROLE, roleHint);
            result.check(config);
            tasks.add(result);
            return (Task)result;
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException("Could not find task with roleHint: " + roleHint, e);
        }
    }
}

