/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart.dependency;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.codehaus.mojo.webstart.Pack200Config;
import org.codehaus.mojo.webstart.dependency.filenaming.DependencyFilenameStrategy;
import org.codehaus.mojo.webstart.sign.SignConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JnlpDependencyGlobalConfig {
    private final ClassLoader loader;
    private final File workingDirectory;
    private final File finalDirectory;
    private final Pack200Config pack200;
    private final SignConfig sign;
    private final Map<String, String> updateManifestEntries;
    private final boolean gzip;
    private final boolean verbose;
    private final boolean unsignAlreadySignedJars;
    private final boolean canUnsign;
    private final DependencyFilenameStrategy dependencyFilenameStrategy;

    public JnlpDependencyGlobalConfig(ClassLoader loader, DependencyFilenameStrategy dependencyFilenameStrategy, File workingDirectory, File finalDirectory, Pack200Config pack200, SignConfig sign, Map<String, String> updateManifestEntries, boolean gzip, boolean verbose, boolean unsignAlreadySignedJars, boolean canUnsign) {
        this.loader = loader;
        this.dependencyFilenameStrategy = dependencyFilenameStrategy;
        this.workingDirectory = workingDirectory;
        this.finalDirectory = finalDirectory;
        this.pack200 = pack200;
        this.sign = sign;
        this.updateManifestEntries = Collections.unmodifiableMap(updateManifestEntries);
        this.gzip = gzip;
        this.verbose = verbose;
        this.unsignAlreadySignedJars = unsignAlreadySignedJars;
        this.canUnsign = canUnsign;
    }

    public DependencyFilenameStrategy getDependencyFilenameStrategy() {
        return this.dependencyFilenameStrategy;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public File getFinalDirectory() {
        return this.finalDirectory;
    }

    public List<String> getPack200PassFiles() {
        return this.isPack200() ? this.pack200.getPassFiles() : null;
    }

    public SignConfig getSign() {
        return this.sign;
    }

    public Map<String, String> getUpdateManifestEntries() {
        return this.updateManifestEntries;
    }

    public boolean isGzip() {
        return this.gzip;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isUnsignAlreadySignedJars() {
        return this.unsignAlreadySignedJars;
    }

    public boolean isCanUnsign() {
        return this.canUnsign;
    }

    public boolean isSign() {
        return this.sign != null;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public boolean isUpdateManifest() {
        return MapUtils.isNotEmpty(this.updateManifestEntries);
    }

    public boolean isPack200() {
        return this.pack200 != null && this.pack200.isEnabled();
    }
}

