/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart.generator;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.codehaus.mojo.webstart.JnlpExtension;
import org.codehaus.mojo.webstart.dependency.filenaming.DependencyFilenameStrategy;
import org.codehaus.mojo.webstart.generator.AbstractGeneratorExtraConfigWithDeps;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionGeneratorConfig
extends AbstractGeneratorExtraConfigWithDeps {
    private final Map<JnlpExtension, List<Artifact>> extensionsJnlpArtifacts;
    private final JnlpExtension extension;
    private final String codebase;

    public ExtensionGeneratorConfig(String libPath, boolean pack200, boolean outputJarVersions, Artifact artifactWithMainClass, DependencyFilenameStrategy dependencyFilenameStrategy, Map<JnlpExtension, List<Artifact>> extensionsJnlpArtifacts, String codebase, JnlpExtension extension) {
        super(libPath, pack200, outputJarVersions, artifactWithMainClass, dependencyFilenameStrategy);
        this.extensionsJnlpArtifacts = extensionsJnlpArtifacts;
        this.extension = extension;
        this.codebase = codebase;
    }

    public JnlpExtension getExtension() {
        return this.extension;
    }

    public String getCodebase() {
        return this.codebase;
    }

    public List<Artifact> getExtensionJnlpArtifacts(JnlpExtension extension) {
        return this.extensionsJnlpArtifacts.get(extension);
    }

    @Override
    public String getJnlpSpec() {
        if (this.extension.getSpec() != null) {
            return this.extension.getSpec();
        }
        return "1.0+";
    }

    @Override
    public String getOfflineAllowed() {
        if (this.extension.getOfflineAllowed() != null) {
            return this.extension.getOfflineAllowed();
        }
        return "false";
    }

    @Override
    public String getAllPermissions() {
        if (this.extension.getAllPermissions() != null) {
            return this.extension.getAllPermissions();
        }
        return "true";
    }

    @Override
    public String getJ2seVersion() {
        if (this.extension.getJ2seVersion() != null) {
            return this.extension.getJ2seVersion();
        }
        return "1.5+";
    }

    @Override
    public String getJnlpCodeBase() {
        return this.codebase;
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.emptyMap();
    }
}

