/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.annotations;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.XFireFactory;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.aegis.AegisBindingProvider;
import org.codehaus.xfire.annotations.AnnotationException;
import org.codehaus.xfire.annotations.AnnotationServiceConfiguration;
import org.codehaus.xfire.annotations.WebAnnotations;
import org.codehaus.xfire.annotations.WebServiceAnnotation;
import org.codehaus.xfire.annotations.soap.SOAPBindingAnnotation;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceFactory;
import org.codehaus.xfire.service.binding.BindingProvider;
import org.codehaus.xfire.service.binding.ObjectServiceFactory;
import org.codehaus.xfire.transport.TransportManager;
import org.codehaus.xfire.util.ClassLoaderUtils;
import org.codehaus.xfire.util.NamespaceHelper;
import org.codehaus.xfire.wsdl.ResourceWSDL;

public class AnnotationServiceFactory
extends ObjectServiceFactory
implements ServiceFactory {
    private Log log = LogFactory.getLog((Class)AnnotationServiceFactory.class);
    private WebAnnotations webAnnotations;
    public static final String ALLOW_INTERFACE = "annotations.allow.interface";

    public AnnotationServiceFactory() {
        this(XFireFactory.newInstance().getXFire().getTransportManager());
    }

    public AnnotationServiceFactory(TransportManager transportManager) {
        super(transportManager, new AegisBindingProvider());
        this.webAnnotations = this.getAnnotations();
        AnnotationServiceConfiguration annotationConfig = new AnnotationServiceConfiguration();
        annotationConfig.setWebAnnotations(this.webAnnotations);
        annotationConfig.setServiceFactory(this);
        this.getServiceConfigurations().add(0, annotationConfig);
    }

    public AnnotationServiceFactory(WebAnnotations webAnnotations, TransportManager transportManager) {
        super(transportManager, new AegisBindingProvider());
        this.webAnnotations = webAnnotations;
        AnnotationServiceConfiguration annotationConfig = new AnnotationServiceConfiguration();
        annotationConfig.setWebAnnotations(webAnnotations);
        annotationConfig.setServiceFactory(this);
        this.getServiceConfigurations().add(0, annotationConfig);
    }

    public AnnotationServiceFactory(WebAnnotations webAnnotations, TransportManager transportManager, BindingProvider provider) {
        super(transportManager, provider);
        this.webAnnotations = webAnnotations;
        AnnotationServiceConfiguration annotationConfig = new AnnotationServiceConfiguration();
        annotationConfig.setWebAnnotations(webAnnotations);
        annotationConfig.setServiceFactory(this);
        this.getServiceConfigurations().add(0, annotationConfig);
    }

    protected WebAnnotations getAnnotations() {
        if (!this.isJDK5andAbove()) {
            return this.loadCommonsAttributesAnnotations();
        }
        try {
            WebAnnotations wa = (WebAnnotations)ClassLoaderUtils.loadClass("org.codehaus.xfire.annotations.jsr181.Jsr181WebAnnotations", this.getClass()).newInstance();
            return wa;
        }
        catch (Exception e) {
            return this.loadCommonsAttributesAnnotations();
        }
    }

    private WebAnnotations loadCommonsAttributesAnnotations() {
        try {
            WebAnnotations wa = (WebAnnotations)ClassLoaderUtils.loadClass("org.codehaus.xfire.annotations.commons.CommonsWebAttributes", this.getClass()).newInstance();
            return wa;
        }
        catch (Exception e1) {
            throw new XFireRuntimeException("No WebAnnotation implementation was found!", e1);
        }
    }

    boolean isJDK5andAbove() {
        String v = System.getProperty("java.class.version", "44.0");
        return "49.0".compareTo(v) <= 0;
    }

    public Service create(Class clazz, String name, String namespace, Map properties) {
        String style = null;
        String use = null;
        if (properties == null) {
            properties = new HashMap<String, Object>();
        }
        if (this.webAnnotations.hasWebServiceAnnotation(clazz)) {
            Map props;
            String pname;
            WebServiceAnnotation webServiceAnnotation = this.webAnnotations.getWebServiceAnnotation(clazz);
            this.assertValidImplementationClass(clazz, this.webAnnotations, properties);
            name = this.createServiceName(clazz, webServiceAnnotation, name);
            String portType = null;
            Class endpointInterface = clazz;
            if (webServiceAnnotation.getEndpointInterface() != null && webServiceAnnotation.getEndpointInterface().length() != 0) {
                try {
                    endpointInterface = this.loadClass(webServiceAnnotation.getEndpointInterface());
                    if (!this.webAnnotations.hasWebServiceAnnotation(endpointInterface)) {
                        throw new AnnotationException("Endpoint interface " + endpointInterface.getName() + " does not have a WebService annotation");
                    }
                    WebServiceAnnotation endpointWSAnnotation = this.webAnnotations.getWebServiceAnnotation(endpointInterface);
                    namespace = this.createServiceNamespace(endpointInterface, endpointWSAnnotation, namespace);
                    portType = this.createPortType(name, endpointWSAnnotation);
                }
                catch (ClassNotFoundException e) {
                    throw new AnnotationException("Couldn't find endpoint interface " + webServiceAnnotation.getEndpointInterface(), e);
                }
            } else {
                namespace = this.createServiceNamespace(endpointInterface, webServiceAnnotation, namespace);
                portType = this.createPortType(name, webServiceAnnotation);
            }
            if (this.webAnnotations.hasSOAPBindingAnnotation(endpointInterface)) {
                SOAPBindingAnnotation soapBindingAnnotation = this.webAnnotations.getSOAPBindingAnnotation(endpointInterface);
                style = soapBindingAnnotation.getStyleString();
                use = soapBindingAnnotation.getUseString();
            }
            if (!properties.containsKey("objectServiceFactory.portType")) {
                properties.put("objectServiceFactory.portType", new QName(namespace, portType));
            }
            if (!properties.containsKey("objectServiceFactory.style")) {
                properties.put("objectServiceFactory.style", style);
            }
            if (!properties.containsKey("objectServiceFactory.use")) {
                properties.put("objectServiceFactory.use", use);
            }
            if (!properties.containsKey("objectServiceFactory.portName") && (pname = webServiceAnnotation.getPortName()) != null && pname.length() > 0) {
                properties.put("objectServiceFactory.portName", new QName(namespace, pname));
            }
            if ((props = this.webAnnotations.getServiceProperties(clazz)) != null) {
                properties.putAll(props);
            }
            if (this.webAnnotations.hasHandlerChainAnnotation(clazz)) {
                this.log.error((Object)"@HandlerChain attributes are not supported yet!");
            }
            Service service = super.create(endpointInterface, name, namespace, properties);
            String wsdl = webServiceAnnotation.getWsdlLocation();
            if (wsdl != null && wsdl.length() > 0) {
                try {
                    service.setWSDLWriter(new ResourceWSDL(wsdl));
                }
                catch (IOException e) {
                    throw new AnnotationException("Couldn't load wsdl from " + wsdl, e);
                }
            }
            if (clazz != endpointInterface) {
                service.setProperty("xfire.serviceImplClass", clazz);
            }
            Collection inHandlers = this.webAnnotations.getInHandlers(clazz);
            Collection outHandlers = this.webAnnotations.getOutHandlers(clazz);
            Collection faultHandlers = this.webAnnotations.getFaultHandlers(clazz);
            service.getInHandlers().addAll(this.processHandlers(inHandlers));
            service.getOutHandlers().addAll(this.processHandlers(outHandlers));
            service.getFaultHandlers().addAll(this.processHandlers(faultHandlers));
            return service;
        }
        throw new AnnotationException("Class " + clazz.getName() + " does not have a WebService annotation");
    }

    private Collection processHandlers(Collection handlers) {
        ArrayList handlersObjects = new ArrayList();
        Iterator iter = handlers.iterator();
        while (iter.hasNext()) {
            String handlerClass = (String)iter.next();
            try {
                Class clazz = ClassLoaderUtils.loadClass(handlerClass, this.getClass());
                handlersObjects.add(clazz.newInstance());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Can't load class : " + handlerClass, e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Can't create object of class :" + handlerClass, e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Can't create object of class :" + handlerClass, e);
            }
        }
        return handlersObjects;
    }

    private void assertValidImplementationClass(Class clazz, WebAnnotations webAnnotations2, Map properties) {
        if (Modifier.isFinal(clazz.getModifiers())) {
            throw new AnnotationException("Service class cannot be final: " + clazz.getName());
        }
        if (!Modifier.isPublic(clazz.getModifiers())) {
            throw new AnnotationException("Service class must be an outter public class: " + clazz.getName());
        }
        WebServiceAnnotation wsAnn = webAnnotations2.getWebServiceAnnotation(clazz);
        if (wsAnn.getEndpointInterface().length() > 0) {
            Method[] methods = clazz.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getDeclaringClass().equals(clazz) || !webAnnotations2.hasWebMethodAnnotation(methods[i])) continue;
                throw new AnnotationException("@WebMethod attributes are only allowed on the endpointInterface! Offending class: " + clazz.getName());
            }
        }
    }

    protected Class loadClass(String endpointInterface) throws ClassNotFoundException {
        return ClassLoaderUtils.loadClass(endpointInterface, this.getClass());
    }

    protected String createServiceNamespace(Class clazz, WebServiceAnnotation webServiceAnnotation, String current) {
        String ns = current;
        if (ns == null && webServiceAnnotation.getTargetNamespace().length() > 0) {
            ns = webServiceAnnotation.getTargetNamespace();
        }
        if (ns == null) {
            ns = NamespaceHelper.makeNamespaceFromClassName(clazz.getName(), "http");
        }
        return ns;
    }

    protected String createServiceName(Class clazz, WebServiceAnnotation webServiceAnnotation, String current) {
        String name = current;
        if (name == null && webServiceAnnotation.getServiceName().length() > 0) {
            name = webServiceAnnotation.getServiceName();
        }
        if (name == null) {
            name = this.makeServiceNameFromClassName(clazz);
        }
        return name;
    }

    protected String createPortType(String name, WebServiceAnnotation webServiceAnnotation) {
        String portType = null;
        portType = webServiceAnnotation.getName().length() > 0 ? webServiceAnnotation.getName() : name + "PortType";
        return portType;
    }

    public Service create(Class clazz, QName name, URL wsdlUrl, Map properties) {
        if (properties == null) {
            properties = new HashMap<String, Boolean>();
        }
        properties.put(ALLOW_INTERFACE, Boolean.TRUE);
        return super.create(clazz, name, wsdlUrl, properties);
    }
}

