/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.ScriptRoot;
import org.elasticsearch.painless.WriterConstants;
import org.elasticsearch.painless.lookup.PainlessClassBinding;
import org.elasticsearch.painless.lookup.PainlessInstanceBinding;
import org.elasticsearch.painless.lookup.PainlessMethod;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.SField;
import org.elasticsearch.painless.spi.annotation.NonDeterministicAnnotation;
import org.elasticsearch.painless.symbol.FunctionTable;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public final class ECallLocal
extends AExpression {
    private final String name;
    private final List<AExpression> arguments;
    private FunctionTable.LocalFunction localFunction = null;
    private PainlessMethod importedMethod = null;
    private PainlessClassBinding classBinding = null;
    private int classBindingOffset = 0;
    private PainlessInstanceBinding instanceBinding = null;
    private String bindingName = null;

    public ECallLocal(Location location, String name, List<AExpression> arguments) {
        super(location);
        this.name = Objects.requireNonNull(name);
        this.arguments = Objects.requireNonNull(arguments);
    }

    @Override
    void extractVariables(Set<String> variables) {
        for (AExpression argument : this.arguments) {
            argument.extractVariables(variables);
        }
    }

    @Override
    void analyze(ScriptRoot scriptRoot, Locals locals) {
        ArrayList typeParameters;
        this.localFunction = scriptRoot.getFunctionTable().getFunction(this.name, this.arguments.size());
        if (this.localFunction != null && this.localFunction.isInternal()) {
            this.localFunction = null;
        }
        if (this.localFunction == null) {
            this.importedMethod = scriptRoot.getPainlessLookup().lookupImportedPainlessMethod(this.name, this.arguments.size());
            if (this.importedMethod == null) {
                this.classBinding = scriptRoot.getPainlessLookup().lookupPainlessClassBinding(this.name, this.arguments.size());
                if (this.classBinding != null && !this.classBinding.typeParameters.isEmpty() && this.classBinding.typeParameters.get(0) == scriptRoot.getScriptClassInfo().getBaseClass()) {
                    this.classBinding = null;
                }
                if (this.classBinding == null) {
                    this.classBinding = scriptRoot.getPainlessLookup().lookupPainlessClassBinding(this.name, this.arguments.size() + 1);
                    if (this.classBinding != null) {
                        if (!this.classBinding.typeParameters.isEmpty() && this.classBinding.typeParameters.get(0) == scriptRoot.getScriptClassInfo().getBaseClass()) {
                            this.classBindingOffset = 1;
                        } else {
                            this.classBinding = null;
                        }
                    }
                    if (this.classBinding == null) {
                        this.instanceBinding = scriptRoot.getPainlessLookup().lookupPainlessInstanceBinding(this.name, this.arguments.size());
                        if (this.instanceBinding == null) {
                            throw this.createError(new IllegalArgumentException("Unknown call [" + this.name + "] with [" + this.arguments.size() + "] arguments."));
                        }
                    }
                }
            }
        }
        if (this.localFunction != null) {
            typeParameters = new ArrayList(this.localFunction.getTypeParameters());
            this.actual = this.localFunction.getReturnType();
        } else if (this.importedMethod != null) {
            scriptRoot.markNonDeterministic(this.importedMethod.annotations.containsKey(NonDeterministicAnnotation.class));
            typeParameters = new ArrayList(this.importedMethod.typeParameters);
            this.actual = this.importedMethod.returnType;
        } else if (this.classBinding != null) {
            scriptRoot.markNonDeterministic(this.classBinding.annotations.containsKey(NonDeterministicAnnotation.class));
            typeParameters = new ArrayList(this.classBinding.typeParameters);
            this.actual = this.classBinding.returnType;
            this.bindingName = scriptRoot.getNextSyntheticName("class_binding");
            scriptRoot.getClassNode().addField(new SField(this.location, 2, this.bindingName, this.classBinding.javaConstructor.getDeclaringClass(), null));
        } else if (this.instanceBinding != null) {
            typeParameters = new ArrayList(this.instanceBinding.typeParameters);
            this.actual = this.instanceBinding.returnType;
            this.bindingName = scriptRoot.getNextSyntheticName("instance_binding");
            scriptRoot.getClassNode().addField(new SField(this.location, 9, this.bindingName, this.instanceBinding.targetInstance.getClass(), this.instanceBinding.targetInstance));
        } else {
            throw new IllegalStateException("Illegal tree structure.");
        }
        for (int argument = 0; argument < this.arguments.size(); ++argument) {
            AExpression expression = this.arguments.get(argument);
            expression.expected = (Class)typeParameters.get(argument + this.classBindingOffset);
            expression.internal = true;
            expression.analyze(scriptRoot, locals);
            this.arguments.set(argument, expression.cast(scriptRoot, locals));
        }
        this.statement = true;
    }

    @Override
    void write(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        methodWriter.writeDebugInfo(this.location);
        if (this.localFunction != null) {
            for (AExpression argument : this.arguments) {
                argument.write(classWriter, methodWriter, globals);
            }
            methodWriter.invokeStatic(WriterConstants.CLASS_TYPE, this.localFunction.getAsmMethod());
        } else if (this.importedMethod != null) {
            for (AExpression argument : this.arguments) {
                argument.write(classWriter, methodWriter, globals);
            }
            methodWriter.invokeStatic(Type.getType(this.importedMethod.targetClass), new Method(this.importedMethod.javaMethod.getName(), this.importedMethod.methodType.toMethodDescriptorString()));
        } else if (this.classBinding != null) {
            int argument;
            Type type = Type.getType(this.classBinding.javaConstructor.getDeclaringClass());
            int javaConstructorParameterCount = this.classBinding.javaConstructor.getParameterCount() - this.classBindingOffset;
            Label nonNull = new Label();
            methodWriter.loadThis();
            methodWriter.getField(WriterConstants.CLASS_TYPE, this.bindingName, type);
            methodWriter.ifNonNull(nonNull);
            methodWriter.loadThis();
            methodWriter.newInstance(type);
            methodWriter.dup();
            if (this.classBindingOffset == 1) {
                methodWriter.loadThis();
            }
            for (argument = 0; argument < javaConstructorParameterCount; ++argument) {
                this.arguments.get(argument).write(classWriter, methodWriter, globals);
            }
            methodWriter.invokeConstructor(type, Method.getMethod(this.classBinding.javaConstructor));
            methodWriter.putField(WriterConstants.CLASS_TYPE, this.bindingName, type);
            methodWriter.mark(nonNull);
            methodWriter.loadThis();
            methodWriter.getField(WriterConstants.CLASS_TYPE, this.bindingName, type);
            for (argument = 0; argument < this.classBinding.javaMethod.getParameterCount(); ++argument) {
                this.arguments.get(argument + javaConstructorParameterCount).write(classWriter, methodWriter, globals);
            }
            methodWriter.invokeVirtual(type, Method.getMethod((java.lang.reflect.Method)this.classBinding.javaMethod));
        } else if (this.instanceBinding != null) {
            Type type = Type.getType(this.instanceBinding.targetInstance.getClass());
            methodWriter.loadThis();
            methodWriter.getStatic(WriterConstants.CLASS_TYPE, this.bindingName, type);
            for (int argument = 0; argument < this.instanceBinding.javaMethod.getParameterCount(); ++argument) {
                this.arguments.get(argument).write(classWriter, methodWriter, globals);
            }
            methodWriter.invokeVirtual(type, Method.getMethod((java.lang.reflect.Method)this.instanceBinding.javaMethod));
        } else {
            throw new IllegalStateException("Illegal tree structure.");
        }
    }

    @Override
    public String toString() {
        return this.singleLineToStringWithOptionalArgs(this.arguments, this.name);
    }
}

