/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.fscc;

import java.util.Date;
import jcifs.internal.SMBProtocolDecodingException;
import jcifs.internal.fscc.BasicFileInformation;
import jcifs.internal.util.SMBUtil;
import jcifs.util.Hexdump;

public class FileBasicInfo
implements BasicFileInformation {
    private long createTime;
    private long lastAccessTime;
    private long lastWriteTime;
    private long changeTime;
    private int attributes;

    public FileBasicInfo() {
    }

    public FileBasicInfo(long create, long lastAccess, long lastWrite, long change, int attributes) {
        this.createTime = create;
        this.lastAccessTime = lastAccess;
        this.lastWriteTime = lastWrite;
        this.changeTime = change;
        this.attributes = attributes;
    }

    @Override
    public byte getFileInformationLevel() {
        return 4;
    }

    @Override
    public int getAttributes() {
        return this.attributes;
    }

    @Override
    public long getCreateTime() {
        return this.createTime;
    }

    @Override
    public long getLastWriteTime() {
        return this.lastWriteTime;
    }

    @Override
    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public long getSize() {
        return 0L;
    }

    @Override
    public int decode(byte[] buffer, int bufferIndex, int len) throws SMBProtocolDecodingException {
        int start = bufferIndex;
        this.createTime = SMBUtil.readTime(buffer, bufferIndex);
        this.lastAccessTime = SMBUtil.readTime(buffer, bufferIndex += 8);
        this.lastWriteTime = SMBUtil.readTime(buffer, bufferIndex += 8);
        this.changeTime = SMBUtil.readTime(buffer, bufferIndex += 8);
        this.attributes = SMBUtil.readInt4(buffer, bufferIndex += 8);
        return (bufferIndex += 4) - start;
    }

    @Override
    public int size() {
        return 40;
    }

    @Override
    public int encode(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SMBUtil.writeTime(this.createTime, dst, dstIndex);
        SMBUtil.writeTime(this.lastAccessTime, dst, dstIndex += 8);
        SMBUtil.writeTime(this.lastWriteTime, dst, dstIndex += 8);
        SMBUtil.writeTime(this.changeTime, dst, dstIndex += 8);
        SMBUtil.writeInt4(this.attributes, dst, dstIndex += 8);
        dstIndex += 4;
        return (dstIndex += 4) - start;
    }

    public String toString() {
        return new String("SmbQueryFileBasicInfo[createTime=" + new Date(this.createTime) + ",lastAccessTime=" + new Date(this.lastAccessTime) + ",lastWriteTime=" + new Date(this.lastWriteTime) + ",changeTime=" + new Date(this.changeTime) + ",attributes=0x" + Hexdump.toHexString(this.attributes, 4) + "]");
    }
}

