/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb1.com;

import jcifs.CIFSContext;
import jcifs.Configuration;
import jcifs.internal.Request;
import jcifs.internal.smb1.SMB1SigningDigest;
import jcifs.internal.smb1.ServerMessageBlock;
import jcifs.internal.smb1.com.SmbComBlankResponse;
import jcifs.internal.util.SMBUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmbComClose
extends ServerMessageBlock
implements Request<SmbComBlankResponse> {
    private static final Logger log = LoggerFactory.getLogger(SmbComClose.class);
    private int fid;
    private long lastWriteTime;

    public SmbComClose(Configuration config, int fid, long lastWriteTime) {
        super(config, (byte)4);
        this.fid = fid;
        this.lastWriteTime = lastWriteTime;
    }

    @Override
    public final SmbComBlankResponse getResponse() {
        return (SmbComBlankResponse)super.getResponse();
    }

    @Override
    public SmbComBlankResponse initResponse(CIFSContext tc) {
        SmbComBlankResponse resp = new SmbComBlankResponse(tc.getConfig());
        this.setResponse(resp);
        return resp;
    }

    @Override
    protected int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        SMBUtil.writeInt2(this.fid, dst, dstIndex);
        dstIndex += 2;
        if (this.digest != null) {
            SMB1SigningDigest.writeUTime(this.getConfig(), this.lastWriteTime, dst, dstIndex);
        } else {
            log.trace("SmbComClose without a digest");
        }
        return 6;
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    public String toString() {
        return new String("SmbComClose[" + super.toString() + ",fid=" + this.fid + ",lastWriteTime=" + this.lastWriteTime + "]");
    }
}

