/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import jcifs.CIFSException;
import jcifs.ResourceNameFilter;
import jcifs.SmbResource;
import jcifs.SmbResourceLocator;
import jcifs.internal.CommonServerMessageBlockRequest;
import jcifs.internal.smb1.com.SmbComBlankResponse;
import jcifs.internal.smb1.com.SmbComFindClose2;
import jcifs.internal.smb1.trans2.Trans2FindFirst2;
import jcifs.internal.smb1.trans2.Trans2FindFirst2Response;
import jcifs.internal.smb1.trans2.Trans2FindNext2;
import jcifs.smb.DirFileEntryEnumIteratorBase;
import jcifs.smb.FileEntry;
import jcifs.smb.RequestParam;
import jcifs.smb.SmbException;
import jcifs.smb.SmbTreeHandleImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DirFileEntryEnumIterator1
extends DirFileEntryEnumIteratorBase {
    private static final Logger log = LoggerFactory.getLogger(DirFileEntryEnumIterator1.class);
    private Trans2FindNext2 nextRequest;
    private Trans2FindFirst2Response response;

    public DirFileEntryEnumIterator1(SmbTreeHandleImpl th, SmbResource parent, String wildcard, ResourceNameFilter filter, int searchAttributes) throws CIFSException {
        super(th, parent, wildcard, filter, searchAttributes);
    }

    @Override
    protected final FileEntry open() throws CIFSException {
        SmbResourceLocator loc = this.getParent().getLocator();
        String unc = loc.getUNCPath();
        String p = loc.getURL().getPath();
        if (p.lastIndexOf(47) != p.length() - 1) {
            throw new SmbException(loc.getURL() + " directory must end with '/'");
        }
        if (unc.lastIndexOf(92) != unc.length() - 1) {
            throw new SmbException(unc + " UNC must end with '\\'");
        }
        SmbTreeHandleImpl th = this.getTreeHandle();
        this.response = new Trans2FindFirst2Response(th.getConfig());
        try {
            th.send((CommonServerMessageBlockRequest)new Trans2FindFirst2(th.getConfig(), unc, this.getWildcard(), this.getSearchAttributes(), th.getConfig().getListCount(), th.getConfig().getListSize()), this.response, new RequestParam[0]);
            this.nextRequest = new Trans2FindNext2(th.getConfig(), this.response.getSid(), this.response.getResumeKey(), this.response.getLastName(), th.getConfig().getListCount(), th.getConfig().getListSize());
        }
        catch (SmbException e) {
            if (this.response != null && this.response.isReceived() && e.getNtStatus() == -1073741809) {
                this.doClose();
                return null;
            }
            throw e;
        }
        this.response.setSubCommand((byte)2);
        FileEntry n = this.advance(false);
        if (n == null) {
            this.doClose();
        }
        return n;
    }

    @Override
    protected FileEntry[] getResults() {
        return this.response.getResults();
    }

    @Override
    protected boolean fetchMore() throws CIFSException {
        this.nextRequest.reset(this.response.getResumeKey(), this.response.getLastName());
        this.response.reset();
        try {
            this.getTreeHandle().send((CommonServerMessageBlockRequest)this.nextRequest, this.response, new RequestParam[0]);
            return this.response.getStatus() != -2147483642;
        }
        catch (SmbException e) {
            if (e.getNtStatus() == -2147483642) {
                log.debug("No more entries", (Throwable)e);
                return false;
            }
            throw e;
        }
    }

    @Override
    protected boolean isDone() {
        return this.response.isEndOfSearch();
    }

    @Override
    protected void doCloseInternal() throws CIFSException {
        try {
            SmbTreeHandleImpl th = this.getTreeHandle();
            if (this.response != null) {
                th.send((CommonServerMessageBlockRequest)new SmbComFindClose2(th.getConfig(), this.response.getSid()), new SmbComBlankResponse(th.getConfig()), new RequestParam[0]);
            }
        }
        catch (SmbException se) {
            log.debug("SmbComFindClose2 failed", (Throwable)se);
        }
    }
}

