/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.dtyp;

import java.io.IOException;
import jcifs.internal.SMBProtocolDecodingException;
import jcifs.internal.dtyp.ACE;
import jcifs.internal.dtyp.SecurityInfo;
import jcifs.internal.util.SMBUtil;
import jcifs.smb.SID;

public class SecurityDescriptor
implements SecurityInfo {
    private int type;
    private ACE[] aces;
    private SID ownerUserSid;
    private SID ownerGroupSid;

    public SecurityDescriptor() {
    }

    public SecurityDescriptor(byte[] buffer, int bufferIndex, int len) throws IOException {
        this.decode(buffer, bufferIndex, len);
    }

    public final int getType() {
        return this.type;
    }

    public final ACE[] getAces() {
        return this.aces;
    }

    public final SID getOwnerGroupSid() {
        return this.ownerGroupSid;
    }

    public final SID getOwnerUserSid() {
        return this.ownerUserSid;
    }

    @Override
    public int decode(byte[] buffer, int bufferIndex, int len) throws SMBProtocolDecodingException {
        int start = bufferIndex++;
        this.type = SMBUtil.readInt2(buffer, ++bufferIndex);
        int ownerUOffset = SMBUtil.readInt4(buffer, bufferIndex += 2);
        int ownerGOffset = SMBUtil.readInt4(buffer, bufferIndex += 4);
        SMBUtil.readInt4(buffer, bufferIndex += 4);
        int daclOffset = SMBUtil.readInt4(buffer, bufferIndex += 4);
        if (ownerUOffset > 0) {
            bufferIndex = start + ownerUOffset;
            this.ownerUserSid = new SID(buffer, bufferIndex);
            bufferIndex += 8 + 4 * this.ownerUserSid.sub_authority_count;
        }
        if (ownerGOffset > 0) {
            bufferIndex = start + ownerGOffset;
            this.ownerGroupSid = new SID(buffer, bufferIndex);
            bufferIndex += 8 + 4 * this.ownerGroupSid.sub_authority_count;
        }
        bufferIndex = start + daclOffset;
        if (daclOffset > 0) {
            ++bufferIndex;
            SMBUtil.readInt2(buffer, ++bufferIndex);
            int numAces = SMBUtil.readInt4(buffer, bufferIndex += 2);
            bufferIndex += 4;
            if (numAces > 4096) {
                throw new SMBProtocolDecodingException("Invalid SecurityDescriptor");
            }
            this.aces = new ACE[numAces];
            for (int i = 0; i < numAces; ++i) {
                this.aces[i] = new ACE();
                bufferIndex += this.aces[i].decode(buffer, bufferIndex, len - bufferIndex);
            }
        } else {
            this.aces = null;
        }
        return bufferIndex - start;
    }

    public String toString() {
        String ret = "SecurityDescriptor:\n";
        if (this.aces != null) {
            for (int ai = 0; ai < this.aces.length; ++ai) {
                ret = ret + this.aces[ai].toString() + "\n";
            }
        } else {
            ret = ret + "NULL";
        }
        return ret;
    }
}

