/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb1.com;

import jcifs.Configuration;
import jcifs.internal.smb1.ServerMessageBlock;
import jcifs.internal.util.SMBUtil;

public class SmbComSetInformation
extends ServerMessageBlock {
    private int fileAttributes;
    private long lastWriteTime;

    public SmbComSetInformation(Configuration config, String filename, int attrs, long mtime) {
        super(config, (byte)9, filename);
        this.fileAttributes = attrs;
        this.lastWriteTime = mtime;
    }

    @Override
    protected int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SMBUtil.writeInt2(this.fileAttributes, dst, dstIndex);
        SMBUtil.writeUTime(this.lastWriteTime, dst, dstIndex += 2);
        dstIndex += 4;
        int len = (dstIndex += 10) - start;
        return len;
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        dst[dstIndex++] = 4;
        dstIndex += this.writeString(this.path, dst, dstIndex);
        return dstIndex - start;
    }

    @Override
    protected int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    public String toString() {
        return new String("SmbComSetInformation[" + super.toString() + ",filename=" + this.path + ",fileAttributes=" + this.fileAttributes + ",lastWriteTime=" + this.lastWriteTime + "]");
    }
}

