/* The following code was generated by JFlex 1.4.1 on 8/2/06 6:03 AM */

/*
 * Copyright 2000-2006 Omnicore Software, Hans Kratz & Dennis Strein GbR,
 *                     Geert Bevin <gbevin[remove] at uwyn dot com>.
 * Distributed under the terms of either:
 * - the common development and distribution license (CDDL), v1.0; or
 * - the GNU Lesser General Public License, v2.1 or later
 * $Id: XmlHighlighter.java 3431 2006-08-02 04:09:28Z gbevin $
 */
package com.uwyn.jhighlight.highlighter;

import java.io.Reader;
import java.io.IOException;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1
 * on 8/2/06 6:03 AM from the specification file
 * <tt>com/uwyn/jhighlight/highlighter/XmlHighlighter.flex</tt>
 */
public class XmlHighlighter implements ExplicitStateHighlighter {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 128;

  /** lexical states */
  public static final int TAG_START = 9;
  public static final int IN_CDATA_SECTION = 14;
  public static final int IN_RIFE_NAME_QUOTED = 6;
  public static final int IN_SINGLE_QUOTE_STRING = 11;
  public static final int IN_RIFE_TAG_REGULAR = 4;
  public static final int IN_PROCESSING_INSTRUCTION = 13;
  public static final int IN_DOUBLE_QUOTE_STRING = 12;
  public static final int IN_RIFE_NAME = 7;
  public static final int IN_TAG = 10;
  public static final int IN_RIFE_NAME_SINGLEQUOTED = 5;
  public static final int IN_RIFE_TAG_VELOCITY = 3;
  public static final int IN_COMMENT = 8;
  public static final int YYINITIAL = 0;
  public static final int IN_RIFE_TAG_COMMENT = 1;
  public static final int IN_RIFE_TAG_COMPACT = 2;

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\3\1\40\1\34\1\0\1\1\1\2\16\3\4\0\1\1\1\10"+
    "\1\37\1\0\1\20\2\0\1\36\5\0\1\4\1\3\1\15\12\3"+
    "\1\6\1\0\1\7\1\35\1\14\1\27\1\0\1\32\1\12\1\30"+
    "\1\31\4\5\1\13\12\5\1\33\1\5\1\11\4\5\1\16\1\0"+
    "\1\17\1\0\1\5\1\0\1\5\1\23\6\5\1\24\10\5\1\26"+
    "\1\41\2\5\1\22\4\5\1\21\1\0\1\25\1\0\41\3\2\0"+
    "\4\5\4\0\1\5\2\0\1\3\7\0\1\5\4\0\1\5\5\0"+
    "\27\5\1\0\37\5\1\0\u013f\5\31\0\162\5\4\0\14\5\16\0"+
    "\5\5\11\0\1\5\21\0\130\3\5\0\23\3\12\0\1\5\13\0"+
    "\1\5\1\0\3\5\1\0\1\5\1\0\24\5\1\0\54\5\1\0"+
    "\46\5\1\0\5\5\4\0\202\5\1\0\4\3\3\0\105\5\1\0"+
    "\46\5\2\0\2\5\6\0\20\5\41\0\46\5\2\0\1\5\7\0"+
    "\47\5\11\0\21\3\1\0\27\3\1\0\3\3\1\0\1\3\1\0"+
    "\2\3\1\0\1\3\13\0\33\5\5\0\3\5\15\0\4\3\14\0"+
    "\6\3\13\0\32\5\5\0\13\5\16\3\7\0\12\3\4\0\2\5"+
    "\1\3\143\5\1\0\1\5\10\3\1\0\6\3\2\5\2\3\1\0"+
    "\4\3\2\5\12\3\3\5\2\0\1\5\17\0\1\3\1\5\1\3"+
    "\36\5\33\3\2\0\3\5\60\0\46\5\13\3\1\5\u014f\0\3\3"+
    "\66\5\2\0\1\3\1\5\20\3\2\0\1\5\4\3\3\0\12\5"+
    "\2\3\2\0\12\3\21\0\3\3\1\0\10\5\2\0\2\5\2\0"+
    "\26\5\1\0\7\5\1\0\1\5\3\0\4\5\2\0\1\3\1\5"+
    "\7\3\2\0\2\3\2\0\3\3\11\0\1\3\4\0\2\5\1\0"+
    "\3\5\2\3\2\0\12\3\4\5\15\0\3\3\1\0\6\5\4\0"+
    "\2\5\2\0\26\5\1\0\7\5\1\0\2\5\1\0\2\5\1\0"+
    "\2\5\2\0\1\3\1\0\5\3\4\0\2\3\2\0\3\3\13\0"+
    "\4\5\1\0\1\5\7\0\14\3\3\5\14\0\3\3\1\0\11\5"+
    "\1\0\3\5\1\0\26\5\1\0\7\5\1\0\2\5\1\0\5\5"+
    "\2\0\1\3\1\5\10\3\1\0\3\3\1\0\3\3\2\0\1\5"+
    "\17\0\2\5\2\3\2\0\12\3\1\0\1\5\17\0\3\3\1\0"+
    "\10\5\2\0\2\5\2\0\26\5\1\0\7\5\1\0\2\5\1\0"+
    "\5\5\2\0\1\3\1\5\6\3\3\0\2\3\2\0\3\3\10\0"+
    "\2\3\4\0\2\5\1\0\3\5\4\0\12\3\1\0\1\5\20\0"+
    "\1\3\1\5\1\0\6\5\3\0\3\5\1\0\4\5\3\0\2\5"+
    "\1\0\1\5\1\0\2\5\3\0\2\5\3\0\3\5\3\0\10\5"+
    "\1\0\3\5\4\0\5\3\3\0\3\3\1\0\4\3\11\0\1\3"+
    "\17\0\11\3\11\0\1\5\7\0\3\3\1\0\10\5\1\0\3\5"+
    "\1\0\27\5\1\0\12\5\1\0\5\5\4\0\7\3\1\0\3\3"+
    "\1\0\4\3\7\0\2\3\11\0\2\5\4\0\12\3\22\0\2\3"+
    "\1\0\10\5\1\0\3\5\1\0\27\5\1\0\12\5\1\0\5\5"+
    "\2\0\1\3\1\5\7\3\1\0\3\3\1\0\4\3\7\0\2\3"+
    "\7\0\1\5\1\0\2\5\4\0\12\3\22\0\2\3\1\0\10\5"+
    "\1\0\3\5\1\0\27\5\1\0\20\5\4\0\6\3\2\0\3\3"+
    "\1\0\4\3\11\0\1\3\10\0\2\5\4\0\12\3\22\0\2\3"+
    "\1\0\22\5\3\0\30\5\1\0\11\5\1\0\1\5\2\0\7\5"+
    "\3\0\1\3\4\0\6\3\1\0\1\3\1\0\10\3\22\0\2\3"+
    "\15\0\60\5\1\3\2\5\7\3\4\0\10\5\10\3\1\0\12\3"+
    "\47\0\2\5\1\0\1\5\2\0\2\5\1\0\1\5\2\0\1\5"+
    "\6\0\4\5\1\0\7\5\1\0\3\5\1\0\1\5\1\0\1\5"+
    "\2\0\2\5\1\0\4\5\1\3\2\5\6\3\1\0\2\3\1\5"+
    "\2\0\5\5\1\0\1\5\1\0\6\3\2\0\12\3\2\0\2\5"+
    "\42\0\1\5\27\0\2\3\6\0\12\3\13\0\1\3\1\0\1\3"+
    "\1\0\1\3\4\0\2\3\10\5\1\0\42\5\6\0\24\3\1\0"+
    "\2\3\4\5\4\0\10\3\1\0\44\3\11\0\1\3\71\0\42\5"+
    "\1\0\5\5\1\0\2\5\1\0\7\3\3\0\4\3\6\0\12\3"+
    "\6\0\6\5\4\3\106\0\46\5\12\0\51\5\7\0\132\5\5\0"+
    "\104\5\5\0\122\5\6\0\7\5\1\0\77\5\1\0\1\5\1\0"+
    "\4\5\2\0\7\5\1\0\1\5\1\0\4\5\2\0\47\5\1\0"+
    "\1\5\1\0\4\5\2\0\37\5\1\0\1\5\1\0\4\5\2\0"+
    "\7\5\1\0\1\5\1\0\4\5\2\0\7\5\1\0\7\5\1\0"+
    "\27\5\1\0\37\5\1\0\1\5\1\0\4\5\2\0\7\5\1\0"+
    "\47\5\1\0\23\5\16\0\11\3\56\0\125\5\14\0\u026c\5\2\0"+
    "\10\5\12\0\32\5\5\0\113\5\3\0\3\5\17\0\15\5\1\0"+
    "\4\5\3\3\13\0\22\5\3\3\13\0\22\5\2\3\14\0\15\5"+
    "\1\0\3\5\1\0\2\3\14\0\64\5\40\3\3\0\1\5\3\0"+
    "\2\5\1\3\2\0\12\3\41\0\3\3\2\0\12\3\6\0\130\5"+
    "\10\0\51\5\1\3\126\0\35\5\3\0\14\3\4\0\14\3\12\0"+
    "\12\3\36\5\2\0\5\5\u038b\0\154\5\224\0\234\5\4\0\132\5"+
    "\6\0\26\5\2\0\6\5\2\0\46\5\2\0\6\5\2\0\10\5"+
    "\1\0\1\5\1\0\1\5\1\0\1\5\1\0\37\5\2\0\65\5"+
    "\1\0\7\5\1\0\1\5\3\0\3\5\1\0\7\5\3\0\4\5"+
    "\2\0\6\5\4\0\15\5\5\0\3\5\1\0\7\5\17\0\4\3"+
    "\32\0\5\3\20\0\2\5\23\0\1\5\13\0\4\3\6\0\6\3"+
    "\1\0\1\5\15\0\1\5\40\0\22\5\36\0\15\3\4\0\1\3"+
    "\3\0\6\3\27\0\1\5\4\0\1\5\2\0\12\5\1\0\1\5"+
    "\3\0\5\5\6\0\1\5\1\0\1\5\1\0\1\5\1\0\4\5"+
    "\1\0\3\5\1\0\7\5\3\0\3\5\5\0\5\5\26\0\44\5"+
    "\u0e81\0\3\5\31\0\11\5\6\3\1\0\5\5\2\0\5\5\4\0"+
    "\126\5\2\0\2\3\2\0\3\5\1\0\137\5\5\0\50\5\4\0"+
    "\136\5\21\0\30\5\70\0\20\5\u0200\0\u19b6\5\112\0\u51a6\5\132\0"+
    "\u048d\5\u0773\0\u2ba4\5\u215c\0\u012e\5\2\0\73\5\225\0\7\5\14\0"+
    "\5\5\5\0\1\5\1\3\12\5\1\0\15\5\1\0\5\5\1\0"+
    "\1\5\1\0\2\5\1\0\2\5\1\0\154\5\41\0\u016b\5\22\0"+
    "\100\5\2\0\66\5\50\0\15\5\3\0\20\3\20\0\4\3\17\0"+
    "\2\5\30\0\3\5\31\0\1\5\6\0\5\5\1\0\207\5\2\0"+
    "\1\3\4\0\1\5\13\0\12\3\7\0\32\5\4\0\1\5\1\0"+
    "\32\5\12\0\132\5\3\0\6\5\2\0\6\5\2\0\6\5\2\0"+
    "\3\5\3\0\2\5\3\0\2\5\22\0\3\3\4\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\1\2\2\1\3\1\2\3\0\1\4\2\0\2\5"+
    "\1\0\1\6\2\1\1\7\2\1\3\2\1\10\1\2"+
    "\1\11\2\3\1\2\1\12\1\13\1\14\1\13\2\4"+
    "\1\15\1\16\1\17\1\20\2\1\1\20\1\21\1\22"+
    "\1\23\1\5\2\24\3\5\1\25\2\5\2\1\1\26"+
    "\2\6\1\0\1\7\1\0\1\27\10\0\1\30\16\0"+
    "\1\31\1\0\1\32\1\33\4\0\1\34\4\0\1\35"+
    "\10\0\1\36\1\37\7\0\1\40";

  private static int [] zzUnpackAction() {
    int [] result = new int[118];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\42\0\104\0\146\0\210\0\252\0\314\0\356"+
    "\0\u0110\0\u0132\0\u0154\0\u0176\0\u0198\0\u01ba\0\u01dc\0\u01fe"+
    "\0\u0220\0\u0242\0\u0264\0\u0286\0\u02a8\0\u02ca\0\u01fe\0\u01fe"+
    "\0\u02ec\0\u01fe\0\u030e\0\u0330\0\u0352\0\u01fe\0\u01fe\0\u01fe"+
    "\0\u0374\0\u0396\0\u03b8\0\u01fe\0\u03da\0\u01fe\0\u03fc\0\u041e"+
    "\0\u0440\0\u0462\0\u01fe\0\u01fe\0\u01fe\0\u0484\0\u041e\0\u01fe"+
    "\0\u0264\0\u01fe\0\u04a6\0\u01fe\0\u04c8\0\u04ea\0\u050c\0\u052e"+
    "\0\u01fe\0\u0550\0\u0572\0\u0594\0\u05b6\0\u05d8\0\u01fe\0\u05fa"+
    "\0\u061c\0\u063e\0\u0660\0\u0682\0\u05b6\0\u050c\0\u052e\0\u01fe"+
    "\0\u06a4\0\u06c6\0\u06e8\0\u070a\0\u072c\0\u074e\0\u0770\0\u0792"+
    "\0\u07b4\0\u07d6\0\u07f8\0\u081a\0\u083c\0\u085e\0\u01fe\0\u0880"+
    "\0\u01fe\0\u08a2\0\u08c4\0\u08e6\0\u0908\0\u092a\0\u01fe\0\u094c"+
    "\0\u096e\0\u0990\0\u09b2\0\u01fe\0\u08a2\0\u09d4\0\u09f6\0\u0a18"+
    "\0\u0a3a\0\u0a5c\0\u0a7e\0\u0aa0\0\u01fe\0\u01fe\0\u0ac2\0\u0ae4"+
    "\0\u0b06\0\u0b28\0\u0b4a\0\u0b6c\0\u0b8e\0\u01fe";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[118];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\20\1\21\5\20\1\22\6\20\1\23\1\20\1\24"+
    "\17\20\1\21\1\20\4\25\1\26\7\25\1\27\21\25"+
    "\1\30\3\25\17\31\1\32\16\31\1\30\3\31\15\33"+
    "\1\34\7\33\1\32\12\33\2\27\14\35\1\32\22\35"+
    "\1\36\2\35\34\37\1\20\1\37\1\40\37\37\1\20"+
    "\2\37\1\40\17\37\1\41\7\37\1\32\6\37\1\20"+
    "\5\37\4\42\1\43\27\42\1\20\5\42\5\44\2\45"+
    "\2\44\3\45\1\46\3\44\1\45\1\44\3\45\1\44"+
    "\1\45\1\44\4\45\1\20\4\44\1\45\5\20\2\47"+
    "\1\50\1\20\3\47\1\46\1\51\1\23\1\20\1\52"+
    "\1\20\3\47\1\20\1\47\1\20\4\47\1\20\1\53"+
    "\1\54\1\55\1\20\1\47\7\56\1\57\4\56\1\60"+
    "\1\56\1\61\1\62\1\63\1\62\3\56\1\62\6\56"+
    "\1\62\1\56\1\64\3\56\7\65\1\57\4\65\1\60"+
    "\1\65\1\61\1\62\1\66\1\62\3\65\1\62\6\65"+
    "\1\62\2\65\1\64\2\65\27\67\1\70\4\67\1\71"+
    "\5\67\17\72\1\73\14\72\1\20\5\72\43\0\1\21"+
    "\36\0\1\21\11\0\1\74\4\0\1\75\10\0\1\76"+
    "\1\77\22\0\1\100\52\0\1\101\20\0\4\25\1\0"+
    "\7\25\1\0\21\25\1\0\3\25\4\0\1\102\35\0"+
    "\17\31\1\0\16\31\1\0\3\31\25\33\1\0\12\33"+
    "\2\0\25\33\1\32\12\33\2\0\14\35\1\0\22\35"+
    "\1\0\2\35\25\0\1\32\14\0\4\42\1\0\27\42"+
    "\1\0\5\42\4\0\1\103\40\0\4\45\2\0\3\45"+
    "\4\0\1\45\1\0\3\45\1\0\1\45\1\0\4\45"+
    "\5\0\1\45\3\0\4\47\2\0\3\47\4\0\1\47"+
    "\1\0\3\47\1\0\1\47\1\0\4\47\5\0\1\47"+
    "\10\0\1\104\4\0\1\105\10\0\1\76\27\0\1\46"+
    "\30\0\4\47\2\0\3\47\4\0\1\47\1\101\3\47"+
    "\1\0\1\47\1\0\4\47\5\0\1\47\7\56\1\0"+
    "\4\56\1\0\1\56\2\0\1\56\1\0\3\56\1\0"+
    "\6\56\1\0\1\56\1\0\12\56\1\0\4\56\1\0"+
    "\1\56\2\0\1\56\1\101\3\56\1\0\6\56\1\0"+
    "\1\56\1\0\3\56\7\65\1\0\4\65\1\0\1\65"+
    "\2\0\1\65\1\0\3\65\1\0\6\65\1\0\2\65"+
    "\1\0\11\65\1\0\4\65\1\0\1\65\2\0\1\65"+
    "\1\101\3\65\1\0\6\65\1\0\2\65\1\0\2\65"+
    "\27\106\1\107\4\106\1\71\21\106\1\110\12\106\1\111"+
    "\4\106\1\71\5\106\17\72\1\0\14\72\1\0\5\72"+
    "\17\0\1\112\26\0\1\113\11\0\1\114\51\0\1\115"+
    "\21\0\1\116\34\0\2\117\6\0\1\120\1\121\1\120"+
    "\1\0\1\122\16\0\1\117\3\0\1\117\2\0\2\123"+
    "\12\0\1\124\4\0\1\125\1\126\1\125\7\0\1\123"+
    "\3\0\1\123\15\0\1\32\41\0\1\127\31\0\1\130"+
    "\35\0\14\106\1\110\12\106\1\111\4\106\1\0\5\106"+
    "\14\0\1\131\31\0\1\132\65\0\1\133\17\0\1\134"+
    "\55\0\1\135\1\136\1\135\16\0\2\117\6\0\1\120"+
    "\1\121\1\120\20\0\1\117\3\0\1\117\2\0\1\137"+
    "\36\0\1\137\2\0\1\137\7\0\1\120\26\0\1\137"+
    "\2\0\2\122\6\0\1\140\1\141\21\0\1\122\3\0"+
    "\1\122\2\0\2\123\17\0\1\125\1\126\1\125\7\0"+
    "\1\123\3\0\1\123\2\0\2\124\17\0\1\142\1\143"+
    "\10\0\1\124\3\0\1\124\2\0\1\144\36\0\1\144"+
    "\2\0\1\144\20\0\1\125\15\0\1\144\5\0\1\145"+
    "\36\0\2\146\6\0\1\147\1\150\1\147\1\0\1\151"+
    "\16\0\1\146\3\0\1\146\32\0\1\152\32\0\1\153"+
    "\1\154\17\0\1\155\36\0\1\155\2\0\1\155\20\0"+
    "\1\135\15\0\1\155\2\0\2\140\14\0\1\27\14\0"+
    "\1\140\3\0\1\140\2\0\2\140\6\0\1\140\5\0"+
    "\1\27\14\0\1\140\3\0\1\140\2\0\2\142\22\0"+
    "\1\27\6\0\1\142\3\0\1\142\2\0\2\142\17\0"+
    "\1\142\2\0\1\27\6\0\1\142\3\0\1\142\2\0"+
    "\2\146\6\0\1\147\1\150\1\147\20\0\1\146\3\0"+
    "\1\146\2\0\1\156\36\0\1\156\2\0\1\156\7\0"+
    "\1\147\26\0\1\156\2\0\2\151\6\0\1\157\1\160"+
    "\21\0\1\151\3\0\1\151\33\0\1\161\10\0\1\153"+
    "\12\0\1\27\23\0\1\153\2\0\1\153\12\0\1\27"+
    "\5\0\1\153\15\0\1\153\2\0\2\157\1\0\1\162"+
    "\27\0\1\157\3\0\1\157\2\0\2\157\1\0\1\162"+
    "\4\0\1\157\22\0\1\157\3\0\1\157\34\0\1\163"+
    "\12\0\1\164\67\0\1\165\23\0\1\27\43\0\1\166"+
    "\23\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[2992];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\5\1\3\0\1\1\2\0\2\1\1\0\1\1\1\11"+
    "\6\1\2\11\1\1\1\11\3\1\3\11\3\1\1\11"+
    "\1\1\1\11\4\1\3\11\2\1\1\11\1\1\1\11"+
    "\1\1\1\11\4\1\1\11\2\1\1\0\1\1\1\0"+
    "\1\11\10\0\1\11\16\0\1\11\1\0\1\11\1\1"+
    "\4\0\1\11\4\0\1\11\10\0\2\11\7\0\1\11";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[118];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the textposition at the last state to be included in yytext */
  private int zzPushbackPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */
	/* styles */
	
	public static final byte PLAIN_STYLE = 1;
	public static final byte CHAR_DATA = 2;
	public static final byte TAG_SYMBOLS = 3;
	public static final byte COMMENT = 4;
	public static final byte ATTRIBUTE_VALUE = 5;
	public static final byte ATTRIBUTE_NAME = 6;
	public static final byte PROCESSING_INSTRUCTION = 7;
	public static final byte TAG_NAME = 8;
	public static final byte RIFE_TAG = 9;
	public static final byte RIFE_NAME = 10;

	/* Highlighter implementation */
	
	public int getStyleCount()
	{
		return 10;
	}
	
	public byte getStartState()
	{
		return YYINITIAL+1;
	}
	
	public byte getCurrentState()
	{
		return (byte) (yystate()+1);
	}
	
	public void setState(byte newState)
	{
		yybegin(newState-1);
	}
	
	public byte getNextToken()
	{
		try
		{
			return (byte) yylex();
		}
		catch (IOException e)
		{
			throw new InternalError();
		}
	}
	
	public int getTokenLength()
	{
		return yylength();
	}
	
	public void setReader(Reader r)
	{
		this.zzReader = r;
	}

	public XmlHighlighter()
	{
	}
	
	private int mReturningState;
	private int mReturningStateTag;


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public XmlHighlighter(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public XmlHighlighter(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 1736) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzPushbackPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead < 0) {
      return true;
    }
    else {
      zzEndRead+= numRead;
      return false;
    }
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = zzPushbackPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public int yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = zzLexicalState;


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 27: 
          { yybegin(IN_COMMENT); return COMMENT;
          }
        case 33: break;
        case 5: 
          { return ATTRIBUTE_VALUE;
          }
        case 34: break;
        case 4: 
          { return COMMENT;
          }
        case 35: break;
        case 21: 
          { yybegin(IN_TAG); return ATTRIBUTE_VALUE;
          }
        case 36: break;
        case 20: 
          { yybegin(IN_TAG); return TAG_SYMBOLS;
          }
        case 37: break;
        case 13: 
          { yybegin(IN_TAG); return PLAIN_STYLE;
          }
        case 38: break;
        case 14: 
          { yybegin(IN_TAG); return TAG_NAME;
          }
        case 39: break;
        case 3: 
          { mReturningStateTag = yystate(); yybegin(IN_RIFE_NAME); return RIFE_NAME;
          }
        case 40: break;
        case 10: 
          { mReturningStateTag = yystate(); yybegin(IN_RIFE_NAME_QUOTED); return RIFE_NAME;
          }
        case 41: break;
        case 31: 
          { mReturningState = yystate(); yybegin(IN_RIFE_TAG_COMMENT); return RIFE_TAG;
          }
        case 42: break;
        case 24: 
          { yybegin(YYINITIAL); return PROCESSING_INSTRUCTION;
          }
        case 43: break;
        case 28: 
          { mReturningState = yystate(); yybegin(IN_RIFE_TAG_COMPACT); return RIFE_TAG;
          }
        case 44: break;
        case 22: 
          { return PROCESSING_INSTRUCTION;
          }
        case 45: break;
        case 8: 
          { mReturningStateTag = yystate(); yybegin(IN_RIFE_NAME_SINGLEQUOTED); return RIFE_NAME;
          }
        case 46: break;
        case 15: 
          { yybegin(YYINITIAL); return TAG_SYMBOLS;
          }
        case 47: break;
        case 30: 
          { mReturningState = yystate(); yybegin(IN_RIFE_TAG_REGULAR); return RIFE_TAG;
          }
        case 48: break;
        case 11: 
          { return RIFE_NAME;
          }
        case 49: break;
        case 23: 
          { yybegin(IN_PROCESSING_INSTRUCTION); return PROCESSING_INSTRUCTION;
          }
        case 50: break;
        case 17: 
          { return TAG_SYMBOLS;
          }
        case 51: break;
        case 29: 
          { mReturningState = yystate(); yybegin(IN_RIFE_TAG_VELOCITY); return RIFE_TAG;
          }
        case 52: break;
        case 1: 
          { return PLAIN_STYLE;
          }
        case 53: break;
        case 2: 
          { return RIFE_TAG;
          }
        case 54: break;
        case 18: 
          { yybegin(IN_SINGLE_QUOTE_STRING); return ATTRIBUTE_VALUE;
          }
        case 55: break;
        case 26: 
          { yybegin(YYINITIAL); return CHAR_DATA;
          }
        case 56: break;
        case 25: 
          { yybegin(YYINITIAL); return COMMENT;
          }
        case 57: break;
        case 19: 
          { yybegin(IN_DOUBLE_QUOTE_STRING); return ATTRIBUTE_VALUE;
          }
        case 58: break;
        case 32: 
          { yybegin(IN_CDATA_SECTION); return CHAR_DATA;
          }
        case 59: break;
        case 12: 
          { yybegin(mReturningStateTag); return RIFE_NAME;
          }
        case 60: break;
        case 16: 
          { return ATTRIBUTE_NAME;
          }
        case 61: break;
        case 6: 
          { return CHAR_DATA;
          }
        case 62: break;
        case 9: 
          { yybegin(mReturningState); return RIFE_TAG;
          }
        case 63: break;
        case 7: 
          { yybegin(TAG_START); return TAG_SYMBOLS;
          }
        case 64: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            return YYEOF;
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
