/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.generators.xml;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.util.DefaultXmlPrettyPrinter;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.cyclonedx.CycloneDxSchema;
import org.cyclonedx.exception.GeneratorException;
import org.cyclonedx.generators.xml.BomXmlGenerator;
import org.cyclonedx.model.Bom;
import org.cyclonedx.util.CollectionTypeSerializer;
import org.cyclonedx.util.VersionXmlAnnotationIntrospector;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AbstractBomXmlGenerator
extends CycloneDxSchema
implements BomXmlGenerator {
    private final ObjectMapper mapper = new XmlMapper();
    private final DefaultXmlPrettyPrinter prettyPrinter = new DefaultXmlPrettyPrinter();
    Document doc;
    protected static final String PROLOG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";

    public AbstractBomXmlGenerator() {
        this.setupObjectMapper(this.mapper);
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    private void setupObjectMapper(ObjectMapper mapper) {
        mapper.setAnnotationIntrospector((AnnotationIntrospector)new VersionXmlAnnotationIntrospector(String.valueOf(this.getSchemaVersion().getVersion())));
        if (this.getSchemaVersion().getVersion() != 1.0) {
            if (this.getSchemaVersion().getVersion() == 1.1) {
                this.registerDependencyModule(mapper, true);
            } else if (this.getSchemaVersion().getVersion() == 1.2) {
                this.registerDependencyModule(mapper, false);
            } else if (this.getSchemaVersion().getVersion() == 1.3) {
                this.registerDependencyModule(mapper, false);
            } else if (this.getSchemaVersion().getVersion() == 1.4) {
                this.registerDependencyModule(mapper, false);
            }
        }
    }

    private void registerDependencyModule(ObjectMapper mapper, boolean useNamespace) {
        SimpleModule depModule = new SimpleModule();
        depModule.setSerializers((SimpleSerializers)new CollectionTypeSerializer(useNamespace));
        mapper.registerModule((Module)depModule);
    }

    public DocumentBuilder buildSecureDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setNamespaceAware(true);
        return factory.newDocumentBuilder();
    }

    protected Document generateDocument(Bom bom) throws ParserConfigurationException {
        try {
            DocumentBuilder docBuilder = this.buildSecureDocumentBuilder();
            this.doc = docBuilder.parse(new InputSource(new StringReader(this.toXML(bom, false))));
            this.doc.setXmlStandalone(true);
            return this.doc;
        }
        catch (IOException | ParserConfigurationException | GeneratorException | SAXException ex) {
            throw new ParserConfigurationException(ex.toString());
        }
    }

    String toXML(Bom bom, boolean prettyPrint) throws GeneratorException {
        try {
            if (prettyPrint) {
                return PROLOG + System.lineSeparator() + this.mapper.writer((PrettyPrinter)this.prettyPrinter).writeValueAsString((Object)bom);
            }
            return PROLOG + this.mapper.writeValueAsString((Object)bom);
        }
        catch (JsonProcessingException ex) {
            throw new GeneratorException(ex);
        }
    }

    @Override
    public String toString() {
        try {
            return this.toXmlString();
        }
        catch (Exception e) {
            return "";
        }
    }
}

