/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.parsers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.ValidationMessage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.cyclonedx.CycloneDxSchema;
import org.cyclonedx.exception.ParseException;
import org.cyclonedx.model.Bom;
import org.cyclonedx.parsers.Parser;

public class JsonParser
extends CycloneDxSchema
implements Parser {
    private final ObjectMapper mapper = new ObjectMapper();

    @Override
    public Bom parse(File file) throws ParseException {
        try {
            return (Bom)this.mapper.readValue(file, Bom.class);
        }
        catch (IOException e) {
            throw new ParseException("Unable to parse BOM from File", e);
        }
    }

    @Override
    public Bom parse(byte[] bomBytes) throws ParseException {
        try {
            return (Bom)this.mapper.readValue(bomBytes, Bom.class);
        }
        catch (IOException | RuntimeException e) {
            throw new ParseException("Unable to parse BOM from byte array", e);
        }
    }

    @Override
    public Bom parse(InputStream inputStream) throws ParseException {
        try {
            return (Bom)this.mapper.readValue(inputStream, Bom.class);
        }
        catch (IOException e) {
            throw new ParseException("Unable to parse BOM from InputStream", e);
        }
    }

    @Override
    public Bom parse(Reader reader) throws ParseException {
        try {
            return (Bom)this.mapper.readValue(reader, Bom.class);
        }
        catch (IOException e) {
            throw new ParseException("Unable to parse BOM from Reader", e);
        }
    }

    @Override
    public List<ParseException> validate(File file) throws IOException {
        return this.validate(file, CycloneDxSchema.VERSION_LATEST);
    }

    @Override
    public List<ParseException> validate(File file, CycloneDxSchema.Version schemaVersion) throws IOException {
        return this.validate(FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8), schemaVersion);
    }

    @Override
    public List<ParseException> validate(byte[] bomBytes) throws IOException {
        return this.validate(bomBytes, CycloneDxSchema.VERSION_LATEST);
    }

    @Override
    public List<ParseException> validate(byte[] bomBytes, CycloneDxSchema.Version schemaVersion) throws IOException {
        return this.validate(new String(bomBytes), schemaVersion);
    }

    @Override
    public List<ParseException> validate(Reader reader) throws IOException {
        return this.validate(reader, CycloneDxSchema.VERSION_LATEST);
    }

    @Override
    public List<ParseException> validate(Reader reader, CycloneDxSchema.Version schemaVersion) throws IOException {
        return this.validate(IOUtils.toString((Reader)reader), schemaVersion);
    }

    @Override
    public List<ParseException> validate(InputStream inputStream) throws IOException {
        return this.validate(inputStream, CycloneDxSchema.VERSION_LATEST);
    }

    @Override
    public List<ParseException> validate(InputStream inputStream, CycloneDxSchema.Version schemaVersion) throws IOException {
        return this.validate(IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8), schemaVersion);
    }

    public List<ParseException> validate(String bomString, CycloneDxSchema.Version schemaVersion) throws IOException {
        return this.validate(this.mapper.readTree(bomString), schemaVersion);
    }

    public List<ParseException> validate(JsonNode bomJson, CycloneDxSchema.Version schemaVersion) throws IOException {
        ArrayList<ParseException> exceptions = new ArrayList<ParseException>();
        Set errors = this.getJsonSchema(schemaVersion, this.mapper).validate(this.mapper.readTree(bomJson.toString()));
        for (ValidationMessage message : errors) {
            exceptions.add(new ParseException(message.getMessage()));
        }
        return exceptions;
    }

    @Override
    public boolean isValid(File file) throws IOException {
        return this.validate(file).isEmpty();
    }

    @Override
    public boolean isValid(File file, CycloneDxSchema.Version schemaVersion) throws IOException {
        return this.validate(file, schemaVersion).isEmpty();
    }

    @Override
    public boolean isValid(byte[] bomBytes) throws IOException {
        return this.validate(bomBytes).isEmpty();
    }

    @Override
    public boolean isValid(byte[] bomBytes, CycloneDxSchema.Version schemaVersion) throws IOException {
        return this.validate(bomBytes, schemaVersion).isEmpty();
    }

    @Override
    public boolean isValid(Reader reader) throws IOException {
        return this.validate(reader).isEmpty();
    }

    @Override
    public boolean isValid(Reader reader, CycloneDxSchema.Version schemaVersion) throws IOException {
        return this.validate(reader, schemaVersion).isEmpty();
    }

    @Override
    public boolean isValid(InputStream inputStream) throws IOException {
        return this.validate(inputStream).isEmpty();
    }

    @Override
    public boolean isValid(InputStream inputStream, CycloneDxSchema.Version schemaVersion) throws IOException {
        return this.validate(inputStream, schemaVersion).isEmpty();
    }
}

