/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.maven;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.CumulativeScopeArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalysis;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalyzer;
import org.apache.maven.shared.dependency.graph.DependencyCollectorBuilder;
import org.apache.maven.shared.dependency.graph.DependencyCollectorBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.CollectingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.cyclonedx.BomGeneratorFactory;
import org.cyclonedx.CycloneDxSchema;
import org.cyclonedx.exception.GeneratorException;
import org.cyclonedx.generators.xml.BomXmlGenerator;
import org.cyclonedx.model.Bom;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Dependency;
import org.cyclonedx.model.ExternalReference;
import org.cyclonedx.model.LicenseChoice;
import org.cyclonedx.model.Metadata;
import org.cyclonedx.model.Tool;
import org.cyclonedx.parsers.JsonParser;
import org.cyclonedx.parsers.Parser;
import org.cyclonedx.parsers.XmlParser;
import org.cyclonedx.util.BomUtils;
import org.cyclonedx.util.LicenseResolver;

public abstract class BaseCycloneDxMojo
extends AbstractMojo
implements Contextualizable {
    @Parameter(property="session", readonly=true, required=true)
    private MavenSession session;
    @Parameter(property="project", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="projectType", defaultValue="library", required=false)
    private String projectType;
    @Parameter(property="schemaVersion", defaultValue="1.4", required=false)
    private String schemaVersion;
    @Parameter(property="outputFormat", defaultValue="all", required=false)
    private String outputFormat;
    @Parameter(property="outputName", defaultValue="bom", required=false)
    private String outputName;
    @Parameter(property="includeBomSerialNumber", defaultValue="true", required=false)
    private Boolean includeBomSerialNumber;
    @Parameter(property="includeCompileScope", defaultValue="true", required=false)
    private Boolean includeCompileScope;
    @Parameter(property="includeProvidedScope", defaultValue="true", required=false)
    private Boolean includeProvidedScope;
    @Parameter(property="includeRuntimeScope", defaultValue="true", required=false)
    private Boolean includeRuntimeScope;
    @Parameter(property="includeTestScope", defaultValue="false", required=false)
    private Boolean includeTestScope;
    @Parameter(property="includeSystemScope", defaultValue="true", required=false)
    private Boolean includeSystemScope;
    @Parameter(property="includeLicenseText", defaultValue="false", required=false)
    private Boolean includeLicenseText;
    @Parameter(property="excludeTypes", required=false)
    private String[] excludeTypes;
    @Parameter(property="excludeArtifactId", required=false)
    protected String[] excludeArtifactId;
    @Parameter(property="excludeGroupId", required=false)
    protected String[] excludeGroupId;
    @Parameter(property="excludeTestProject", defaultValue="false", required=false)
    protected Boolean excludeTestProject;
    @Parameter(property="cyclonedx.skip", defaultValue="false", required=false)
    private boolean skip = false;
    @Parameter(property="cyclonedx.skipAttach", defaultValue="false", required=false)
    private boolean skipAttach = false;
    @Parameter(property="cyclonedx.verbose", defaultValue="true", required=false)
    private boolean verbose = true;
    @org.apache.maven.plugins.annotations.Component
    private MavenProjectHelper mavenProjectHelper;
    @org.apache.maven.plugins.annotations.Component
    private DependencyCollectorBuilder dependencyCollectorBuilder;
    @org.apache.maven.plugins.annotations.Component
    private RepositorySystem repositorySystem;
    @org.apache.maven.plugins.annotations.Component
    private ProjectBuilder mavenProjectBuilder;
    protected static final String MESSAGE_RESOLVING_DEPS = "CycloneDX: Resolving Dependencies";
    protected static final String MESSAGE_CREATING_BOM = "CycloneDX: Creating BOM";
    protected static final String MESSAGE_CALCULATING_HASHES = "CycloneDX: Calculating Hashes";
    protected static final String MESSAGE_WRITING_BOM = "CycloneDX: Writing BOM (%s): %s";
    protected static final String MESSAGE_VALIDATING_BOM = "CycloneDX: Validating BOM (%s): %s";
    protected static final String MESSAGE_VALIDATION_FAILURE = "The BOM does not conform to the CycloneDX BOM standard as defined by the XSD";
    private Context context;
    @Parameter(property="analyzer", defaultValue="default")
    private String analyzer;
    protected ProjectDependencyAnalyzer dependencyAnalyzer;

    protected MavenProject getProject() {
        return this.project;
    }

    protected boolean shouldInclude(Artifact artifact) {
        boolean shouldExclude;
        if (artifact.getScope() == null) {
            return false;
        }
        if (this.excludeTypes != null && (shouldExclude = Arrays.asList(this.excludeTypes).contains(artifact.getType()))) {
            return false;
        }
        if (this.includeCompileScope.booleanValue() && "compile".equals(artifact.getScope())) {
            return true;
        }
        if (this.includeProvidedScope.booleanValue() && "provided".equals(artifact.getScope())) {
            return true;
        }
        if (this.includeRuntimeScope.booleanValue() && "runtime".equals(artifact.getScope())) {
            return true;
        }
        if (this.includeTestScope.booleanValue() && "test".equals(artifact.getScope())) {
            return true;
        }
        return this.includeSystemScope != false && "system".equals(artifact.getScope());
    }

    protected Metadata convert(MavenProject project) {
        Tool tool = new Tool();
        Properties properties = this.readPluginProperties();
        tool.setVendor(properties.getProperty("vendor"));
        tool.setName(properties.getProperty("name"));
        tool.setVersion(properties.getProperty("version"));
        DefaultArtifact self = new DefaultArtifact(properties.getProperty("groupId"), properties.getProperty("artifactId"), properties.getProperty("version"), "compile", "jar", null, (ArtifactHandler)new DefaultArtifactHandler());
        Artifact resolved = this.session.getLocalRepository().find((Artifact)self);
        if (resolved != null) {
            try {
                resolved.setFile(new File(resolved.getFile() + ".jar"));
                tool.setHashes(BomUtils.calculateHashes((File)resolved.getFile(), (CycloneDxSchema.Version)this.schemaVersion()));
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)"Unable to calculate hashes of self", (Throwable)e);
            }
        }
        Component component = new Component();
        component.setGroup(project.getGroupId());
        component.setName(project.getArtifactId());
        component.setVersion(project.getVersion());
        component.setType(this.resolveProjectType());
        component.setPurl(this.generatePackageUrl(project.getArtifact()));
        component.setBomRef(component.getPurl());
        this.extractComponentMetadata(project, component);
        Metadata metadata = new Metadata();
        metadata.addTool(tool);
        metadata.setComponent(component);
        return metadata;
    }

    private Properties readPluginProperties() {
        Properties props = new Properties();
        try {
            props.load(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("plugin.properties"));
        }
        catch (IOException | NullPointerException e) {
            this.getLog().warn((CharSequence)"Unable to load plugin.properties", (Throwable)e);
        }
        return props;
    }

    protected Component convert(Artifact artifact) {
        Component component = new Component();
        component.setGroup(artifact.getGroupId());
        component.setName(artifact.getArtifactId());
        component.setVersion(artifact.getBaseVersion());
        component.setType(Component.Type.LIBRARY);
        try {
            this.getLog().debug((CharSequence)MESSAGE_CALCULATING_HASHES);
            component.setHashes(BomUtils.calculateHashes((File)artifact.getFile(), (CycloneDxSchema.Version)this.schemaVersion()));
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Error encountered calculating hashes", (Throwable)e);
        }
        if (CycloneDxSchema.Version.VERSION_10 == this.schemaVersion()) {
            component.setModified(Boolean.valueOf(this.isModified(artifact)));
        }
        component.setPurl(this.generatePackageUrl(artifact));
        if (CycloneDxSchema.Version.VERSION_10 != this.schemaVersion()) {
            component.setBomRef(component.getPurl());
        }
        if (this.isDescribedArtifact(artifact)) {
            try {
                MavenProject project = this.getEffectiveMavenProject(artifact);
                if (project != null) {
                    this.extractComponentMetadata(project, component);
                }
            }
            catch (ProjectBuildingException e) {
                this.getLog().warn((CharSequence)("An unexpected issue occurred attempting to resolve the effective pom for  " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion()), (Throwable)e);
            }
        }
        return component;
    }

    private String generatePackageUrl(Artifact artifact) {
        TreeMap<String, String> qualifiers = null;
        if (artifact.getType() != null || artifact.getClassifier() != null) {
            qualifiers = new TreeMap<String, String>();
            if (artifact.getType() != null) {
                qualifiers.put("type", artifact.getType());
            }
            if (artifact.getClassifier() != null) {
                qualifiers.put("classifier", artifact.getClassifier());
            }
        }
        return this.generatePackageUrl(artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion(), qualifiers, null);
    }

    private String generatePackageUrl(String groupId, String artifactId, String version, TreeMap<String, String> qualifiers, String subpath) {
        try {
            return new PackageURL("maven", groupId, artifactId, version, qualifiers, subpath).canonicalize();
        }
        catch (MalformedPackageURLException e) {
            this.getLog().warn((CharSequence)("An unexpected issue occurred attempting to create a PackageURL for " + groupId + ":" + artifactId + ":" + version), (Throwable)e);
            return null;
        }
    }

    private MavenProject getEffectiveMavenProject(Artifact artifact) throws ProjectBuildingException {
        Artifact pomArtifact = this.repositorySystem.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        ProjectBuildingResult build = this.mavenProjectBuilder.build(pomArtifact, this.session.getProjectBuildingRequest().setValidationLevel(0));
        return build.getProject();
    }

    private void extractComponentMetadata(MavenProject project, Component component) {
        if (component.getPublisher() == null && project.getOrganization() != null) {
            component.setPublisher(project.getOrganization().getName());
        }
        if (component.getDescription() == null) {
            component.setDescription(project.getDescription());
        }
        if ((component.getLicenseChoice() == null || component.getLicenseChoice().getLicenses() == null || component.getLicenseChoice().getLicenses().isEmpty()) && project.getLicenses() != null) {
            component.setLicenseChoice(this.resolveMavenLicenses(project.getLicenses()));
        }
        if (CycloneDxSchema.Version.VERSION_10 != this.schemaVersion()) {
            if (project.getUrl() != null && !this.doesComponentHaveExternalReference(component, ExternalReference.Type.WEBSITE)) {
                this.addExternalReference(ExternalReference.Type.WEBSITE, project.getUrl(), component);
            }
            if (project.getCiManagement() != null && project.getCiManagement().getUrl() != null && !this.doesComponentHaveExternalReference(component, ExternalReference.Type.BUILD_SYSTEM)) {
                this.addExternalReference(ExternalReference.Type.BUILD_SYSTEM, project.getCiManagement().getUrl(), component);
            }
            if (project.getDistributionManagement() != null && project.getDistributionManagement().getDownloadUrl() != null && !this.doesComponentHaveExternalReference(component, ExternalReference.Type.DISTRIBUTION)) {
                this.addExternalReference(ExternalReference.Type.DISTRIBUTION, project.getDistributionManagement().getDownloadUrl(), component);
            }
            if (project.getDistributionManagement() != null && project.getDistributionManagement().getRepository() != null && !this.doesComponentHaveExternalReference(component, ExternalReference.Type.DISTRIBUTION)) {
                this.addExternalReference(ExternalReference.Type.DISTRIBUTION, project.getDistributionManagement().getRepository().getUrl(), component);
            }
            if (project.getIssueManagement() != null && project.getIssueManagement().getUrl() != null && !this.doesComponentHaveExternalReference(component, ExternalReference.Type.ISSUE_TRACKER)) {
                this.addExternalReference(ExternalReference.Type.ISSUE_TRACKER, project.getIssueManagement().getUrl(), component);
            }
            if (project.getMailingLists() != null && project.getMailingLists().size() > 0) {
                for (MailingList list : project.getMailingLists()) {
                    if (list.getArchive() != null) {
                        if (this.doesComponentHaveExternalReference(component, ExternalReference.Type.MAILING_LIST)) continue;
                        this.addExternalReference(ExternalReference.Type.MAILING_LIST, list.getArchive(), component);
                        continue;
                    }
                    if (list.getSubscribe() == null || this.doesComponentHaveExternalReference(component, ExternalReference.Type.MAILING_LIST)) continue;
                    this.addExternalReference(ExternalReference.Type.MAILING_LIST, list.getSubscribe(), component);
                }
            }
            if (project.getScm() != null && project.getScm().getUrl() != null && !this.doesComponentHaveExternalReference(component, ExternalReference.Type.VCS)) {
                this.addExternalReference(ExternalReference.Type.VCS, project.getScm().getUrl(), component);
            }
        }
    }

    private void addExternalReference(ExternalReference.Type referenceType, String url, Component component) {
        try {
            URI uri = new URI(url.trim());
            ExternalReference ref = new ExternalReference();
            ref.setType(referenceType);
            ref.setUrl(uri.toString());
            component.addExternalReference(ref);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    private boolean doesComponentHaveExternalReference(Component component, ExternalReference.Type type) {
        if (component.getExternalReferences() != null && !component.getExternalReferences().isEmpty()) {
            for (ExternalReference ref : component.getExternalReferences()) {
                if (type != ref.getType()) continue;
                return true;
            }
        }
        return false;
    }

    private LicenseChoice resolveMavenLicenses(List<License> projectLicenses) {
        LicenseChoice licenseChoice = new LicenseChoice();
        for (License artifactLicense : projectLicenses) {
            boolean resolved = false;
            if (artifactLicense.getName() != null) {
                LicenseChoice resolvedByName = LicenseResolver.resolve((String)artifactLicense.getName(), (boolean)this.includeLicenseText);
                resolved = this.resolveLicenseInfo(licenseChoice, resolvedByName);
            }
            if (artifactLicense.getUrl() != null && !resolved) {
                LicenseChoice resolvedByUrl = LicenseResolver.resolve((String)artifactLicense.getUrl(), (boolean)this.includeLicenseText);
                resolved = this.resolveLicenseInfo(licenseChoice, resolvedByUrl);
            }
            if (artifactLicense.getName() == null || resolved) continue;
            org.cyclonedx.model.License license = new org.cyclonedx.model.License();
            license.setName(artifactLicense.getName().trim());
            if (StringUtils.isNotBlank((CharSequence)artifactLicense.getUrl())) {
                try {
                    URI uri = new URI(artifactLicense.getUrl().trim());
                    license.setUrl(uri.toString());
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            licenseChoice.addLicense(license);
        }
        return licenseChoice;
    }

    private boolean resolveLicenseInfo(LicenseChoice licenseChoice, LicenseChoice licenseChoiceToResolve) {
        if (licenseChoiceToResolve != null) {
            if (licenseChoiceToResolve.getLicenses() != null && !licenseChoiceToResolve.getLicenses().isEmpty()) {
                licenseChoice.addLicense((org.cyclonedx.model.License)licenseChoiceToResolve.getLicenses().get(0));
                return true;
            }
            if (licenseChoiceToResolve.getExpression() != null && CycloneDxSchema.Version.VERSION_10 != this.schemaVersion()) {
                licenseChoice.setExpression(licenseChoiceToResolve.getExpression());
                return true;
            }
        }
        return false;
    }

    protected abstract boolean analyze(Set<Component> var1, Set<Dependency> var2) throws MojoExecutionException;

    public void execute() throws MojoExecutionException {
        boolean shouldSkip = Boolean.parseBoolean(System.getProperty("cyclonedx.skip", Boolean.toString(this.skip)));
        if (shouldSkip) {
            this.getLog().info((CharSequence)"Skipping CycloneDX");
            return;
        }
        this.logParameters();
        LinkedHashSet<Component> components = new LinkedHashSet<Component>();
        LinkedHashSet<Dependency> dependencies = new LinkedHashSet<Dependency>();
        if (this.analyze(components, dependencies)) {
            this.generateBom(components, dependencies);
        }
    }

    private void generateBom(Set<Component> components, Set<Dependency> dependencies) throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)MESSAGE_CREATING_BOM);
            Bom bom = new Bom();
            if (this.schemaVersion().getVersion() >= 1.1 && this.includeBomSerialNumber.booleanValue()) {
                bom.setSerialNumber("urn:uuid:" + UUID.randomUUID());
            }
            if (this.schemaVersion().getVersion() >= 1.2) {
                Metadata metadata = this.convert(this.project);
                bom.setMetadata(metadata);
            }
            bom.setComponents(new ArrayList<Component>(components));
            if (this.schemaVersion().getVersion() >= 1.2 && dependencies != null && !dependencies.isEmpty()) {
                bom.setDependencies(new ArrayList<Dependency>(dependencies));
            }
            if (this.schemaVersion().getVersion() >= 1.3) {
                // empty if block
            }
            if (!(this.outputFormat.trim().equalsIgnoreCase("all") || this.outputFormat.trim().equalsIgnoreCase("xml") || this.outputFormat.trim().equalsIgnoreCase("json"))) {
                this.getLog().error((CharSequence)"Unsupported output format. Valid options are XML and JSON");
                return;
            }
            this.saveBom(bom);
        }
        catch (IOException | ParserConfigurationException | GeneratorException e) {
            throw new MojoExecutionException("An error occurred executing " + ((Object)((Object)this)).getClass().getName() + ": " + e.getMessage(), (Exception)e);
        }
    }

    private void saveBom(Bom bom) throws ParserConfigurationException, IOException, GeneratorException, MojoExecutionException {
        String bomString;
        BomXmlGenerator bomGenerator;
        if (this.outputFormat.trim().equalsIgnoreCase("all") || this.outputFormat.trim().equalsIgnoreCase("xml")) {
            bomGenerator = BomGeneratorFactory.createXml((CycloneDxSchema.Version)this.schemaVersion(), (Bom)bom);
            bomGenerator.generate();
            bomString = bomGenerator.toXmlString();
            this.saveBomToFile(bomString, "xml", (Parser)new XmlParser());
        }
        if (this.outputFormat.trim().equalsIgnoreCase("all") || this.outputFormat.trim().equalsIgnoreCase("json")) {
            bomGenerator = BomGeneratorFactory.createJson((CycloneDxSchema.Version)this.schemaVersion(), (Bom)bom);
            bomString = bomGenerator.toJsonString();
            this.saveBomToFile(bomString, "json", (Parser)new JsonParser());
        }
    }

    private void saveBomToFile(String bomString, String extension, Parser bomParser) throws IOException, MojoExecutionException {
        File bomFile = new File(this.project.getBasedir(), "target/" + this.outputName + "." + extension);
        this.getLog().info((CharSequence)String.format(MESSAGE_WRITING_BOM, extension.toUpperCase(), bomFile.getAbsolutePath()));
        FileUtils.write((File)bomFile, (CharSequence)bomString, (Charset)StandardCharsets.UTF_8, (boolean)false);
        this.getLog().info((CharSequence)String.format(MESSAGE_VALIDATING_BOM, extension.toUpperCase(), bomFile.getAbsolutePath()));
        if (!bomParser.isValid(bomFile, this.schemaVersion())) {
            throw new MojoExecutionException(MESSAGE_VALIDATION_FAILURE);
        }
        if (!this.skipAttach) {
            this.mavenProjectHelper.attachArtifact(this.project, extension, "cyclonedx", bomFile);
        }
    }

    private boolean isModified(Artifact artifact) {
        return false;
    }

    private boolean isDescribedArtifact(Artifact artifact) {
        return artifact.getType().equalsIgnoreCase("jar");
    }

    protected CycloneDxSchema.Version schemaVersion() {
        if ("1.0".equals(this.schemaVersion)) {
            return CycloneDxSchema.Version.VERSION_10;
        }
        if ("1.1".equals(this.schemaVersion)) {
            return CycloneDxSchema.Version.VERSION_11;
        }
        if ("1.2".equals(this.schemaVersion)) {
            return CycloneDxSchema.Version.VERSION_12;
        }
        if ("1.3".equals(this.schemaVersion)) {
            return CycloneDxSchema.Version.VERSION_13;
        }
        return CycloneDxSchema.Version.VERSION_14;
    }

    private Component.Type resolveProjectType() {
        for (Component.Type type : Component.Type.values()) {
            if (!type.getTypeName().equalsIgnoreCase(this.projectType)) continue;
            return type;
        }
        this.getLog().warn((CharSequence)"Invalid project type. Defaulting to 'library'");
        this.getLog().warn((CharSequence)"Valid types are:");
        for (Component.Type type : Component.Type.values()) {
            this.getLog().warn((CharSequence)("  " + type.getTypeName()));
        }
        return Component.Type.LIBRARY;
    }

    protected Set<Dependency> buildDependencyGraph(Set<String> componentRefs, MavenProject mavenProject) throws MojoExecutionException {
        LinkedHashSet<Dependency> dependencies = new LinkedHashSet<Dependency>();
        HashSet<String> scope = new HashSet<String>();
        if (this.includeCompileScope.booleanValue()) {
            scope.add("compile");
        }
        if (this.includeProvidedScope.booleanValue()) {
            scope.add("provided");
        }
        if (this.includeRuntimeScope.booleanValue()) {
            scope.add("runtime");
        }
        if (this.includeSystemScope.booleanValue()) {
            scope.add("system");
        }
        if (this.includeTestScope.booleanValue()) {
            scope.add("test");
        }
        CumulativeScopeArtifactFilter artifactFilter = new CumulativeScopeArtifactFilter(scope);
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        if (mavenProject != null) {
            buildingRequest.setProject(mavenProject);
        } else {
            buildingRequest.setProject(this.project);
        }
        try {
            DependencyNode rootNode = this.dependencyCollectorBuilder.collectDependencyGraph((ProjectBuildingRequest)buildingRequest, (ArtifactFilter)artifactFilter);
            this.buildDependencyGraphNode(componentRefs, dependencies, rootNode, null);
            CollectingDependencyNodeVisitor visitor = new CollectingDependencyNodeVisitor();
            rootNode.accept((DependencyNodeVisitor)visitor);
            for (DependencyNode dependencyNode : visitor.getNodes()) {
                this.buildDependencyGraphNode(componentRefs, dependencies, dependencyNode, null);
            }
        }
        catch (DependencyCollectorBuilderException e) {
            if (mavenProject != null) {
                this.getLog().warn((CharSequence)("An error occurred building dependency graph: " + e.getMessage()));
            }
            throw new MojoExecutionException("An error occurred building dependency graph", (Exception)((Object)e));
        }
        return dependencies;
    }

    private void buildDependencyGraphNode(Set<String> componentRefs, Set<Dependency> dependencies, DependencyNode artifactNode, Dependency parent) {
        String purl = this.generatePackageUrl(artifactNode.getArtifact());
        Dependency dependency = new Dependency(purl);
        String parentRef = parent != null ? parent.getRef() : null;
        componentRefs.stream().filter(s -> s != null && s.equals(purl)).forEach(s -> this.addDependencyToGraph(dependencies, parentRef, dependency));
        for (DependencyNode childrenNode : artifactNode.getChildren()) {
            this.buildDependencyGraphNode(componentRefs, dependencies, childrenNode, dependency);
        }
    }

    private void addDependencyToGraph(Set<Dependency> dependencies, String parentRef, Dependency dependency) {
        if (parentRef == null) {
            dependencies.add(dependency);
        } else {
            for (Dependency d : dependencies) {
                if (!d.getRef().equals(parentRef) || parentRef.equals(dependency.getRef())) continue;
                d.addDependency(dependency);
            }
        }
    }

    protected void addMavenProjectsAsDependencies(List<MavenProject> reactorProjects, Set<Dependency> dependencies) {
        for (Dependency dependency : dependencies) {
            for (MavenProject project : reactorProjects) {
                if (!project.hasParent()) continue;
                String parentRef = this.generatePackageUrl(project.getParentArtifact());
                if (dependency.getRef() == null || !dependency.getRef().equals(parentRef)) continue;
                Dependency child = new Dependency(this.generatePackageUrl(project.getArtifact()));
                dependency.addDependency(child);
            }
        }
    }

    protected void logAdditionalParameters() {
    }

    protected void logParameters() {
        if (this.verbose && this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)"CycloneDX: Parameters");
            this.getLog().info((CharSequence)"------------------------------------------------------------------------");
            this.getLog().info((CharSequence)("schemaVersion          : " + this.schemaVersion().getVersionString()));
            this.getLog().info((CharSequence)("includeBomSerialNumber : " + this.includeBomSerialNumber));
            this.getLog().info((CharSequence)("includeCompileScope    : " + this.includeCompileScope));
            this.getLog().info((CharSequence)("includeProvidedScope   : " + this.includeProvidedScope));
            this.getLog().info((CharSequence)("includeRuntimeScope    : " + this.includeRuntimeScope));
            this.getLog().info((CharSequence)("includeTestScope       : " + this.includeTestScope));
            this.getLog().info((CharSequence)("includeSystemScope     : " + this.includeSystemScope));
            this.getLog().info((CharSequence)("includeLicenseText     : " + this.includeLicenseText));
            this.getLog().info((CharSequence)("outputFormat           : " + this.outputFormat));
            this.getLog().info((CharSequence)("outputName             : " + this.outputName));
            this.logAdditionalParameters();
            this.getLog().info((CharSequence)"------------------------------------------------------------------------");
        }
    }

    public void contextualize(Context theContext) {
        this.context = theContext;
    }

    protected ProjectDependencyAnalyzer createProjectDependencyAnalyzer() throws MojoExecutionException {
        String role = ProjectDependencyAnalyzer.class.getName();
        String roleHint = this.analyzer;
        try {
            PlexusContainer container = (PlexusContainer)this.context.get((Object)"plexus");
            return (ProjectDependencyAnalyzer)container.lookup(role, roleHint);
        }
        catch (Exception exception) {
            throw new MojoExecutionException("Failed to instantiate ProjectDependencyAnalyser with role " + role + " / role-hint " + roleHint, exception);
        }
    }

    protected Component.Scope getComponentScope(Component component, Artifact artifact, ProjectDependencyAnalysis dependencyAnalysis) {
        if (dependencyAnalysis == null) {
            return null;
        }
        Set usedDeclaredArtifacts = dependencyAnalysis.getUsedDeclaredArtifacts();
        Set usedUndeclaredArtifacts = dependencyAnalysis.getUsedUndeclaredArtifacts();
        Set unusedDeclaredArtifacts = dependencyAnalysis.getUnusedDeclaredArtifacts();
        Set testArtifactsWithNonTestScope = dependencyAnalysis.getTestArtifactsWithNonTestScope();
        if (usedDeclaredArtifacts.contains(artifact) || usedUndeclaredArtifacts.contains(artifact)) {
            return Component.Scope.REQUIRED;
        }
        if (unusedDeclaredArtifacts.contains(artifact) || testArtifactsWithNonTestScope.contains(artifact)) {
            return Component.Scope.OPTIONAL;
        }
        return null;
    }
}

